﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/quicksight/QuickSight_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace QuickSight {
namespace Model {

/**
 * <p>A structure that represents a negative format.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/NegativeFormat">AWS
 * API Reference</a></p>
 */
class NegativeFormat {
 public:
  AWS_QUICKSIGHT_API NegativeFormat() = default;
  AWS_QUICKSIGHT_API NegativeFormat(Aws::Utils::Json::JsonView jsonValue);
  AWS_QUICKSIGHT_API NegativeFormat& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_QUICKSIGHT_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The prefix for a negative format.</p>
   */
  inline const Aws::String& GetPrefix() const { return m_prefix; }
  inline bool PrefixHasBeenSet() const { return m_prefixHasBeenSet; }
  template <typename PrefixT = Aws::String>
  void SetPrefix(PrefixT&& value) {
    m_prefixHasBeenSet = true;
    m_prefix = std::forward<PrefixT>(value);
  }
  template <typename PrefixT = Aws::String>
  NegativeFormat& WithPrefix(PrefixT&& value) {
    SetPrefix(std::forward<PrefixT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The suffix for a negative format.</p>
   */
  inline const Aws::String& GetSuffix() const { return m_suffix; }
  inline bool SuffixHasBeenSet() const { return m_suffixHasBeenSet; }
  template <typename SuffixT = Aws::String>
  void SetSuffix(SuffixT&& value) {
    m_suffixHasBeenSet = true;
    m_suffix = std::forward<SuffixT>(value);
  }
  template <typename SuffixT = Aws::String>
  NegativeFormat& WithSuffix(SuffixT&& value) {
    SetSuffix(std::forward<SuffixT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_prefix;

  Aws::String m_suffix;
  bool m_prefixHasBeenSet = false;
  bool m_suffixHasBeenSet = false;
};

}  // namespace Model
}  // namespace QuickSight
}  // namespace Aws
