﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sagemaker/SageMaker_EXPORTS.h>
#include <aws/sagemaker/model/TrialSource.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SageMaker {
namespace Model {

/**
 * <p>A summary of the properties of a trial. To get the complete set of
 * properties, call the <a
 * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeTrial.html">DescribeTrial</a>
 * API and provide the <code>TrialName</code>.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/TrialSummary">AWS
 * API Reference</a></p>
 */
class TrialSummary {
 public:
  AWS_SAGEMAKER_API TrialSummary() = default;
  AWS_SAGEMAKER_API TrialSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_SAGEMAKER_API TrialSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SAGEMAKER_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the trial.</p>
   */
  inline const Aws::String& GetTrialArn() const { return m_trialArn; }
  inline bool TrialArnHasBeenSet() const { return m_trialArnHasBeenSet; }
  template <typename TrialArnT = Aws::String>
  void SetTrialArn(TrialArnT&& value) {
    m_trialArnHasBeenSet = true;
    m_trialArn = std::forward<TrialArnT>(value);
  }
  template <typename TrialArnT = Aws::String>
  TrialSummary& WithTrialArn(TrialArnT&& value) {
    SetTrialArn(std::forward<TrialArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the trial.</p>
   */
  inline const Aws::String& GetTrialName() const { return m_trialName; }
  inline bool TrialNameHasBeenSet() const { return m_trialNameHasBeenSet; }
  template <typename TrialNameT = Aws::String>
  void SetTrialName(TrialNameT&& value) {
    m_trialNameHasBeenSet = true;
    m_trialName = std::forward<TrialNameT>(value);
  }
  template <typename TrialNameT = Aws::String>
  TrialSummary& WithTrialName(TrialNameT&& value) {
    SetTrialName(std::forward<TrialNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the trial as displayed. If <code>DisplayName</code> isn't
   * specified, <code>TrialName</code> is displayed.</p>
   */
  inline const Aws::String& GetDisplayName() const { return m_displayName; }
  inline bool DisplayNameHasBeenSet() const { return m_displayNameHasBeenSet; }
  template <typename DisplayNameT = Aws::String>
  void SetDisplayName(DisplayNameT&& value) {
    m_displayNameHasBeenSet = true;
    m_displayName = std::forward<DisplayNameT>(value);
  }
  template <typename DisplayNameT = Aws::String>
  TrialSummary& WithDisplayName(DisplayNameT&& value) {
    SetDisplayName(std::forward<DisplayNameT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const TrialSource& GetTrialSource() const { return m_trialSource; }
  inline bool TrialSourceHasBeenSet() const { return m_trialSourceHasBeenSet; }
  template <typename TrialSourceT = TrialSource>
  void SetTrialSource(TrialSourceT&& value) {
    m_trialSourceHasBeenSet = true;
    m_trialSource = std::forward<TrialSourceT>(value);
  }
  template <typename TrialSourceT = TrialSource>
  TrialSummary& WithTrialSource(TrialSourceT&& value) {
    SetTrialSource(std::forward<TrialSourceT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>When the trial was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationTime() const { return m_creationTime; }
  inline bool CreationTimeHasBeenSet() const { return m_creationTimeHasBeenSet; }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  void SetCreationTime(CreationTimeT&& value) {
    m_creationTimeHasBeenSet = true;
    m_creationTime = std::forward<CreationTimeT>(value);
  }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  TrialSummary& WithCreationTime(CreationTimeT&& value) {
    SetCreationTime(std::forward<CreationTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>When the trial was last modified.</p>
   */
  inline const Aws::Utils::DateTime& GetLastModifiedTime() const { return m_lastModifiedTime; }
  inline bool LastModifiedTimeHasBeenSet() const { return m_lastModifiedTimeHasBeenSet; }
  template <typename LastModifiedTimeT = Aws::Utils::DateTime>
  void SetLastModifiedTime(LastModifiedTimeT&& value) {
    m_lastModifiedTimeHasBeenSet = true;
    m_lastModifiedTime = std::forward<LastModifiedTimeT>(value);
  }
  template <typename LastModifiedTimeT = Aws::Utils::DateTime>
  TrialSummary& WithLastModifiedTime(LastModifiedTimeT&& value) {
    SetLastModifiedTime(std::forward<LastModifiedTimeT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_trialArn;

  Aws::String m_trialName;

  Aws::String m_displayName;

  TrialSource m_trialSource;

  Aws::Utils::DateTime m_creationTime{};

  Aws::Utils::DateTime m_lastModifiedTime{};
  bool m_trialArnHasBeenSet = false;
  bool m_trialNameHasBeenSet = false;
  bool m_displayNameHasBeenSet = false;
  bool m_trialSourceHasBeenSet = false;
  bool m_creationTimeHasBeenSet = false;
  bool m_lastModifiedTimeHasBeenSet = false;
};

}  // namespace Model
}  // namespace SageMaker
}  // namespace Aws
