define(["exports"],function(_exports){"use strict";Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0;_exports.default=function(options){var module,supportsWebAssembly=!1;try{!1!==options.supportsWebAssembly&&"object"==typeof WebAssembly&&"function"==typeof WebAssembly.instantiate&&(module=new WebAssembly.Module(Uint8Array.of(0,97,115,109,1,0,0,0)))instanceof WebAssembly.Module&&(supportsWebAssembly=new WebAssembly.Instance(module)instanceof WebAssembly.Instance)}catch(e){}console.log("WebAssembly support detected: "+(supportsWebAssembly?"yes":"no"));var self=this;function onTimeUpdate(){self.setCurrentTime(self.video.currentTime+self.timeOffset)}function onPlaying(){self.setIsPaused(!1,self.video.currentTime+self.timeOffset)}function onPause(){self.setIsPaused(!0,self.video.currentTime+self.timeOffset)}function onSeeking(){self._seeking=!0}function onSeeked(){self._seeking=!1;var currentTime=self.video.currentTime+self.timeOffset;self.setCurrentTime(currentTime)}function onRateChange(){self.setRate(self.video.playbackRate)}function onWaiting(){self.setIsPaused(!0,self.video.currentTime+self.timeOffset)}function onLoadedMetadata(e){e.target.removeEventListener(e.type,onLoadedMetadata,!1),self.resize()}function renderFrames(){var data=self.renderFramesData,beforeDrawTime=performance.now();self.ctx.clearRect(0,0,self.canvas.width,self.canvas.height);for(var blendTime,i=0;i<data.canvases.length;i++){var image=data.canvases[i],imageBuffer=(self.bufferCanvas.width=image.w,self.bufferCanvas.height=image.h,new Uint8ClampedArray(image.buffer));if(self.hasAlphaBug)for(var j=3;j<imageBuffer.length;j+=4)imageBuffer[j]=1<=imageBuffer[j]?imageBuffer[j]:1;var imageData=new ImageData(imageBuffer,image.w,image.h);self.bufferCanvasCtx.putImageData(imageData,0,0),self.ctx.drawImage(self.bufferCanvas,image.x,image.y)}self.debug&&(beforeDrawTime=Math.round(performance.now()-beforeDrawTime),void 0!==(blendTime=data.blendTime)?console.log("render: "+Math.round(data.spentTime-blendTime)+" ms, blend: "+Math.round(blendTime)+" ms, draw: "+beforeDrawTime+" ms; TOTAL="+Math.round(data.spentTime+beforeDrawTime)+" ms"):console.log(Math.round(data.spentTime)+" ms (+ "+beforeDrawTime+" ms draw)"),self.renderStart=performance.now())}function renderFastFrames(){var data=self.renderFramesData,beforeDrawTime=performance.now();self.ctx.clearRect(0,0,self.canvas.width,self.canvas.height);for(var i=0;i<data.bitmaps.length;i++){var image=data.bitmaps[i];self.ctx.drawImage(image.bitmap,image.x,image.y)}self.debug&&(beforeDrawTime=Math.round(performance.now()-beforeDrawTime),console.log(data.bitmaps.length+" bitmaps, libass: "+Math.round(data.libassTime)+"ms, decode: "+Math.round(data.decodeTime)+"ms, draw: "+beforeDrawTime+"ms"),self.renderStart=performance.now())}self.canvas=options.canvas,self.renderMode=options.renderMode||(options.lossyRender?"lossy":"wasm-blend"),self.libassMemoryLimit=options.libassMemoryLimit||0,self.libassGlyphLimit=options.libassGlyphLimit||0,self.targetFps=options.targetFps||24,self.prescaleFactor=options.prescaleFactor||1,self.prescaleHeightLimit=options.prescaleHeightLimit||1080,self.maxRenderHeight=options.maxRenderHeight||0,self.dropAllAnimations=options.dropAllAnimations||!1,self.isOurCanvas=!1,self.video=options.video,self.canvasParent=null,self.fonts=options.fonts||[],self.availableFonts=options.availableFonts||[],self.fallbackFont=options.fallbackFont||"default.woff2",self.lazyFileLoading=options.lazyFileLoading||!1,self.onReadyEvent=options.onReady,self.workerUrl=supportsWebAssembly?options.workerUrl||"subtitles-octopus-worker.js":options.legacyWorkerUrl||"subtitles-octopus-worker-legacy.js",self.subUrl=options.subUrl,self.subContent=options.subContent||null,self.onErrorEvent=options.onError,self.debug=options.debug||!1,self.lastRenderTime=0,self.pixelRatio=window.devicePixelRatio||1,self.timeOffset=options.timeOffset||0,self.hasAlphaBug=!1,self.detectAlphaBug=!1!==options.detectAlphaBug,function(){if("function"==typeof ImageData.prototype.constructor)try{return new window.ImageData(new Uint8ClampedArray([0,0,0,0]),1,1)}catch(e){console.log("detected that ImageData is not constructable despite browser saying so")}var ctx=document.createElement("canvas").getContext("2d");window.ImageData=function(){var data,i=0,width=(arguments[0]instanceof Uint8ClampedArray&&(data=arguments[i++]),arguments[i++]),width=ctx.createImageData(width,arguments[i]);return data&&width.data.set(data),width}}(),self.workerError=function(error){if(console.error("Worker error: ",error),self.onErrorEvent&&self.onErrorEvent(error),!self.debug)throw self.dispose(),new Error("Worker error: "+error)},self.init=function(){window.Worker?(self.worker||(self.worker=new Worker(self.workerUrl),self.worker.addEventListener("message",self.onWorkerMessage),self.worker.addEventListener("error",self.workerError)),self.workerActive=!1,self.createCanvas(),self.setVideo(options.video),self.setSubUrl(options.subUrl),self.worker.postMessage({target:"worker-init",width:self.canvas.width,height:self.canvas.height,URL:document.URL,currentScript:self.workerUrl,preMain:!0,renderMode:self.renderMode,subUrl:self.subUrl,subContent:self.subContent,fonts:self.fonts,availableFonts:self.availableFonts,fallbackFont:self.fallbackFont,lazyFileLoading:self.lazyFileLoading,debug:self.debug,targetFps:self.targetFps,libassMemoryLimit:self.libassMemoryLimit,libassGlyphLimit:self.libassGlyphLimit,dropAllAnimations:self.dropAllAnimations})):self.workerError("worker not supported")},self.createCanvas=function(){if(self.canvas?self.canvasParent=self.canvas.parentNode:self.video?(self.isOurCanvas=!0,self.canvas=document.createElement("canvas"),self.canvas.className="libassjs-canvas",self.canvas.style.display="none",self.canvasParent=document.createElement("div"),self.canvasParent.className="libassjs-canvas-parent",self.canvasParent.appendChild(self.canvas),self.video.nextSibling?self.video.parentNode.insertBefore(self.canvasParent,self.video.nextSibling):self.video.parentNode.appendChild(self.canvasParent)):self.canvas||self.workerError("Don't know where to render: you should give video or canvas in options."),self.ctx=self.canvas.getContext("2d"),self.bufferCanvas=document.createElement("canvas"),self.bufferCanvasCtx=self.bufferCanvas.getContext("2d"),self.detectAlphaBug){var savedHasAlphaBug=function(){try{return localStorage.getItem("canvas_hasalphabug")}catch(err){console.log("error reading from storage")}return null}();if("true"===savedHasAlphaBug)self.hasAlphaBug=!0;else if("false"===savedHasAlphaBug)self.hasAlphaBug=!1;else{self.bufferCanvas.width=1,self.bufferCanvas.height=1;var savedHasAlphaBug=new Uint8ClampedArray([0,255,0,0]),savedHasAlphaBug=new ImageData(savedHasAlphaBug,1,1),prePut=(self.bufferCanvasCtx.clearRect(0,0,1,1),self.ctx.clearRect(0,0,1,1),self.ctx.getImageData(0,0,1,1).data),savedHasAlphaBug=(self.bufferCanvasCtx.putImageData(savedHasAlphaBug,0,0),self.ctx.drawImage(self.bufferCanvas,0,0),self.ctx.getImageData(0,0,1,1).data),prePut=(self.hasAlphaBug=prePut[1]!==savedHasAlphaBug[1],self.hasAlphaBug&&console.log("Detected a browser having issue with transparent pixels, applying workaround"),self.hasAlphaBug);try{localStorage.setItem("canvas_hasalphabug",prePut)}catch(err){console.log("error saving to local storage")}}}},self.onTimeUpdate=function(currentTime){self._seeking||self.setCurrentTime(currentTime+self.timeOffset)},self.setVideo=function(video){self.video=video,self.video&&(self.video.addEventListener("playing",onPlaying,!1),self.video.addEventListener("pause",onPause,!1),self.video.addEventListener("seeking",onSeeking,!1),self.video.addEventListener("seeked",onSeeked,!1),self.video.addEventListener("ratechange",onRateChange,!1),self.video.addEventListener("waiting",onWaiting,!1),0<self.video.videoWidth?self.resize():self.video.addEventListener("loadedmetadata",onLoadedMetadata,!1))},self.getVideoPosition=function(){var videoRatio=self.video.videoWidth/self.video.videoHeight,width=self.video.offsetWidth,height=self.video.offsetHeight,realWidth=width,realHeight=height,videoRatio=(videoRatio<width/height?realWidth=Math.floor(height*videoRatio):realHeight=Math.floor(width/videoRatio),(width-realWidth)/2);return{width:realWidth,height:realHeight,x:videoRatio,y:(height-realHeight)/2}},self.setSubUrl=function(subUrl){self.subUrl=subUrl},self.renderFrameData=null,self.workerActive=!1,self.frameId=0,self.onWorkerMessage=function(event){self.workerActive||(self.workerActive=!0,self.onReadyEvent&&self.onReadyEvent());var data=event.data;switch(data.target){case"stdout":console.log(data.content);break;case"console-log":console.log.apply(console,JSON.parse(data.content));break;case"console-debug":console.debug.apply(console,JSON.parse(data.content));break;case"console-info":console.info.apply(console,JSON.parse(data.content));break;case"console-warn":console.warn.apply(console,JSON.parse(data.content));break;case"console-error":console.error.apply(console,JSON.parse(data.content));break;case"stderr":console.error(data.content);break;case"window":window[data.method]();break;case"canvas":switch(data.op){case"getContext":self.ctx=self.canvas.getContext(data.type,data.attributes);break;case"resize":self.resize(data.width,data.height);break;case"renderCanvas":self.lastRenderTime<data.time&&(self.lastRenderTime=data.time,self.renderFramesData=data,window.requestAnimationFrame(renderFrames));break;case"renderFastCanvas":self.lastRenderTime<data.time&&(self.lastRenderTime=data.time,self.renderFramesData=data,window.requestAnimationFrame(renderFastFrames));break;case"setObjectProperty":self.canvas[data.object][data.property]=data.value;break;default:throw"eh?"}break;case"tick":self.frameId=data.id,self.worker.postMessage({target:"tock",id:self.frameId});break;case"custom":if(!self.onCustomMessage)throw"Custom message received but client onCustomMessage not implemented.";self.onCustomMessage(event);break;case"setimmediate":self.worker.postMessage({target:"setimmediate"});break;case"get-events":case"get-styles":case"ready":break;default:throw"what? "+data.target}},self.resize=function(width,height,top,left){var newSize,videoSize=null;top=top||0,left=left||0,width&&height||!self.video||(width=(newSize=function(width,height){var sgn,newH,scalefactor=self.prescaleFactor<=0?1:self.prescaleFactor;return height=height<=0||width<=0?width=0:((sgn=scalefactor<1?-1:1)*(newH=height)*scalefactor<=sgn*self.prescaleHeightLimit?newH*=scalefactor:sgn*newH<sgn*self.prescaleHeightLimit&&(newH=self.prescaleHeightLimit),width*=(newH=0<self.maxRenderHeight&&newH>self.maxRenderHeight?self.maxRenderHeight:newH)/height,newH),{width:width,height:height}}((videoSize=self.getVideoPosition()).width*self.pixelRatio,videoSize.height*self.pixelRatio)).width,height=newSize.height,newSize=self.canvasParent.getBoundingClientRect().top-self.video.getBoundingClientRect().top,top=videoSize.y-newSize,left=videoSize.x),width&&height?self.canvas.width===width&&self.canvas.height===height&&self.canvas.style.top===top&&self.canvas.style.left===left||(self.canvas.width=width,self.canvas.height=height,null!=videoSize&&(self.canvasParent.style.position="relative",self.canvas.style.display="block",self.canvas.style.position="absolute",self.canvas.style.width=videoSize.width+"px",self.canvas.style.height=videoSize.height+"px",videoSize.height&&(self.canvas.style.aspectRatio=videoSize.width/videoSize.height),self.canvas.style.top=top+"px",self.canvas.style.left=left+"px",self.canvas.style.pointerEvents="none"),self.worker.postMessage({target:"canvas",width:self.canvas.width,height:self.canvas.height})):self.video||console.error("width or height is 0. You should specify width & height for resize.")},self.resizeWithTimeout=function(){self.resize(),setTimeout(self.resize,100)},self.runBenchmark=function(){self.worker.postMessage({target:"runBenchmark"})},self.customMessage=function(data,options){self.worker.postMessage({target:"custom",userData:data,preMain:(options=options||{}).preMain})},self.setCurrentTime=function(currentTime){self.worker.postMessage({target:"video",currentTime:currentTime})},self.setTrackByUrl=function(url){self.worker.postMessage({target:"set-track-by-url",url:url})},self.setTrack=function(content){self.worker.postMessage({target:"set-track",content:content})},self.freeTrack=function(content){self.worker.postMessage({target:"free-track"})},self.render=self.setCurrentTime,self.setIsPaused=function(isPaused,currentTime){self.worker.postMessage({target:"video",isPaused:isPaused,currentTime:currentTime})},self.setRate=function(rate){self.worker.postMessage({target:"video",rate:rate})},self.dispose=function(){self.worker.postMessage({target:"destroy"}),self.worker.terminate(),self.worker.removeEventListener("message",self.onWorkerMessage),self.worker.removeEventListener("error",self.workerError),self.workerActive=!1,self.worker=null,self.video&&(self.video.removeEventListener("timeupdate",onTimeUpdate,!1),self.video.removeEventListener("playing",onPlaying,!1),self.video.removeEventListener("pause",onPause,!1),self.video.removeEventListener("seeking",onSeeking,!1),self.video.removeEventListener("seeked",onSeeked,!1),self.video.removeEventListener("ratechange",onRateChange,!1),self.video.removeEventListener("waiting",onWaiting,!1),self.video.removeEventListener("loadedmetadata",onLoadedMetadata,!1),document.removeEventListener("fullscreenchange",self.resizeWithTimeout,!1),document.removeEventListener("mozfullscreenchange",self.resizeWithTimeout,!1),document.removeEventListener("webkitfullscreenchange",self.resizeWithTimeout,!1),document.removeEventListener("msfullscreenchange",self.resizeWithTimeout,!1),window.removeEventListener("resize",self.resizeWithTimeout,!1),self.canvasParent.remove(),self.video=null),self.ro&&(self.ro.disconnect(),self.ro=null),self.onCustomMessage=null,self.onErrorEvent=null,self.onReadyEvent=null},self.fetchFromWorker=function(workerOptions,onSuccess,onError){try{var target=workerOptions.target,timeout=setTimeout(function(){reject(Error("Error: Timeout while try to fetch "+target))},5e3),resolve=function(event){event.data.target===target&&(onSuccess(event.data),self.worker.removeEventListener("message",resolve),self.worker.removeEventListener("error",reject),clearTimeout(timeout))},reject=function(event){onError(event),self.worker.removeEventListener("message",resolve),self.worker.removeEventListener("error",reject),clearTimeout(timeout)};self.worker.addEventListener("message",resolve),self.worker.addEventListener("error",reject),self.worker.postMessage(workerOptions)}catch(error){onError(error)}},self.createEvent=function(event){self.worker.postMessage({target:"create-event",event:event})},self.getEvents=function(onSuccess,onError){self.fetchFromWorker({target:"get-events"},function(data){onSuccess(data.events)},onError)},self.setEvent=function(event,index){self.worker.postMessage({target:"set-event",event:event,index:index})},self.removeEvent=function(index){self.worker.postMessage({target:"remove-event",index:index})},self.createStyle=function(style){self.worker.postMessage({target:"create-style",style:style})},self.getStyles=function(onSuccess,onError){self.fetchFromWorker({target:"get-styles"},function(data){onSuccess(data.styles)},onError)},self.setStyle=function(style,index){self.worker.postMessage({target:"set-style",style:style,index:index})},self.removeStyle=function(index){self.worker.postMessage({target:"remove-style",index:index})},self.init()}});