/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.entities;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import org.keycloak.common.util.Time;
import org.keycloak.models.OrganizationInvitationModel;

@Entity
@Table(name="ORG_INVITATION")
@NamedQueries(value={@NamedQuery(name="getByOrganization", query="SELECT i FROM OrganizationInvitationEntity i WHERE i.organizationId = :orgId ORDER BY i.createdAt DESC")})
public class OrganizationInvitationEntity
implements OrganizationInvitationModel {
    @Id
    @Column(name="ID", length=36)
    private String id;
    @Column(name="ORGANIZATION_ID", length=255, nullable=false)
    private String organizationId;
    @Column(name="EMAIL", nullable=false)
    private String email;
    @Column(name="FIRST_NAME")
    private String firstName;
    @Column(name="LAST_NAME")
    private String lastName;
    @Column(name="CREATED_AT", nullable=false)
    private int createdAt;
    @Column(name="EXPIRES_AT")
    private int expiresAt;
    @Column(name="INVITE_LINK", length=2048)
    private String inviteLink;

    public OrganizationInvitationEntity() {
    }

    public OrganizationInvitationEntity(String id, String organizationId, String email, String firstName, String lastName) {
        this.id = id;
        this.organizationId = organizationId;
        this.email = email;
        this.firstName = firstName;
        this.lastName = lastName;
        this.createdAt = Time.currentTime();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public int getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(int createdAt) {
        this.createdAt = createdAt;
    }

    public int getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(int expiresAt) {
        this.expiresAt = expiresAt;
    }

    public String getInviteLink() {
        return this.inviteLink;
    }

    public void setInviteLink(String inviteLink) {
        this.inviteLink = inviteLink;
    }

    public OrganizationInvitationModel.InvitationStatus getStatus() {
        return this.isExpired() ? OrganizationInvitationModel.InvitationStatus.EXPIRED : OrganizationInvitationModel.InvitationStatus.PENDING;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrganizationInvitationEntity that = (OrganizationInvitationEntity)o;
        return this.id != null ? this.id.equals(that.id) : that.id == null;
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }
}

