/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.recovery;

import java.io.IOException;
import java.util.function.Consumer;
import org.apache.lucene.index.IndexCommit;
import org.opensearch.action.StepListener;
import org.opensearch.common.CheckedConsumer;
import org.opensearch.common.SetOnce;
import org.opensearch.common.concurrent.GatedCloseable;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.engine.RecoveryEngineException;
import org.opensearch.index.seqno.RetentionLease;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.RunUnderPrimaryPermit;
import org.opensearch.indices.recovery.RecoveryResponse;
import org.opensearch.indices.recovery.RecoverySourceHandler;
import org.opensearch.indices.recovery.RecoveryTargetHandler;
import org.opensearch.indices.recovery.StartRecoveryRequest;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.Transports;

public class RemoteStorePeerRecoverySourceHandler
extends RecoverySourceHandler {
    public RemoteStorePeerRecoverySourceHandler(IndexShard shard, RecoveryTargetHandler recoveryTarget, ThreadPool threadPool, StartRecoveryRequest request, int fileChunkSizeInBytes, int maxConcurrentFileChunks, int maxConcurrentOperations) {
        super(shard, recoveryTarget, threadPool, request, fileChunkSizeInBytes, maxConcurrentFileChunks, maxConcurrentOperations);
    }

    @Override
    protected void innerRecoveryToTarget(ActionListener<RecoveryResponse> listener, Consumer<Exception> onFailure) throws IOException {
        GatedCloseable<IndexCommit> wrappedSafeCommit;
        SetOnce retentionLeaseRef = new SetOnce();
        this.waitForAssignmentPropagate((SetOnce<RetentionLease>)retentionLeaseRef);
        StepListener<RecoverySourceHandler.SendFileResult> sendFileStep = new StepListener<RecoverySourceHandler.SendFileResult>();
        StepListener<TimeValue> prepareEngineStep = new StepListener<TimeValue>();
        StepListener<RecoverySourceHandler.SendSnapshotResult> sendSnapshotStep = new StepListener<RecoverySourceHandler.SendSnapshotResult>();
        try {
            wrappedSafeCommit = this.acquireSafeCommit(this.shard);
            this.resources.add(wrappedSafeCommit);
        }
        catch (Exception e) {
            throw new RecoveryEngineException(this.shard.shardId(), 1, "snapshot failed", e);
        }
        long startingSeqNo = Long.parseLong((String)wrappedSafeCommit.get().getUserData().get("local_checkpoint")) + 1L;
        this.logger.trace("performing file-based recovery followed by history replay starting at [{}]", (Object)startingSeqNo);
        try {
            Releasable releaseStore = this.acquireStore(this.shard.store());
            this.resources.add(releaseStore);
            this.onSendFileStepComplete(sendFileStep, wrappedSafeCommit, releaseStore);
            assert (Transports.assertNotTransportThread(String.valueOf(this) + "[phase1]"));
            this.phase1(wrappedSafeCommit.get(), startingSeqNo, () -> 0, (ActionListener<RecoverySourceHandler.SendFileResult>)sendFileStep, true);
        }
        catch (Exception e) {
            throw new RecoveryEngineException(this.shard.shardId(), 1, "sendFileStep failed", e);
        }
        assert (startingSeqNo >= 0L) : "startingSeqNo must be non negative. got: " + startingSeqNo;
        sendFileStep.whenComplete((CheckedConsumer<RecoverySourceHandler.SendFileResult, Exception>)((CheckedConsumer)r -> {
            this.logger.debug("sendFileStep completed");
            assert (Transports.assertNotTransportThread(String.valueOf(this) + "[prepareTargetForTranslog]"));
            this.prepareTargetForTranslog(0, (ActionListener<TimeValue>)prepareEngineStep);
        }), onFailure);
        prepareEngineStep.whenComplete(prepareEngineTime -> {
            this.logger.debug("prepareEngineStep completed");
            assert (Transports.assertNotTransportThread(String.valueOf(this) + "[phase2]"));
            RunUnderPrimaryPermit.run(() -> this.shard.initiateTracking(this.request.targetAllocationId()), this.shardId + " initiating tracking of " + this.request.targetAllocationId(), this.shard, this.cancellableThreads, this.logger);
            long endingSeqNo = this.shard.seqNoStats().getMaxSeqNo();
            sendSnapshotStep.onResponse(new RecoverySourceHandler.SendSnapshotResult(endingSeqNo, 0, TimeValue.ZERO));
        }, onFailure);
        this.finalizeStepAndCompleteFuture(startingSeqNo, sendSnapshotStep, sendFileStep, prepareEngineStep, onFailure);
    }
}

