/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.component.split.response;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.response.ResponseHeaderStringHttpPanelViewModel;
import org.zaproxy.zap.extension.httppanel.view.text.HttpPanelTextArea;
import org.zaproxy.zap.extension.httppanel.view.text.HttpPanelTextView;
import org.zaproxy.zap.extension.httppanel.view.util.HttpTextViewUtils;
import org.zaproxy.zap.extension.search.SearchMatch;

public class HttpResponseHeaderPanelTextView
extends HttpPanelTextView {
    public HttpResponseHeaderPanelTextView(ResponseHeaderStringHttpPanelViewModel model) {
        super(model);
    }

    @Override
    protected HttpPanelTextArea createHttpPanelTextArea() {
        return new HttpResponseHeaderPanelTextArea();
    }

    private static class HttpResponseHeaderPanelTextArea
    extends HttpPanelTextArea {
        private static final long serialVersionUID = -787753390999658000L;

        private HttpResponseHeaderPanelTextArea() {
        }

        @Override
        public void search(Pattern p, List<SearchMatch> matches) {
            Matcher m = p.matcher(this.getText());
            while (m.find()) {
                int[] position = HttpTextViewUtils.getViewToHeaderPosition(this, m.start(), m.end());
                if (position.length == 0) {
                    return;
                }
                matches.add(new SearchMatch(SearchMatch.Location.RESPONSE_HEAD, position[0], position[1]));
            }
        }

        @Override
        public void highlight(SearchMatch sm) {
            if (!SearchMatch.Location.RESPONSE_HEAD.equals((Object)sm.getLocation())) {
                return;
            }
            int[] pos = HttpTextViewUtils.getHeaderToViewPosition(this, sm.getMessage().getResponseHeader().toString(), sm.getStart(), sm.getEnd());
            if (pos.length == 0) {
                return;
            }
            this.highlight(pos[0], pos[1]);
        }
    }
}

