#
# Creating functions from encryption_udf
#

INSTALL COMPONENT 'file://component_encryption_udf';

if (!$use_openssl_binary)
{
    --echo ** [DH][$key_length] generating parameters
    eval SET @dh_params = create_dh_parameters($key_length);
}
if ($use_openssl_binary)
{
  --let $parameters_file_path = $MYSQLTEST_VARDIR/tmp/parameters.pem
  --echo ** [DH][$key_length] generating parameters with openssl binary
  --exec $OPENSSL_EXECUTABLE dhparam -out $parameters_file_path $key_length
  --replace_result $parameters_file_path <PARAMETERS_FILE_PATH>
  eval SET @dh_params = TRIM(TRAILING '\n' FROM LOAD_FILE('$parameters_file_path'));
}

if (!$use_openssl_binary)
{
  --echo ** [DH][$key_length] generating private/public keys from parameters
  SET @dh_priv1 = create_asymmetric_priv_key('DH', @dh_params);
  SET @dh_pub1 =  create_asymmetric_pub_key('DH', @dh_priv1);
}
if ($use_openssl_binary)
{
  --let $private_key1_file_path = $MYSQLTEST_VARDIR/tmp/private_key1.pem
  --echo ** [DH][$key_length] generating private/public keys from parameters with openssl binary
  --exec $OPENSSL_EXECUTABLE genpkey -paramfile $parameters_file_path -out $private_key1_file_path
  --replace_result $private_key1_file_path <PRIVATE_KEY1_FILE_PATH>
  eval SET @dh_priv1 = TRIM(TRAILING '\n' FROM LOAD_FILE('$private_key1_file_path'));

  --let $public_key1_file_path = $MYSQLTEST_VARDIR/tmp/public_key1.pem
  --exec $OPENSSL_EXECUTABLE pkey -in $private_key1_file_path -pubout -out $public_key1_file_path
  --replace_result $public_key1_file_path <PUBLIC_KEY1_FILE_PATH>
  eval SET @dh_pub1 = TRIM(TRAILING '\n' FROM LOAD_FILE('$public_key1_file_path'));

  --let $assert_text = [DH][$key_length] public key 1 created with create_asymmetric_pub_key must be identical to the one created with openssl pkey
  --let $assert_cond = @dh_pub1 = create_asymmetric_pub_key("DH", @dh_priv1)
  --let $include_silent = 1
  --source include/assert.inc
  --let $include_silent =
}

if (!$use_openssl_binary)
{
  SET @dh_priv2 = create_asymmetric_priv_key('DH', @dh_params);
  SET @dh_pub2 =  create_asymmetric_pub_key('DH', @dh_priv2);
}
if ($use_openssl_binary)
{
  --let $private_key2_file_path = $MYSQLTEST_VARDIR/tmp/private_key2.pem
  --exec $OPENSSL_EXECUTABLE genpkey -paramfile $parameters_file_path -out $private_key2_file_path
  --replace_result $private_key2_file_path <PRIVATE_KEY2_FILE_PATH>
  eval SET @dh_priv2 = TRIM(TRAILING '\n' FROM LOAD_FILE('$private_key2_file_path'));

  --let $public_key2_file_path = $MYSQLTEST_VARDIR/tmp/public_key2.pem
  --exec $OPENSSL_EXECUTABLE pkey -in $private_key2_file_path -pubout -out $public_key2_file_path
  --replace_result $public_key2_file_path <PUBLIC_KEY2_FILE_PATH>
  eval SET @dh_pub2 = TRIM(TRAILING '\n' FROM LOAD_FILE('$public_key2_file_path'));

  --let $assert_text = [DH][$key_length] public key 2 created with create_asymmetric_pub_key must be identical to the one created with openssl pkey
  --let $assert_cond = @dh_pub2 = create_asymmetric_pub_key("DH", @dh_priv2)
  --let $include_silent = 1
  --source include/assert.inc
  --let $include_silent =

  --remove_file $public_key2_file_path
  --remove_file $private_key2_file_path
  --remove_file $public_key1_file_path
  --remove_file $private_key1_file_path
  --remove_file $parameters_file_path
}

--echo ** [DH][$key_length] verifying shared key generation
SET @shared1 = asymmetric_derive(@dh_pub1, @dh_priv2);
SET @shared2 = asymmetric_derive(@dh_pub2, @dh_priv1);

--let $assert_text = [DH][$key_length] shared keys generated by different parties must match
--let $assert_cond = @shared1 = @shared2
--let $include_silent = 1
--source include/assert.inc
--let $include_silent =

#
# Dropping functions from encryption_udf
#
UNINSTALL COMPONENT 'file://component_encryption_udf';
