# Contributing to uwufetch

## Code

To contribute to this project, you should follow some rules to keep the code consistent:

-   Please try to be consistent in code formatting. Would be nice if you used `clang-format`.
-   Function and variable names should be written in snake_case and abbreviated if too long.
-   Use shell instead of a `C` implementation only if necessary, just to increment `uwufetch` performance.

---

## Pull requests

Before sending a pull request be sure that no one is already working on the same thing and to follow this guide-lines.
Please add any external dependances in the [README.md](https://github.com/TheDarkBug/uwufetch#requisites).

With pull requests you can `[FIX]` a bug (reported or not), add `[OS-SUPPORT]`, add a `[NEW-FEATURE]` requested in an [issue](https://github.com/TheDarkBug/uwufetch/blob/main/CONTRIBUTING.md#issues) (or not), fix a `[TYPO]` or `[OPTIMIZE]` the code.

---

## Issues

Issue templates should be enough to guide you to write a good issue.

---

## Conclusions

I'll take some space to thank all the [contributors](https://github.com/TheDarkBug/uwufetch/graphs/contributors) that make this project better every day.
