/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ES6Iterator;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeGenerator;
import org.mozilla.javascript.NativeIterator;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.Undefined;

public final class ES6Generator
extends IdScriptableObject {
    private static final long serialVersionUID = 1645892441041347273L;
    private static final Object GENERATOR_TAG = "Generator";
    private static final int Id_next = 1;
    private static final int Id_return = 2;
    private static final int Id_throw = 3;
    private static final int SymbolId_iterator = 4;
    private static final int MAX_PROTOTYPE_ID = 4;
    private NativeFunction function;
    private Object savedState;
    private String lineSource;
    private int lineNumber;
    private State state = State.SUSPENDED_START;
    private Object delegee;

    static ES6Generator init(ScriptableObject scriptableObject, boolean bl) {
        ES6Generator eS6Generator = new ES6Generator();
        if (scriptableObject != null) {
            eS6Generator.setParentScope(scriptableObject);
            eS6Generator.setPrototype(ES6Generator.getObjectPrototype(scriptableObject));
        }
        eS6Generator.activatePrototypeMap(4);
        if (bl) {
            eS6Generator.sealObject();
        }
        if (scriptableObject != null) {
            scriptableObject.associateValue(GENERATOR_TAG, eS6Generator);
        }
        return eS6Generator;
    }

    private ES6Generator() {
    }

    public ES6Generator(Scriptable scriptable, NativeFunction nativeFunction, Object object) {
        this.function = nativeFunction;
        this.savedState = object;
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(scriptable);
        this.setParentScope(scriptable2);
        ES6Generator eS6Generator = (ES6Generator)ScriptableObject.getTopScopeValue(scriptable2, GENERATOR_TAG);
        this.setPrototype(eS6Generator);
    }

    @Override
    public String getClassName() {
        return "Generator";
    }

    @Override
    protected void initPrototypeId(int n) {
        String string;
        int n2;
        if (n == 4) {
            this.initPrototypeMethod(GENERATOR_TAG, n, SymbolKey.ITERATOR, "[Symbol.iterator]", 0);
            return;
        }
        switch (n) {
            case 1: {
                n2 = 1;
                string = "next";
                break;
            }
            case 2: {
                n2 = 1;
                string = "return";
                break;
            }
            case 3: {
                n2 = 1;
                string = "throw";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(GENERATOR_TAG, n, string, n2);
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(GENERATOR_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        ES6Generator eS6Generator = ES6Generator.ensureType(scriptable2, ES6Generator.class, idFunctionObject);
        Object object = objectArray.length >= 1 ? objectArray[0] : Undefined.instance;
        switch (n) {
            case 2: {
                if (eS6Generator.delegee == null) {
                    return eS6Generator.resumeAbruptLocal(context, scriptable, 2, object);
                }
                return eS6Generator.resumeDelegeeReturn(context, scriptable, object);
            }
            case 1: {
                if (eS6Generator.delegee == null) {
                    return eS6Generator.resumeLocal(context, scriptable, object);
                }
                return eS6Generator.resumeDelegee(context, scriptable, object);
            }
            case 3: {
                if (eS6Generator.delegee == null) {
                    return eS6Generator.resumeAbruptLocal(context, scriptable, 1, object);
                }
                return eS6Generator.resumeDelegeeThrow(context, scriptable, object);
            }
            case 4: {
                return scriptable2;
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    private Scriptable resumeDelegee(Context context, Scriptable scriptable, Object object) {
        try {
            Object[] objectArray;
            if (Undefined.instance.equals(object)) {
                objectArray = ScriptRuntime.emptyArgs;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = object;
            }
            Object[] objectArray3 = objectArray;
            Callable callable = ScriptRuntime.getPropFunctionAndThis(this.delegee, "next", context, scriptable);
            Scriptable scriptable2 = ScriptRuntime.lastStoredScriptable(context);
            Object object2 = callable.call(context, scriptable, scriptable2, objectArray3);
            Scriptable scriptable3 = ScriptableObject.ensureScriptable(object2);
            if (ScriptRuntime.isIteratorDone(context, scriptable3)) {
                this.delegee = null;
                return this.resumeLocal(context, scriptable, ScriptableObject.getProperty(scriptable3, "value"));
            }
            return scriptable3;
        }
        catch (RhinoException rhinoException) {
            this.delegee = null;
            return this.resumeAbruptLocal(context, scriptable, 1, rhinoException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Scriptable resumeDelegeeThrow(Context context, Scriptable scriptable, Object object) {
        boolean bl = false;
        try {
            Callable callable = ScriptRuntime.getPropFunctionAndThis(this.delegee, "throw", context, scriptable);
            Scriptable scriptable2 = ScriptRuntime.lastStoredScriptable(context);
            Object object2 = callable.call(context, scriptable, scriptable2, new Object[]{object});
            if (ScriptRuntime.isIteratorDone(context, object2)) {
                try {
                    bl = true;
                    this.callReturnOptionally(context, scriptable, Undefined.instance);
                }
                finally {
                    this.delegee = null;
                }
                return this.resumeLocal(context, scriptable, ScriptRuntime.getObjectProp(object2, "value", context, scriptable));
            }
            return ES6Generator.ensureScriptable(object2);
        }
        catch (RhinoException rhinoException) {
            block12: {
                try {
                    if (bl) break block12;
                    try {
                        this.callReturnOptionally(context, scriptable, Undefined.instance);
                    }
                    catch (RhinoException rhinoException2) {
                        Scriptable scriptable3 = this.resumeAbruptLocal(context, scriptable, 1, rhinoException2);
                        this.delegee = null;
                        return scriptable3;
                    }
                }
                finally {
                    this.delegee = null;
                }
            }
            return this.resumeAbruptLocal(context, scriptable, 1, rhinoException);
        }
    }

    private Scriptable resumeDelegeeReturn(Context context, Scriptable scriptable, Object object) {
        try {
            Object object2 = this.callReturnOptionally(context, scriptable, object);
            if (object2 != null) {
                if (ScriptRuntime.isIteratorDone(context, object2)) {
                    this.delegee = null;
                    return this.resumeAbruptLocal(context, scriptable, 2, ScriptRuntime.getObjectPropNoWarn(object2, "value", context, scriptable));
                }
                return ES6Generator.ensureScriptable(object2);
            }
            this.delegee = null;
            return this.resumeAbruptLocal(context, scriptable, 2, object);
        }
        catch (RhinoException rhinoException) {
            this.delegee = null;
            return this.resumeAbruptLocal(context, scriptable, 1, rhinoException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Scriptable resumeLocal(Context context, Scriptable scriptable, Object object) {
        Scriptable scriptable2;
        block27: {
            if (this.state == State.COMPLETED) {
                return ES6Iterator.makeIteratorResult(context, scriptable, Boolean.TRUE);
            }
            if (this.state == State.EXECUTING) {
                throw ScriptRuntime.typeErrorById("msg.generator.executing", new Object[0]);
            }
            scriptable2 = ES6Iterator.makeIteratorResult(context, scriptable, Boolean.FALSE);
            this.state = State.EXECUTING;
            try {
                Object object2 = this.function.resumeGenerator(context, scriptable, 0, this.savedState, object);
                if (object2 instanceof YieldStarResult) {
                    Scriptable scriptable3;
                    this.state = State.SUSPENDED_YIELD;
                    YieldStarResult yieldStarResult = (YieldStarResult)object2;
                    try {
                        this.delegee = ScriptRuntime.callIterator(yieldStarResult.getResult(), context, scriptable);
                    }
                    catch (RhinoException rhinoException) {
                        Scriptable scriptable4 = this.resumeAbruptLocal(context, scriptable, 1, rhinoException);
                        if (this.state == State.COMPLETED) {
                            ScriptableObject.putProperty(scriptable2, "done", (Object)Boolean.TRUE);
                        } else {
                            this.state = State.SUSPENDED_YIELD;
                        }
                        return scriptable4;
                    }
                    try {
                        scriptable3 = this.resumeDelegee(context, scriptable, Undefined.instance);
                    }
                    finally {
                        this.state = State.EXECUTING;
                    }
                    if (ScriptRuntime.isIteratorDone(context, scriptable3)) {
                        this.state = State.COMPLETED;
                    }
                    Scriptable scriptable5 = scriptable3;
                    return scriptable5;
                }
                ScriptableObject.putProperty(scriptable2, "value", object2);
            }
            catch (NativeGenerator.GeneratorClosedException generatorClosedException) {
                this.state = State.COMPLETED;
            }
            catch (JavaScriptException javaScriptException) {
                this.state = State.COMPLETED;
                if (javaScriptException.getValue() instanceof NativeIterator.StopIteration) {
                    ScriptableObject.putProperty(scriptable2, "value", ((NativeIterator.StopIteration)javaScriptException.getValue()).getValue());
                    break block27;
                }
                this.lineNumber = javaScriptException.lineNumber();
                this.lineSource = javaScriptException.lineSource();
                if (javaScriptException.getValue() instanceof RhinoException) {
                    throw (RhinoException)javaScriptException.getValue();
                }
                throw javaScriptException;
            }
            catch (RhinoException rhinoException) {
                this.lineNumber = rhinoException.lineNumber();
                this.lineSource = rhinoException.lineSource();
                throw rhinoException;
            }
            finally {
                if (this.state == State.COMPLETED) {
                    ScriptableObject.putProperty(scriptable2, "done", (Object)Boolean.TRUE);
                } else {
                    this.state = State.SUSPENDED_YIELD;
                }
            }
        }
        return scriptable2;
    }

    private Scriptable resumeAbruptLocal(Context context, Scriptable scriptable, int n, Object object) {
        Scriptable scriptable2;
        block22: {
            if (this.state == State.EXECUTING) {
                throw ScriptRuntime.typeErrorById("msg.generator.executing", new Object[0]);
            }
            if (this.state == State.SUSPENDED_START) {
                this.state = State.COMPLETED;
            }
            scriptable2 = ES6Iterator.makeIteratorResult(context, scriptable, Boolean.FALSE);
            if (this.state == State.COMPLETED) {
                if (n == 1) {
                    throw new JavaScriptException(object, this.lineSource, this.lineNumber);
                }
                ScriptableObject.putProperty(scriptable2, "done", (Object)Boolean.TRUE);
                return scriptable2;
            }
            this.state = State.EXECUTING;
            Object object2 = object;
            if (n == 2) {
                if (!(object instanceof NativeGenerator.GeneratorClosedException)) {
                    object2 = new NativeGenerator.GeneratorClosedException();
                }
            } else if (object instanceof JavaScriptException) {
                object2 = ((JavaScriptException)object).getValue();
            } else if (object instanceof RhinoException) {
                object2 = ScriptRuntime.wrapException((Throwable)object, scriptable, context);
            }
            try {
                Object object3 = this.function.resumeGenerator(context, scriptable, n, this.savedState, object2);
                ScriptableObject.putProperty(scriptable2, "value", object3);
                this.state = State.SUSPENDED_YIELD;
            }
            catch (NativeGenerator.GeneratorClosedException generatorClosedException) {
                this.state = State.COMPLETED;
            }
            catch (JavaScriptException javaScriptException) {
                this.state = State.COMPLETED;
                if (javaScriptException.getValue() instanceof NativeIterator.StopIteration) {
                    ScriptableObject.putProperty(scriptable2, "value", ((NativeIterator.StopIteration)javaScriptException.getValue()).getValue());
                    break block22;
                }
                this.lineNumber = javaScriptException.lineNumber();
                this.lineSource = javaScriptException.lineSource();
                if (javaScriptException.getValue() instanceof RhinoException) {
                    throw (RhinoException)javaScriptException.getValue();
                }
                throw javaScriptException;
            }
            catch (RhinoException rhinoException) {
                this.state = State.COMPLETED;
                this.lineNumber = rhinoException.lineNumber();
                this.lineSource = rhinoException.lineSource();
                throw rhinoException;
            }
            finally {
                if (this.state == State.COMPLETED) {
                    this.delegee = null;
                    ScriptableObject.putProperty(scriptable2, "done", (Object)Boolean.TRUE);
                }
            }
        }
        return scriptable2;
    }

    private Object callReturnOptionally(Context context, Scriptable scriptable, Object object) {
        Object[] objectArray;
        if (Undefined.instance.equals(object)) {
            objectArray = ScriptRuntime.emptyArgs;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = object;
        }
        Object[] objectArray3 = objectArray;
        Object object2 = ScriptRuntime.getObjectPropNoWarn(this.delegee, "return", context, scriptable);
        if (!Undefined.instance.equals(object2)) {
            if (!(object2 instanceof Callable)) {
                throw ScriptRuntime.typeErrorById("msg.isnt.function", "return", ScriptRuntime.typeof(object2));
            }
            return ((Callable)object2).call(context, scriptable, ES6Generator.ensureScriptable(this.delegee), objectArray3);
        }
        return null;
    }

    @Override
    protected int findPrototypeId(Symbol symbol) {
        if (SymbolKey.ITERATOR.equals(symbol)) {
            return 4;
        }
        return 0;
    }

    @Override
    protected int findPrototypeId(String string) {
        int n;
        block5: {
            n = 0;
            String string2 = null;
            int n2 = string.length();
            if (n2 == 4) {
                string2 = "next";
                n = 1;
            } else if (n2 == 5) {
                string2 = "throw";
                n = 3;
            } else if (n2 == 6) {
                string2 = "return";
                n = 2;
            }
            if (string2 == null || string2 == string || string2.equals(string)) break block5;
            n = 0;
        }
        return n;
    }

    static enum State {
        SUSPENDED_START,
        SUSPENDED_YIELD,
        EXECUTING,
        COMPLETED;

    }

    public static final class YieldStarResult {
        private Object result;

        public YieldStarResult(Object object) {
            this.result = object;
        }

        Object getResult() {
            return this.result;
        }
    }
}

