/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.pattern;

import org.gradle.api.internal.file.pattern.PatternStep;

public class HasSuffixPatternStep
implements PatternStep {
    private final String suffix;
    private final boolean caseSensitive;
    private final int suffixLength;
    private final int prefixLength;

    public HasSuffixPatternStep(String suffix, boolean caseSensitive) {
        this(suffix, caseSensitive, 0);
    }

    HasSuffixPatternStep(String suffix, boolean caseSensitive, int prefixLength) {
        this.suffix = suffix;
        this.suffixLength = suffix.length();
        this.caseSensitive = caseSensitive;
        this.prefixLength = prefixLength;
    }

    public String toString() {
        return "{suffix: " + this.suffix + "}";
    }

    @Override
    public boolean matches(String candidate) {
        return this.isLongEnough(candidate) && candidate.regionMatches(!this.caseSensitive, candidate.length() - this.suffixLength, this.suffix, 0, this.suffixLength);
    }

    private boolean isLongEnough(String candidate) {
        return this.prefixLength + this.suffixLength <= candidate.length();
    }
}

