/*
 * Decompiled with CFR 0.152.
 */
package jme;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jme.JME;

class MultiBox
extends JFrame
implements KeyListener {
    JTextField smilesText;
    JME jme;

    MultiBox(int box, JME jme) {
        this.jme = jme;
        this.setFont(jme.fontSmall);
        this.setBackground(JME.bgColor);
        this.setResizable(false);
        this.addKeyListener(this);
        if (box == 1) {
            this.createSmilesBox(jme.Smiles());
        } else if (box == 2) {
            this.createAtomxBox();
        } else {
            this.createAboutBox();
        }
        this.pack();
        this.setVisible(true);
    }

    void createAboutBox() {
        this.setTitle("about JSME");
        this.setLayout(new GridLayout(0, 1, 0, 0));
        this.setFont(this.jme.fontSmall);
        this.setBackground(JME.bgColor);
        this.add(new JLabel("JSME Molecular Editor v2023.01", 0));
        this.add(new JLabel("Peter Ertl, Bruno BienFait. and Robert Hanson", 0));
        JPanel p = new JPanel();
        JButton b = new JButton("Close");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiBox.this.jme.aboutBoxPoint = MultiBox.this.jme.aboutBox.getLocationOnScreen();
                MultiBox.this.jme.aboutBox.setVisible(false);
            }
        });
        p.add(b);
        this.add(p);
        this.setLocation(this.jme.aboutBoxPoint);
    }

    void createSmilesBox(String smiles) {
        this.setTitle("SMILES");
        this.setLayout(new BorderLayout(2, 0));
        this.smilesText = new JTextField(smiles + "     ");
        if (!this.jme.runsmi) {
            this.smilesText.setEditable(false);
        }
        this.add("Center", this.smilesText);
        JPanel p = new JPanel();
        JButton b = new JButton("Close");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiBox.this.jme.smilesBoxPoint = MultiBox.this.jme.smilesBox.getLocationOnScreen();
                MultiBox.this.jme.smilesBox.setVisible(false);
            }
        });
        p.add(b);
        if (this.jme.runsmi) {
            b = new JButton("Submit");
            p.add(b);
        }
        this.add("South", p);
        this.smilesText.setText(this.smilesText.getText().trim());
        this.setResizable(true);
        this.setLocation(this.jme.smilesBoxPoint);
    }

    void setSmiles(String smiles) {
        Dimension d = this.getSize();
        int l = this.jme.fontSmallMet.stringWidth(smiles) + 30;
        if (l < 150) {
            l = 150;
        }
        this.setSize(l, d.height);
        this.validate();
        this.smilesText.setText(smiles);
    }

    void createAtomxBox() {
        this.setTitle("nonstandard atom");
        this.setLayout(new BorderLayout(2, 0));
        JPanel p = new JPanel();
        p.add(new JLabel("atomic SMILES", 0));
        this.add("North", p);
        String as = "H";
        if (this.jme.atomicSymbol != null) {
            as = this.jme.atomicSymbol.getText();
        }
        this.jme.atomicSymbol = new JTextField(as, 8);
        this.add("Center", this.jme.atomicSymbol);
        p = new JPanel();
        JButton b = new JButton("Close ");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiBox.this.jme.atomxBoxPoint = MultiBox.this.jme.atomxBox.getLocationOnScreen();
                MultiBox.this.jme.atomxBox.setVisible(false);
            }
        });
        p.add(b);
        this.add("South", p);
        this.setLocation(this.jme.atomxBoxPoint);
    }

    public boolean keyDown(KeyEvent e, int key) {
        if (this.jme.atomicSymbol == null) {
            return false;
        }
        if (this.jme.action != 1201) {
            this.jme.action = 1201;
            this.jme.active_an = 18;
        }
        return false;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.keyDown(e, e.getKeyCode());
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

