/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.SB;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Logger;

public class OptimadeReader
extends AtomSetCollectionReader {
    private int modelNo;
    private boolean iHaveDesiredModel;
    private int permutation;
    private boolean isPolymer;
    private boolean isSlab;
    private boolean noSlab;
    private float[] xyz = new float[3];

    @Override
    protected void initializeReader() throws Exception {
        super.initializeReader();
        this.noSlab = this.checkFilterKey("NOSLAB");
        try {
            String strJSON = (String)this.htParams.get("fileData");
            if (strJSON == null) {
                SB sb = new SB();
                while (this.rd() != null) {
                    sb.append(this.line);
                }
                strJSON = sb.toString();
                this.line = null;
            }
            List aData = null;
            if (strJSON.startsWith("[")) {
                Lst<Object> data = this.vwr.parseJSONArray(strJSON);
                for (int i = 0; !(i >= data.size() || data.get(i) instanceof Map && (aData = (List)((Map)data.get(i)).get("data")) != null); ++i) {
                }
            } else {
                aData = (List)this.vwr.parseJSONMap(strJSON).get("data");
            }
            if (aData != null) {
                for (int i = 0; !this.iHaveDesiredModel && i < aData.size(); ++i) {
                    Map data = (Map)aData.get(i);
                    if (!"structures".equals(data.get("type"))) continue;
                    this.readModel((Map)data.get("attributes"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.continuing = false;
    }

    private void readModel(Map<String, Object> map) throws Exception {
        this.modelNumber = ++this.modelNo;
        if (!this.doGetModel(this.modelNo, null)) {
            return;
        }
        this.iHaveDesiredModel = this.isLastModel(this.modelNumber);
        this.applySymmetryAndSetTrajectory();
        this.asc.newAtomSet();
        this.setFractionalCoordinates(false);
        float[] dimensionType = new float[3];
        if (OptimadeReader.toFloatArray((List)map.get("dimension_types"), dimensionType)) {
            this.checkDimensionType(dimensionType);
        }
        if (!this.isMolecular) {
            this.setSpaceGroupName("P1");
            this.asc.setInfo("symmetryType", this.isSlab ? "2D - SLAB" : (this.isPolymer ? "1D - POLYMER" : "3D"));
        }
        this.asc.setAtomSetName((String)map.get("chemical_formula_descriptive"));
        this.doConvertToFractional = !this.isMolecular && this.readLattice((List)map.get("lattice_vectors"));
        this.readAtoms((List)map.get("species"), (List)map.get("species_at_sites"), (List)map.get("cartesian_site_positions"));
    }

    private void checkDimensionType(float[] dt) {
        this.isMolecular = false;
        this.isSlab = false;
        this.isPolymer = false;
        if (this.noSlab) {
            return;
        }
        this.permutation = 0;
        switch ((int)(dt[2] + dt[1] * 2.0f + dt[0] * 4.0f)) {
            default: {
                this.isMolecular = true;
                break;
            }
            case 1: {
                this.isPolymer = true;
                this.permutation = 1;
                break;
            }
            case 2: {
                this.isPolymer = true;
                this.permutation = 2;
                break;
            }
            case 3: {
                this.isSlab = true;
                this.permutation = 2;
                break;
            }
            case 5: {
                this.isSlab = true;
                this.permutation = 1;
                break;
            }
            case 4: {
                this.isPolymer = true;
                break;
            }
            case 6: {
                this.isSlab = true;
            }
            case 7: 
        }
    }

    private boolean readLattice(List<Object> lattice) {
        if (lattice == null) {
            return false;
        }
        float[] abc = new float[3];
        for (int i = 0; i < 3; ++i) {
            if (!OptimadeReader.toFloatArray((List)lattice.get(i), this.xyz)) {
                return false;
            }
            this.unitCellParams[0] = Float.NaN;
            if (this.isSlab || this.isPolymer) {
                abc[i] = (float)Math.sqrt(this.xyz[0] * this.xyz[0] + this.xyz[1] * this.xyz[1] + this.xyz[2] * this.xyz[2]);
                if (abc[i] >= 500.0f) {
                    this.xyz[0] = this.xyz[0] / abc[i];
                    this.xyz[1] = this.xyz[1] / abc[i];
                    this.xyz[2] = this.xyz[2] / abc[i];
                }
            }
            if (this.isSlab || this.isPolymer) {
                this.unitCellParams[0] = 0.0f;
            }
            if (i == 2 && (this.isSlab || this.isPolymer)) {
                this.unitCellParams[0] = abc[this.permutation];
                if (this.isSlab) {
                    this.unitCellParams[1] = abc[(this.permutation + 1) % 3];
                }
            }
            this.addExplicitLatticeVector((i + this.permutation) % 3, this.xyz, 0);
        }
        this.doApplySymmetry = true;
        return true;
    }

    private void readAtoms(List<Object> species, List<Object> sites, List<Object> coords) {
        int i;
        int natoms = sites.size();
        HashMap<String, Map> speciesByName = null;
        if (species == null) {
            Logger.error("OptimadeReader - no 'species' key");
        } else {
            speciesByName = new HashMap<String, Map>();
            i = species.size();
            while (--i >= 0) {
                Map s = (Map)species.get(i);
                speciesByName.put((String)s.get("name"), s);
            }
        }
        for (i = 0; i < natoms; ++i) {
            String sname = (String)sites.get(i);
            OptimadeReader.toFloatArray((List)coords.get(i), this.xyz);
            if (species == null) {
                this.addAtom(this.xyz, (String)sites.get(i), sname);
                continue;
            }
            Map sp = (Map)speciesByName.get(sname);
            List syms = (List)sp.get("chemical_symbols");
            int nOcc = syms.size();
            if (nOcc > 1) {
                float[] conc = new float[nOcc];
                if (OptimadeReader.toFloatArray((List)sp.get("concentration"), conc)) {
                    for (int j = 0; j < conc.length; ++j) {
                        Atom a = this.addAtom(this.xyz, (String)syms.get(j), sname);
                        a.foccupancy = conc[j];
                    }
                    continue;
                }
            }
            this.addAtom(this.xyz, (String)syms.get(0), sname);
        }
    }

    private Atom addAtom(float[] xyz, String sym, String name) {
        Atom atom = this.asc.addNewAtom();
        if (sym != null) {
            atom.elementSymbol = sym;
        }
        if (name != null) {
            atom.atomName = name;
        }
        this.setAtomCoordXYZ(atom, xyz[0], xyz[1], xyz[2]);
        return atom;
    }

    private static boolean toFloatArray(List<Number> list, float[] a) {
        if (list == null) {
            return false;
        }
        int i = a.length;
        while (--i >= 0) {
            Number d = list.get(i);
            if (d == null) {
                return false;
            }
            a[i] = list.get(i).floatValue();
        }
        return true;
    }

    @Override
    protected void finalizeSubclassSymmetry(boolean haveSymmetry) throws Exception {
        super.finalizeSubclassSymmetry(haveSymmetry);
    }
}

