/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import javajs.util.Lst;
import org.jmol.script.ScriptManager;
import org.jmol.thread.JmolThread;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public class ScriptQueueThread
extends JmolThread {
    private ScriptManager scriptManager;
    private boolean startedByCommandThread = false;
    private int pt;

    public ScriptQueueThread(ScriptManager scriptManager, Viewer vwr, boolean startedByCommandThread, int pt) {
        this.setViewer(vwr, "QueueThread" + pt);
        this.scriptManager = scriptManager;
        this.vwr = vwr;
        this.startedByCommandThread = startedByCommandThread;
        this.pt = pt;
    }

    @Override
    protected void run1(int mode) throws InterruptedException {
        block5: while (true) {
            switch (mode) {
                case -1: {
                    mode = 0;
                    break;
                }
                case 0: {
                    if (this.stopped || this.scriptManager.getScriptQueue().size() == 0) {
                        mode = -2;
                        break;
                    }
                    if (this.runNextScript() || this.runSleep(100, 0)) continue block5;
                    return;
                }
                case -2: {
                    this.scriptManager.queueThreadFinished(this.pt);
                    return;
                }
            }
        }
    }

    private boolean runNextScript() {
        Lst<Lst<Object>> queue = this.scriptManager.getScriptQueue();
        if (queue.size() == 0) {
            return false;
        }
        Lst<Object> scriptItem = this.scriptManager.getScriptItem(false, this.startedByCommandThread);
        if (scriptItem == null) {
            return false;
        }
        if (Logger.debugging) {
            Logger.debug("Queue[" + this.pt + "][" + queue.size() + "] scripts; running: " + scriptItem.get(0));
        }
        queue.removeItemAt(0);
        this.scriptManager.runScriptFromThread(scriptItem);
        return queue.size() != 0;
    }
}

