/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.console;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javajs.util.PT;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Keymap;
import org.jmol.api.JmolAbstractButton;
import org.jmol.api.js.GenericConsoleTextArea;
import org.jmol.console.JmolConsole;
import org.jmol.console.JmolLabel;
import org.jmol.console.KeyJMenu;
import org.jmol.console.KeyJMenuItem;
import org.jmol.script.T;
import org.jmol.viewer.Viewer;

public class AppletConsole
extends JmolConsole {
    public AppletConsole() {
        this.input = new ControlEnterTextArea();
        this.output = new GenericTextPane();
    }

    @Override
    public void start(Viewer vwr) {
        this.setViewer(vwr);
        Component display = (Component)vwr.display;
        this.vwrFrame = display instanceof JFrame ? (JFrame)display : null;
        JFrame jf = new JFrame();
        jf.setSize(600, 400);
        this.externalContainer = jf;
        this.setLabels();
        JTextArea ta = (JTextArea)((Object)this.input);
        ta.setLineWrap(true);
        ta.setWrapStyleWord(true);
        ta.setDragEnabled(true);
        Keymap map = ta.getKeymap();
        KeyStroke shiftA = KeyStroke.getKeyStroke(65, 1);
        map.removeKeyStrokeBinding(shiftA);
        ((JTextPane)((Object)this.output)).setEditable(false);
        ((JTextPane)((Object)this.output)).setDragEnabled(true);
        this.addWindowListener();
        this.displayConsole();
    }

    @Override
    protected JmolAbstractButton getLabel1() {
        return new JmolLabel(AppletConsole.getLabel("label1"), 0);
    }

    @Override
    protected void layoutWindow(String enabledButtons) {
        JScrollPane jscrollInput = new JScrollPane((JTextArea)((Object)this.input));
        jscrollInput.setMinimumSize(new Dimension(2, 100));
        JScrollPane jscrollOutput = new JScrollPane((JTextPane)((Object)this.output));
        jscrollOutput.setMinimumSize(new Dimension(2, 100));
        Container c = this.getPane();
        c.setLayout(new BoxLayout(c, 1));
        JSplitPane jsp = new JSplitPane(0, jscrollOutput, jscrollInput);
        jsp.setResizeWeight(0.9);
        jsp.setDividerLocation(200);
        jsp.setAlignmentX(0.5f);
        c.add(jsp);
        Container c2 = new Container();
        c2.setLayout(new BoxLayout(c2, 0));
        c2.add(Box.createGlue());
        this.add(c2, this.editButton);
        this.add(c2, this.runButton);
        this.add(c2, this.loadButton);
        this.add(c2, this.clearInButton);
        this.add(c2, this.clearOutButton);
        this.add(c2, this.historyButton);
        this.add(c2, this.stateButton);
        c2.add(Box.createGlue());
        c.add(c2);
        if (this.label1 != null) {
            ((JLabel)((Object)this.label1)).setAlignmentX(0.5f);
            c.add((JLabel)((Object)this.label1));
        }
        if (this.externalContainer instanceof JFrame) {
            ((JFrame)this.externalContainer).setJMenuBar(this.createMenubar());
        }
    }

    private void add(Container c2, JmolAbstractButton b) {
        c2.add((JButton)((Object)b));
    }

    private JMenuBar createMenubar() {
        JMenuBar mb = new JMenuBar();
        mb.add(Box.createHorizontalGlue());
        this.addHelpMenuBar(mb);
        return mb;
    }

    private void addHelpMenuBar(JMenuBar menuBar) {
        KeyJMenu m0 = new KeyJMenu("help", AppletConsole.getLabel("help"), this.menuMap);
        JMenuItem item = this.createMenuItem("search");
        item.addActionListener(this);
        item.setName("help ?search=?");
        m0.add(item);
        this.addHelpItems(m0, "commands", "command");
        this.addHelpItems(m0, "functions", "mathfunc");
        this.addHelpItems(m0, "parameters", "setparam");
        this.addHelpItems(m0, "more", "misc");
        menuBar.add(m0);
    }

    private void addHelpItems(JMenu m0, String key, String attr) {
        KeyJMenu m = new KeyJMenu(key, AppletConsole.getLabel(key), this.menuMap);
        String[] commands = T.getTokensLike(attr);
        m0.add(m);
        JMenu m2 = null;
        String firstCommand = null;
        int n = 20;
        for (int i = 0; i < commands.length; ++i) {
            String cmd = commands[i];
            if (!PT.isLetter(cmd.charAt(0))) continue;
            JMenuItem item = new JMenuItem(cmd);
            item.addActionListener(this);
            item.setName("help " + cmd);
            if (m2 == null) {
                m2 = new JMenu();
                firstCommand = cmd;
                m2.add(item);
                m2.setText(firstCommand);
                continue;
            }
            if (i % n + 1 == n) {
                m2.add(item);
                m2.setText(firstCommand + " - " + cmd);
                m.add(m2);
                m2 = null;
                continue;
            }
            m2.add(item);
            if (i + 1 != commands.length) continue;
            m2.setText(firstCommand + " - " + cmd);
            m.add(m2);
        }
    }

    private JMenuItem createMenuItem(String cmd) {
        return new KeyJMenuItem(cmd, AppletConsole.getLabel(cmd), this.menuMap);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.regainFocus();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.doAction(e.getSource());
    }

    @Override
    protected void execute(String strCommand) {
        super.execute(strCommand);
        if (strCommand == null) {
            this.regainFocus();
        }
    }

    @Override
    public void regainFocus() {
        ((JTextArea)((Object)this.input)).requestFocus();
    }

    class ControlEnterTextArea
    extends JTextArea
    implements GenericConsoleTextArea {
        ControlEnterTextArea() {
        }

        @Override
        public void processComponentKeyEvent(KeyEvent ke) {
            boolean isControlDown;
            int kid;
            int kcode = ke.getKeyCode();
            int mode = AppletConsole.this.processKey(kcode, kid = ke.getID(), isControlDown = ke.isControlDown());
            if ((mode & 1) == 1) {
                ke.consume();
            }
            if ((mode & 2) == 2) {
                if (kcode == 10) {
                    ke.setModifiers(0);
                }
                super.processComponentKeyEvent(ke);
            }
        }
    }

    private class GenericTextPane
    extends JTextPane
    implements GenericConsoleTextArea {
        private final Document outputDocument = this.getDocument();

        GenericTextPane() {
        }

        @Override
        public void append(String message) {
            try {
                this.outputDocument.insertString(this.outputDocument.getLength(), message, null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.setCaretPosition(this.outputDocument.getLength());
        }
    }
}

