/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.AttributeClassification;
import org.hibernate.metamodel.internal.AttributeMetadata;
import org.hibernate.metamodel.internal.MetadataContext;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.internal.MapMember;
import org.hibernate.type.CollectionType;

public abstract class BaseAttributeMetadata<X, Y>
implements AttributeMetadata<X, Y> {
    private final Property propertyMapping;
    private final ManagedDomainType<X> ownerType;
    private final Member member;
    private final Class<Y> javaType;
    private final AttributeClassification attributeClassification;

    protected BaseAttributeMetadata(Property propertyMapping, ManagedDomainType<X> ownerType, Member member, AttributeClassification attributeClassification, MetadataContext metadataContext) {
        Class<?> declaredType;
        this.propertyMapping = propertyMapping;
        this.ownerType = ownerType;
        this.member = member;
        this.attributeClassification = attributeClassification;
        if (member == null) {
            declaredType = propertyMapping.getType().getReturnedClass();
        } else if (member instanceof Field) {
            declaredType = ((Field)member).getType();
        } else if (member instanceof Method) {
            declaredType = ((Method)member).getReturnType();
        } else if (member instanceof MapMember) {
            declaredType = ((MapMember)member).getType();
        } else {
            throw new IllegalArgumentException("Cannot determine java-type from given member [" + String.valueOf(member) + "]");
        }
        this.javaType = declaredType;
    }

    @Override
    public String getName() {
        return this.propertyMapping.getName();
    }

    @Override
    public Member getMember() {
        return this.member;
    }

    public String getMemberDescription() {
        return this.determineMemberDescription(this.getMember());
    }

    public String determineMemberDescription(Member member) {
        return member.getDeclaringClass().getName() + "#" + member.getName();
    }

    @Override
    public Class<Y> getJavaType() {
        return this.javaType;
    }

    @Override
    public AttributeClassification getAttributeClassification() {
        return this.attributeClassification;
    }

    @Override
    public ManagedDomainType<X> getOwnerType() {
        return this.ownerType;
    }

    @Override
    public boolean isPlural() {
        return this.propertyMapping.getType() instanceof CollectionType;
    }

    @Override
    public Property getPropertyMapping() {
        return this.propertyMapping;
    }
}

