/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.function.BiConsumer;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.DiscriminatedAssociationModelPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectablePath;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchOptions;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.descriptor.java.JavaType;

public class AnyKeyPart
implements BasicValuedModelPart,
FetchOptions {
    public static final String KEY_NAME = "{key}";
    private final NavigableRole navigableRole;
    private final String table;
    private final String column;
    private final SelectablePath selectablePath;
    private final DiscriminatedAssociationModelPart anyPart;
    private final String customReadExpression;
    private final String customWriteExpression;
    private final String columnDefinition;
    private final Long length;
    private final Integer precision;
    private final Integer scale;
    private final boolean nullable;
    private final boolean insertable;
    private final boolean updateable;
    private final boolean partitioned;
    private final JdbcMapping jdbcMapping;

    public AnyKeyPart(NavigableRole navigableRole, DiscriminatedAssociationModelPart anyPart, String table, String column, SelectablePath selectablePath, String customReadExpression, String customWriteExpression, String columnDefinition, Long length, Integer precision, Integer scale, boolean nullable, boolean insertable, boolean updateable, boolean partitioned, JdbcMapping jdbcMapping) {
        this.navigableRole = navigableRole;
        this.table = table;
        this.column = column;
        this.selectablePath = selectablePath;
        this.anyPart = anyPart;
        this.customReadExpression = customReadExpression;
        this.customWriteExpression = customWriteExpression;
        this.columnDefinition = columnDefinition;
        this.length = length;
        this.precision = precision;
        this.scale = scale;
        this.nullable = nullable;
        this.insertable = insertable;
        this.updateable = updateable;
        this.partitioned = partitioned;
        this.jdbcMapping = jdbcMapping;
    }

    @Override
    public String getContainingTableExpression() {
        return this.table;
    }

    @Override
    public String getSelectionExpression() {
        return this.column;
    }

    @Override
    public String getSelectableName() {
        return this.selectablePath.getSelectableName();
    }

    @Override
    public SelectablePath getSelectablePath() {
        return this.selectablePath;
    }

    @Override
    public boolean isFormula() {
        return false;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public boolean isInsertable() {
        return this.insertable;
    }

    @Override
    public boolean isUpdateable() {
        return this.updateable;
    }

    @Override
    public boolean isPartitioned() {
        return this.partitioned;
    }

    @Override
    public String getCustomReadExpression() {
        return this.customReadExpression;
    }

    @Override
    public String getCustomWriteExpression() {
        return this.customWriteExpression;
    }

    @Override
    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    @Override
    public Long getLength() {
        return this.length;
    }

    @Override
    public Integer getPrecision() {
        return this.precision;
    }

    @Override
    public Integer getScale() {
        return this.scale;
    }

    @Override
    public Integer getTemporalPrecision() {
        return null;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.jdbcMapping;
    }

    @Override
    public JavaType<?> getJavaType() {
        return this.jdbcMapping.getMappedJavaType();
    }

    @Override
    public String getPartName() {
        return KEY_NAME;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.anyPart.findContainingEntityMapping();
    }

    @Override
    public MappingType getMappedType() {
        return this.jdbcMapping;
    }

    @Override
    public String getFetchableName() {
        return this.getPartName();
    }

    @Override
    public int getFetchableKey() {
        return 1;
    }

    @Override
    public FetchOptions getMappedFetchOptions() {
        return this;
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        FromClauseAccess fromClauseAccess = creationState.getSqlAstCreationState().getFromClauseAccess();
        SqlExpressionResolver sqlExpressionResolver = creationState.getSqlAstCreationState().getSqlExpressionResolver();
        SessionFactoryImplementor sessionFactory = creationState.getSqlAstCreationState().getCreationContext().getSessionFactory();
        TableGroup tableGroup = fromClauseAccess.getTableGroup(fetchParent.getNavigablePath().getParent());
        TableReference tableReference = tableGroup.resolveTableReference(fetchablePath, this.table);
        Expression columnReference = sqlExpressionResolver.resolveSqlExpression(tableReference, this);
        SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(columnReference, this.jdbcMapping.getJdbcJavaType(), fetchParent, sessionFactory.getTypeConfiguration());
        return new BasicFetch(sqlSelection.getValuesArrayPosition(), fetchParent, fetchablePath, this, fetchTiming, creationState, !sqlSelection.isVirtual());
    }

    @Override
    public FetchStyle getStyle() {
        return FetchStyle.SELECT;
    }

    @Override
    public FetchTiming getTiming() {
        return FetchTiming.IMMEDIATE;
    }

    @Override
    public int forEachSelectable(int offset, SelectableConsumer consumer) {
        consumer.accept(offset, this);
        return this.getJdbcTypeCount();
    }

    @Override
    public <X, Y> int breakDownJdbcValues(Object domainValue, int offset, X x, Y y, ModelPart.JdbcValueBiConsumer<X, Y> valueConsumer, SharedSessionContractImplementor session) {
        valueConsumer.consume(offset, x, y, domainValue, this);
        return this.getJdbcTypeCount();
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        action.accept(offset, this.jdbcMapping);
        return this.getJdbcTypeCount();
    }

    @Override
    public <X, Y> int forEachJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(offset, x, y, value, this.jdbcMapping);
        return this.getJdbcTypeCount();
    }

    @Override
    public JdbcMapping getJdbcMapping(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException(index);
        }
        return this.jdbcMapping;
    }

    @Override
    public JdbcMapping getSingleJdbcMapping() {
        return this.jdbcMapping;
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return value;
    }

    @Override
    public <X, Y> int forEachDisassembledJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(offset, x, y, value, this.jdbcMapping);
        return 1;
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        SqlSelection sqlSelection = this.resolveSqlSelection(navigablePath, tableGroup, creationState);
        return new BasicResult(sqlSelection.getValuesArrayPosition(), resultVariable, this.jdbcMapping, navigablePath, false, !sqlSelection.isVirtual());
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.resolveSqlSelection(navigablePath, tableGroup, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        selectionConsumer.accept(this.resolveSqlSelection(navigablePath, tableGroup, creationState), this.getJdbcMapping());
    }

    private SqlSelection resolveSqlSelection(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        TableReference tableReference = tableGroup.resolveTableReference(navigablePath, this, this.getContainingTableExpression());
        SqlExpressionResolver expressionResolver = creationState.getSqlAstCreationState().getSqlExpressionResolver();
        return expressionResolver.resolveSqlSelection(expressionResolver.resolveSqlExpression(tableReference, this), this.jdbcMapping.getJdbcJavaType(), null, creationState.getSqlAstCreationState().getCreationContext().getSessionFactory().getTypeConfiguration());
    }
}

