/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.mdc.provider;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jboss.logmanager.MDCProvider;

public class LateBoundMDCProvider
implements MDCProvider {
    private static volatile MDCProvider delegate;
    private final InheritableThreadLocal<Map<String, Object>> threadLocalMap = new InheritableThreadLocal<Map<String, Object>>(){

        @Override
        protected Map<String, Object> childValue(Map<String, Object> parentValue) {
            if (parentValue == null) {
                return null;
            }
            return new HashMap<String, Object>(parentValue);
        }
    };

    public static synchronized void setMDCProviderDelegate(MDCProvider delegate) {
        LateBoundMDCProvider.delegate = delegate;
    }

    public String get(String key) {
        if (delegate == null) {
            Object value = this.getLocal(key);
            return value != null ? value.toString() : null;
        }
        return delegate.get(key);
    }

    public Object getObject(String key) {
        if (delegate == null) {
            return this.getLocal(key);
        }
        return delegate.getObject(key);
    }

    public String put(String key, String value) {
        if (delegate == null) {
            Object oldValue = this.putLocal(key, value);
            return oldValue != null ? oldValue.toString() : null;
        }
        return delegate.put(key, value);
    }

    public Object putObject(String key, Object value) {
        if (delegate == null) {
            return this.putLocal(key, value);
        }
        return delegate.putObject(key, value);
    }

    public String remove(String key) {
        if (delegate == null) {
            Object oldValue = this.removeLocal(key);
            return oldValue != null ? oldValue.toString() : null;
        }
        return delegate.remove(key);
    }

    public Object removeObject(String key) {
        if (delegate == null) {
            return this.removeLocal(key);
        }
        return delegate.removeObject(key);
    }

    public Map<String, String> copy() {
        if (delegate == null) {
            HashMap<String, String> result = new HashMap<String, String>();
            Map currentMap = (Map)this.threadLocalMap.get();
            if (currentMap != null) {
                for (Map.Entry entry : currentMap.entrySet()) {
                    result.put((String)entry.getKey(), entry.getValue().toString());
                }
            }
            return result;
        }
        return delegate.copy();
    }

    public Map<String, Object> copyObject() {
        if (delegate == null) {
            Map currentMap = (Map)this.threadLocalMap.get();
            if (currentMap != null) {
                return new HashMap<String, Object>(currentMap);
            }
            return Collections.emptyMap();
        }
        return delegate.copyObject();
    }

    public boolean isEmpty() {
        if (delegate == null) {
            Map currentMap = (Map)this.threadLocalMap.get();
            return currentMap == null || currentMap.isEmpty();
        }
        return delegate.isEmpty();
    }

    public void clear() {
        if (delegate == null) {
            Map map = (Map)this.threadLocalMap.get();
            if (map != null) {
                map.clear();
                this.threadLocalMap.remove();
            }
        } else {
            delegate.clear();
        }
    }

    private Object putLocal(String key, Object value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        HashMap<String, Object> map = (HashMap<String, Object>)this.threadLocalMap.get();
        if (map == null) {
            map = new HashMap<String, Object>();
            this.threadLocalMap.set(map);
        }
        return map.put(key, value);
    }

    private Object getLocal(String key) {
        Objects.requireNonNull(key);
        Map map = (Map)this.threadLocalMap.get();
        if (map != null) {
            return map.get(key);
        }
        return null;
    }

    private Object removeLocal(String key) {
        Objects.requireNonNull(key);
        Map map = (Map)this.threadLocalMap.get();
        if (map != null) {
            return map.remove(key);
        }
        return null;
    }
}

