/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.formatters;

import io.smallrye.common.constraint.Assert;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.AttributedCharacterIterator;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalUnit;
import java.time.temporal.ValueRange;
import java.util.Calendar;
import java.util.Date;
import java.util.Formattable;
import java.util.Formatter;
import java.util.IllegalFormatConversionException;
import java.util.IllegalFormatFlagsException;
import java.util.IllegalFormatPrecisionException;
import java.util.Locale;
import java.util.MissingFormatArgumentException;
import java.util.Objects;
import java.util.TimeZone;
import java.util.UnknownFormatConversionException;
import org.jboss.logmanager.formatters.GeneralFlag;
import org.jboss.logmanager.formatters.GeneralFlags;
import org.jboss.logmanager.formatters.NumericFlag;
import org.jboss.logmanager.formatters.NumericFlags;

class Printf {
    private static final String someSpaces = "                                ";
    private static final String someZeroes = "00000000000000000000000000000000";
    private final Locale locale;
    private volatile DateFormatSymbols dfs;
    public static final Printf DEFAULT = new Printf(Locale.getDefault(Locale.Category.FORMAT));
    private static final int ST_INITIAL = 0;
    private static final int ST_PCT = 1;
    private static final int ST_TIME = 2;
    private static final int ST_WIDTH = 3;
    private static final int ST_DOT = 4;
    private static final int ST_PREC = 5;
    private static final int ST_DOLLAR = 6;
    private static final BigDecimal NEG_ONE = BigDecimal.ONE.negate();
    private static final BigDecimal NEG_TEN_EM4 = BigDecimal.valueOf(10L, -4);
    private static final TemporalField MILLIS_OF_INSTANT = new TemporalField(){

        @Override
        public TemporalUnit getBaseUnit() {
            return ChronoUnit.MILLIS;
        }

        @Override
        public TemporalUnit getRangeUnit() {
            return ChronoUnit.FOREVER;
        }

        @Override
        public ValueRange range() {
            return ValueRange.of(Long.MIN_VALUE, Long.MAX_VALUE);
        }

        @Override
        public boolean isDateBased() {
            return true;
        }

        @Override
        public boolean isTimeBased() {
            return false;
        }

        @Override
        public boolean isSupportedBy(TemporalAccessor temporal) {
            return temporal.isSupported(ChronoField.INSTANT_SECONDS) && temporal.isSupported(ChronoField.MILLI_OF_SECOND);
        }

        @Override
        public ValueRange rangeRefinedBy(TemporalAccessor temporal) {
            return this.range();
        }

        @Override
        public long getFrom(TemporalAccessor temporal) {
            return (long)temporal.get(ChronoField.INSTANT_SECONDS) * 1000L + (long)temporal.get(ChronoField.MILLI_OF_SECOND);
        }

        @Override
        public <R extends Temporal> R adjustInto(R temporal, long newValue) {
            long millis = newValue % 1000L;
            long seconds = newValue / 1000L;
            return (R)temporal.with(ChronoField.INSTANT_SECONDS, millis).with(ChronoField.MILLI_OF_SECOND, seconds);
        }
    };
    private static final TemporalField YEAR_OF_CENTURY = new TemporalField(){

        @Override
        public TemporalUnit getBaseUnit() {
            return ChronoUnit.YEARS;
        }

        @Override
        public TemporalUnit getRangeUnit() {
            return ChronoUnit.CENTURIES;
        }

        @Override
        public ValueRange range() {
            return ValueRange.of(0L, 99L);
        }

        @Override
        public boolean isDateBased() {
            return false;
        }

        @Override
        public boolean isTimeBased() {
            return false;
        }

        @Override
        public boolean isSupportedBy(TemporalAccessor temporal) {
            return temporal.isSupported(ChronoField.YEAR);
        }

        @Override
        public ValueRange rangeRefinedBy(TemporalAccessor temporal) {
            return this.range();
        }

        @Override
        public long getFrom(TemporalAccessor temporal) {
            return temporal.get(ChronoField.YEAR) % 100;
        }

        @Override
        public <R extends Temporal> R adjustInto(R temporal, long newValue) {
            return (R)temporal.with(ChronoField.YEAR, (long)(temporal.get(ChronoField.YEAR) / 100 * 100) + newValue);
        }
    };
    private static final TemporalField CENTURY_OF_YEAR = new TemporalField(){

        @Override
        public TemporalUnit getBaseUnit() {
            return ChronoUnit.YEARS;
        }

        @Override
        public TemporalUnit getRangeUnit() {
            return ChronoUnit.CENTURIES;
        }

        @Override
        public ValueRange range() {
            return ValueRange.of(Long.MIN_VALUE, Long.MAX_VALUE);
        }

        @Override
        public boolean isDateBased() {
            return true;
        }

        @Override
        public boolean isTimeBased() {
            return false;
        }

        @Override
        public boolean isSupportedBy(TemporalAccessor temporal) {
            return temporal.isSupported(ChronoField.YEAR);
        }

        @Override
        public ValueRange rangeRefinedBy(TemporalAccessor temporal) {
            return this.range();
        }

        @Override
        public long getFrom(TemporalAccessor temporal) {
            return temporal.get(ChronoField.YEAR) / 100;
        }

        @Override
        public <R extends Temporal> R adjustInto(R temporal, long newValue) {
            return (R)temporal.with(ChronoField.YEAR, (long)(temporal.get(ChronoField.YEAR) % 100) + 100L * newValue);
        }
    };

    public Printf(Locale locale) {
        Assert.checkNotNullParam((String)"locale", (Object)locale);
        this.locale = locale;
    }

    public Printf() {
        this(Locale.getDefault(Locale.Category.FORMAT));
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String format(String format, Object ... params) {
        return this.formatDirect(new StringBuilder(), format, params).toString();
    }

    public <A extends Appendable> A formatBuffered(A destination, String format, Object ... params) throws IOException {
        destination.append(this.formatDirect(new StringBuilder(format.length() << 1), format, params));
        return destination;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public StringBuilder formatDirect(StringBuilder destination, String format, Object ... params) {
        state = 0;
        genFlags = GeneralFlags.NONE;
        numFlags = NumericFlags.NONE;
        precision = -1;
        width = -1;
        argIdx = -1;
        lastArgIdx = -1;
        crs = 0;
        start = -1;
        argVal = null;
        i = 0;
        while (i < format.length()) {
            block116: {
                block119: {
                    block117: {
                        block118: {
                            block115: {
                                cp = format.codePointAt(i);
                                if (state != 0) break block115;
                                if (cp == 37) {
                                    start = i;
                                    state = 1;
                                    genFlags = GeneralFlags.NONE;
                                    numFlags = NumericFlags.NONE;
                                    precision = -1;
                                    width = -1;
                                    lastArgIdx = argIdx;
                                    argIdx = -1;
                                } else {
                                    destination.appendCodePoint(cp);
                                }
                                break block116;
                            }
                            if (state != 1 && state != 6) break block117;
                            if (state != 1 || cp != 60) break block118;
                            if (lastArgIdx == -1) {
                                throw new IllegalFormatFlagsException("<");
                            }
                            argIdx = lastArgIdx;
                            break block116;
                        }
                        switch (cp) {
                            case 46: {
                                state = 4;
                                break block116;
                            }
                            case 32: {
                                numFlags.forbid(NumericFlag.SPACE_POSITIVE);
                                numFlags = numFlags.with(NumericFlag.SPACE_POSITIVE);
                                if (numFlags.contains(NumericFlag.SIGN)) {
                                    numFlags.forbid(NumericFlag.SPACE_POSITIVE);
                                }
                                break block116;
                            }
                            case 43: {
                                numFlags.forbid(NumericFlag.SIGN);
                                numFlags = numFlags.with(NumericFlag.SIGN);
                                if (numFlags.contains(NumericFlag.SPACE_POSITIVE)) {
                                    numFlags.forbid(NumericFlag.SIGN);
                                }
                                break block116;
                            }
                            case 48: {
                                numFlags.forbid(NumericFlag.ZERO_PAD);
                                numFlags = numFlags.with(NumericFlag.ZERO_PAD);
                                if (genFlags.contains(GeneralFlag.LEFT_JUSTIFY)) {
                                    numFlags.forbid(NumericFlag.ZERO_PAD);
                                }
                                break block116;
                            }
                            case 45: {
                                genFlags.forbid(GeneralFlag.LEFT_JUSTIFY);
                                genFlags = genFlags.with(GeneralFlag.LEFT_JUSTIFY);
                                if (numFlags.contains(NumericFlag.ZERO_PAD)) {
                                    genFlags.forbid(GeneralFlag.LEFT_JUSTIFY);
                                }
                                break block116;
                            }
                            case 40: {
                                numFlags.forbid(NumericFlag.NEGATIVE_PARENTHESES);
                                numFlags = numFlags.with(NumericFlag.NEGATIVE_PARENTHESES);
                                break block116;
                            }
                            case 44: {
                                numFlags.forbid(NumericFlag.LOCALE_GROUPING_SEPARATORS);
                                numFlags = numFlags.with(NumericFlag.LOCALE_GROUPING_SEPARATORS);
                                break block116;
                            }
                            case 35: {
                                genFlags.forbid(GeneralFlag.ALTERNATE);
                                genFlags = genFlags.with(GeneralFlag.ALTERNATE);
                                break block116;
                            }
                        }
                        ** GOTO lbl-1000
                    }
                    if (state != 2) break block119;
                    numFlags.forbidAll();
                    genFlags.forbid(GeneralFlag.ALTERNATE);
                    if (precision != -1) {
                        throw Printf.precisionException(precision);
                    }
                    if (argVal == null) {
                        this.formatPlainString(destination, null, genFlags, width, -1);
                    } else {
                        if (argVal instanceof Long) {
                            ta /* !! */  = ZonedDateTime.ofInstant(Instant.ofEpochMilli((Long)argVal), ZoneId.systemDefault());
                        } else if (argVal instanceof Date) {
                            ta /* !! */  = ZonedDateTime.ofInstant(Instant.ofEpochMilli(((Date)argVal).getTime()), ZoneId.systemDefault());
                        } else if (argVal instanceof Calendar) {
                            calendar = (Calendar)argVal;
                            timeZone = calendar.getTimeZone();
                            zoneId = timeZone == null ? ZoneId.systemDefault() : timeZone.toZoneId();
                            ta /* !! */  = ZonedDateTime.ofInstant(calendar.toInstant(), zoneId);
                        } else if (argVal instanceof TemporalAccessor) {
                            ta /* !! */  = (TemporalAccessor)argVal;
                        } else {
                            throw new IllegalFormatConversionException((char)cp, argVal.getClass());
                        }
                        switch (cp) {
                            case 65: {
                                this.formatTimeTextField(destination, ta /* !! */ , ChronoField.DAY_OF_WEEK, this.getDateFormatSymbols().getWeekdays(), genFlags, width);
                                break;
                            }
                            case 97: {
                                this.formatTimeTextField(destination, ta /* !! */ , ChronoField.DAY_OF_WEEK, this.getDateFormatSymbols().getShortWeekdays(), genFlags, width);
                                break;
                            }
                            case 66: {
                                this.formatTimeTextField(destination, ta /* !! */ , ChronoField.MONTH_OF_YEAR, this.getDateFormatSymbols().getMonths(), genFlags, width);
                                break;
                            }
                            case 98: 
                            case 104: {
                                this.formatTimeTextField(destination, ta /* !! */ , ChronoField.MONTH_OF_YEAR, this.getDateFormatSymbols().getShortMonths(), genFlags, width);
                                break;
                            }
                            case 112: {
                                this.formatTimeTextField(destination, ta /* !! */ , ChronoField.AMPM_OF_DAY, this.getDateFormatSymbols().getAmPmStrings(), genFlags, width);
                                break;
                            }
                            case 67: {
                                this.formatTimeField(destination, ta /* !! */ , Printf.CENTURY_OF_YEAR, genFlags, width, 2);
                                break;
                            }
                            case 100: {
                                this.formatTimeField(destination, ta /* !! */ , ChronoField.DAY_OF_MONTH, genFlags, width, 2);
                                break;
                            }
                            case 101: {
                                this.formatTimeField(destination, ta /* !! */ , ChronoField.DAY_OF_MONTH, genFlags, width, 1);
                                break;
                            }
                            case 72: {
                                this.formatTimeField(destination, ta /* !! */ , ChronoField.HOUR_OF_DAY, genFlags, width, 2);
                                break;
                            }
                            case 73: {
                                this.formatTimeField(destination, ta /* !! */ , ChronoField.CLOCK_HOUR_OF_AMPM, genFlags, width, 2);
                                break;
                            }
                            case 106: {
                                this.formatTimeField(destination, ta /* !! */ , ChronoField.DAY_OF_YEAR, genFlags, width, 3);
                                break;
                            }
                            case 107: {
                                this.formatTimeField(destination, ta /* !! */ , ChronoField.HOUR_OF_DAY, genFlags, width, 1);
                                break;
                            }
                            case 76: {
                                this.formatTimeField(destination, ta /* !! */ , ChronoField.MILLI_OF_SECOND, genFlags, width, 3);
                                break;
                            }
                            case 108: {
                                this.formatTimeField(destination, ta /* !! */ , ChronoField.CLOCK_HOUR_OF_AMPM, genFlags, width, 1);
                                break;
                            }
                            case 77: {
                                this.formatTimeField(destination, ta /* !! */ , ChronoField.MINUTE_OF_HOUR, genFlags, width, 2);
                                break;
                            }
                            case 109: {
                                this.formatTimeField(destination, ta /* !! */ , ChronoField.MONTH_OF_YEAR, genFlags, width, 2);
                                break;
                            }
                            case 78: {
                                this.formatTimeField(destination, ta /* !! */ , ChronoField.NANO_OF_SECOND, genFlags, width, 9);
                                break;
                            }
                            case 81: {
                                this.formatTimeField(destination, ta /* !! */ , Printf.MILLIS_OF_INSTANT, genFlags, width, 1);
                                break;
                            }
                            case 83: {
                                this.formatTimeField(destination, ta /* !! */ , ChronoField.SECOND_OF_MINUTE, genFlags, width, 2);
                                break;
                            }
                            case 115: {
                                this.formatTimeField(destination, ta /* !! */ , ChronoField.INSTANT_SECONDS, genFlags, width, 2);
                                break;
                            }
                            case 89: {
                                this.formatTimeField(destination, ta /* !! */ , ChronoField.YEAR_OF_ERA, genFlags, width, 4);
                                break;
                            }
                            case 121: {
                                this.formatTimeField(destination, ta /* !! */ , Printf.YEAR_OF_CENTURY, genFlags, width, 2);
                                break;
                            }
                            case 90: {
                                this.formatTimeZoneId(destination, ta /* !! */ , genFlags, width);
                                break;
                            }
                            case 122: {
                                this.formatTimeZoneOffset(destination, ta /* !! */ , genFlags, width);
                                break;
                            }
                            case 99: {
                                b = new StringBuilder();
                                this.formatTimeTextField(b, ta /* !! */ , ChronoField.DAY_OF_WEEK, this.getDateFormatSymbols().getShortWeekdays(), genFlags, -1);
                                b.append(' ');
                                this.formatTimeTextField(b, ta /* !! */ , ChronoField.MONTH_OF_YEAR, this.getDateFormatSymbols().getShortMonths(), genFlags, -1);
                                b.append(' ');
                                this.formatTimeField(b, ta /* !! */ , ChronoField.DAY_OF_MONTH, genFlags, -1, 2);
                                b.append(' ');
                                this.formatTimeField(b, ta /* !! */ , ChronoField.HOUR_OF_DAY, genFlags, -1, 2);
                                b.append(':');
                                this.formatTimeField(b, ta /* !! */ , ChronoField.MINUTE_OF_HOUR, genFlags, -1, 2);
                                b.append(':');
                                this.formatTimeField(b, ta /* !! */ , ChronoField.SECOND_OF_MINUTE, genFlags, -1, 2);
                                b.append(' ');
                                this.formatTimeZoneId(b, ta /* !! */ , genFlags.with(GeneralFlag.UPPERCASE), width);
                                b.append(' ');
                                this.formatTimeField(b, ta /* !! */ , ChronoField.YEAR_OF_ERA, genFlags, -1, 4);
                                this.appendStr(destination, genFlags, width, -1, b.toString());
                                break;
                            }
                            case 68: {
                                b = new StringBuilder();
                                this.formatTimeField(b, ta /* !! */ , ChronoField.MONTH_OF_YEAR, genFlags, -1, 2);
                                b.append('/');
                                this.formatTimeField(b, ta /* !! */ , ChronoField.DAY_OF_MONTH, genFlags, -1, 2);
                                b.append('/');
                                this.formatTimeField(b, ta /* !! */ , Printf.YEAR_OF_CENTURY, genFlags, -1, 2);
                                this.appendStr(destination, genFlags, width, -1, b.toString());
                                break;
                            }
                            case 70: {
                                b = new StringBuilder();
                                this.formatTimeField(b, ta /* !! */ , ChronoField.YEAR_OF_ERA, genFlags, -1, 4);
                                b.append('-');
                                this.formatTimeField(b, ta /* !! */ , ChronoField.MONTH_OF_YEAR, genFlags, -1, 2);
                                b.append('-');
                                this.formatTimeField(b, ta /* !! */ , ChronoField.DAY_OF_MONTH, genFlags, -1, 2);
                                this.appendStr(destination, genFlags, width, -1, b.toString());
                                break;
                            }
                            case 82: {
                                b = new StringBuilder();
                                this.formatTimeField(b, ta /* !! */ , ChronoField.HOUR_OF_DAY, genFlags, -1, 2);
                                b.append(':');
                                this.formatTimeField(b, ta /* !! */ , ChronoField.MINUTE_OF_HOUR, genFlags, -1, 2);
                                b.append(':');
                                this.formatTimeField(b, ta /* !! */ , ChronoField.SECOND_OF_MINUTE, genFlags, -1, 2);
                                this.appendStr(destination, genFlags, width, -1, b.toString());
                                break;
                            }
                            case 114: {
                                b = new StringBuilder();
                                this.formatTimeField(b, ta /* !! */ , ChronoField.HOUR_OF_DAY, genFlags, -1, 2);
                                b.append(':');
                                this.formatTimeField(b, ta /* !! */ , ChronoField.MINUTE_OF_HOUR, genFlags, -1, 2);
                                b.append(':');
                                this.formatTimeField(b, ta /* !! */ , ChronoField.SECOND_OF_MINUTE, genFlags, -1, 2);
                                b.append(' ');
                                this.formatTimeTextField(b, ta /* !! */ , ChronoField.AMPM_OF_DAY, this.getDateFormatSymbols().getAmPmStrings(), genFlags.with(GeneralFlag.UPPERCASE), width);
                                this.appendStr(destination, genFlags, width, -1, b.toString());
                                break;
                            }
                            case 84: {
                                b = new StringBuilder();
                                this.formatTimeField(b, ta /* !! */ , ChronoField.HOUR_OF_DAY, genFlags, -1, 2);
                                b.append(':');
                                this.formatTimeField(b, ta /* !! */ , ChronoField.MINUTE_OF_HOUR, genFlags, -1, 2);
                                b.append(':');
                                this.formatTimeField(b, ta /* !! */ , ChronoField.SECOND_OF_MINUTE, genFlags, -1, 2);
                                this.appendStr(destination, genFlags, width, -1, b.toString());
                                break;
                            }
                            default: {
                                throw Printf.unknownFormat(format, i);
                            }
                        }
                        state = 0;
                    }
                    break block116;
                }
                if (state != 3) ** GOTO lbl-1000
                block42 : switch (cp) {
                    case 36: {
                        if (genFlags != GeneralFlags.NONE || numFlags != NumericFlags.NONE) {
                            throw Printf.unknownFormat(format, i);
                        }
                        argIdx = width;
                        width = -1;
                        state = 6;
                        break;
                    }
                    case 46: {
                        state = 4;
                        break;
                    }
                    default: lbl-1000:
                    // 3 sources

                    {
                        if (48 <= cp && cp <= 57) {
                            switch (state) {
                                case 1: 
                                case 6: {
                                    state = 3;
                                    width = cp - 48;
                                    break block42;
                                }
                                case 3: {
                                    width = Math.addExact(Math.multiplyExact(width, 10), cp - 48);
                                    break block42;
                                }
                                case 4: {
                                    state = 5;
                                    precision = cp - 48;
                                    break block42;
                                }
                                case 5: {
                                    precision = Math.addExact(Math.multiplyExact(precision, 10), cp - 48);
                                    break block42;
                                }
                            }
                            throw Assert.impossibleSwitchCase((int)state);
                        }
                        if (state == 4) {
                            throw Printf.unknownFormat(format, i);
                        }
                        if (cp != 110 && cp != 37) {
                            if (argIdx != -1) {
                                if (argIdx - 1 >= params.length) {
                                    throw new MissingFormatArgumentException(format.substring(start, cp == 116 || cp == 84 ? i + 2 : i + 1));
                                }
                                argVal = params[argIdx - 1];
                            } else {
                                if (crs >= params.length) {
                                    throw new MissingFormatArgumentException(format.substring(start, cp == 116 || cp == 84 ? i + 2 : i + 1));
                                }
                                argVal = params[crs++];
                                argIdx = crs;
                            }
                        }
                        switch (cp) {
                            case 37: {
                                genFlags.forbidAllBut(GeneralFlag.LEFT_JUSTIFY);
                                numFlags.forbidAll();
                                if (precision != -1 || state == 5) {
                                    throw Printf.precisionException(precision);
                                }
                                this.formatPercent(destination);
                                break;
                            }
                            case 65: 
                            case 97: {
                                throw Printf.unknownFormat(format, i);
                            }
                            case 66: 
                            case 98: {
                                numFlags.forbidAll();
                                genFlags.forbid(GeneralFlag.ALTERNATE);
                                if (Character.isUpperCase(cp)) {
                                    genFlags = genFlags.with(GeneralFlag.UPPERCASE);
                                }
                                if (argVal != null && !(argVal instanceof Boolean)) {
                                    throw new IllegalFormatConversionException((char)cp, argVal.getClass());
                                }
                                this.formatBoolean(destination, Printf.checkType(cp, argVal, Boolean.class, new Class[0]), genFlags, width, precision);
                                break;
                            }
                            case 67: 
                            case 99: {
                                numFlags.forbidAll();
                                genFlags.forbidAllBut(GeneralFlag.LEFT_JUSTIFY);
                                if (Character.isUpperCase(cp)) {
                                    genFlags = genFlags.with(GeneralFlag.UPPERCASE);
                                }
                                if (precision != -1 || state == 5) {
                                    throw Printf.precisionException(precision);
                                }
                                if (argVal == null) {
                                    this.appendStr(destination, genFlags, width, precision, "null");
                                    break;
                                }
                                if (argVal instanceof Character) {
                                    cpa = ((Character)argVal).charValue();
                                } else if (argVal instanceof Integer) {
                                    cpa = (Integer)argVal;
                                } else {
                                    throw new IllegalFormatConversionException((char)cp, argVal.getClass());
                                }
                                this.formatCharacter(destination, cpa, genFlags, width, precision);
                                break;
                            }
                            case 100: {
                                genFlags.forbid(GeneralFlag.ALTERNATE);
                                if (precision != -1 || state == 5) {
                                    throw Printf.precisionException(precision);
                                }
                                this.formatDecimalInteger(destination, Printf.checkType(cp, argVal, Number.class, new Class[]{Byte.class, Short.class, Integer.class, Long.class, BigInteger.class}), genFlags, numFlags, width);
                                break;
                            }
                            case 69: 
                            case 71: 
                            case 101: 
                            case 102: 
                            case 103: {
                                if (Character.isUpperCase(cp)) {
                                    genFlags = genFlags.with(GeneralFlag.UPPERCASE);
                                }
                                if (!(argVal == null || argVal instanceof Float || argVal instanceof Double || argVal instanceof BigDecimal)) {
                                    throw new IllegalFormatConversionException((char)cp, argVal.getClass());
                                }
                                item = Printf.checkType(cp, argVal, Number.class, new Class[]{Float.class, Double.class, BigDecimal.class});
                                if (cp == 101 || cp == 69) {
                                    this.formatFloatingPointSci(destination, item, genFlags, numFlags, width, precision);
                                    break;
                                }
                                if (cp == 102) {
                                    this.formatFloatingPointDecimal(destination, item, genFlags, numFlags, width, precision);
                                    break;
                                }
                                if (!Printf.$assertionsDisabled && cp != 103 && cp != 71) {
                                    throw new AssertionError();
                                }
                                this.formatFloatingPointGeneral(destination, item, genFlags, numFlags, width, precision);
                                break;
                            }
                            case 72: 
                            case 104: {
                                genFlags.forbid(GeneralFlag.ALTERNATE);
                                numFlags.forbidAll();
                                this.formatHashCode(destination, argVal, genFlags, width, precision);
                                break;
                            }
                            case 110: {
                                numFlags.forbidAll();
                                genFlags.forbidAll();
                                this.formatLineSeparator(destination);
                                break;
                            }
                            case 111: {
                                numFlags.forbidAllBut(NumericFlag.ZERO_PAD);
                                if (precision != -1 || state == 5) {
                                    throw Printf.precisionException(precision);
                                }
                                this.formatOctalInteger(destination, Printf.checkType(cp, argVal, Number.class, new Class[]{Byte.class, Short.class, Integer.class, Long.class, BigInteger.class}), genFlags, numFlags, width);
                                break;
                            }
                            case 83: 
                            case 115: {
                                numFlags.forbidAll();
                                if (Character.isUpperCase(cp)) {
                                    genFlags = genFlags.with(GeneralFlag.UPPERCASE);
                                }
                                if (argVal instanceof Formattable) {
                                    this.formatFormattableString(destination, (Formattable)argVal, genFlags, width, precision);
                                    break;
                                }
                                this.formatPlainString(destination, argVal, genFlags, width, precision);
                                break;
                            }
                            case 84: 
                            case 116: {
                                if (Character.isUpperCase(cp)) {
                                    genFlags = genFlags.with(GeneralFlag.UPPERCASE);
                                }
                                state = 2;
                                break block42;
                            }
                            case 88: 
                            case 120: {
                                numFlags.forbidAllBut(NumericFlag.ZERO_PAD);
                                if (Character.isUpperCase(cp)) {
                                    genFlags = genFlags.with(GeneralFlag.UPPERCASE);
                                }
                                if (precision != -1 || state == 5) {
                                    throw Printf.precisionException(precision);
                                }
                                this.formatHexInteger(destination, Printf.checkType(cp, argVal, Number.class, new Class[]{Byte.class, Short.class, Integer.class, Long.class, BigInteger.class}), genFlags, numFlags, width);
                                break;
                            }
                            default: {
                                throw Printf.unknownFormat(format, i);
                            }
                        }
                        state = 0;
                    }
                }
            }
            i = format.offsetByCodePoints(i, 1);
        }
        return destination;
    }

    protected static void appendSpaces(StringBuilder target, int cnt) {
        Printf.appendFiller(target, someSpaces, cnt);
    }

    protected static void appendZeros(StringBuilder target, int cnt) {
        Printf.appendFiller(target, someZeroes, cnt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DateFormatSymbols getDateFormatSymbols() {
        DateFormatSymbols dfs = this.dfs;
        if (dfs == null) {
            Printf printf = this;
            synchronized (printf) {
                dfs = this.dfs;
                if (dfs == null) {
                    this.dfs = dfs = DateFormatSymbols.getInstance(this.locale);
                }
            }
        }
        return dfs;
    }

    protected void formatTimeTextField(StringBuilder target, TemporalAccessor ta, TemporalField field, String[] symbols, GeneralFlags genFlags, int width) {
        int baseIdx = ta.get(field);
        int idx = field == ChronoField.MONTH_OF_YEAR ? baseIdx - 1 : (field == ChronoField.DAY_OF_WEEK ? (baseIdx + 1) % 7 : baseIdx);
        this.appendStr(target, genFlags, width, -1, symbols[idx]);
    }

    protected void formatTimeZoneId(StringBuilder target, TemporalAccessor ta, GeneralFlags genFlags, int width) {
        String output;
        boolean upper = genFlags.contains(GeneralFlag.UPPERCASE);
        ZoneId zoneId = ta.query(TemporalQueries.zone());
        if (zoneId == null) {
            throw new IllegalFormatConversionException(upper ? (char)'T' : 't', ta.getClass());
        }
        if (ta.isSupported(ChronoField.INSTANT_SECONDS)) {
            boolean dst = zoneId.getRules().isDaylightSavings(Instant.from(ta));
            output = TimeZone.getTimeZone(zoneId).getDisplayName(dst, 0, this.locale);
        } else {
            output = zoneId.getId();
        }
        this.appendStr(target, genFlags, width, -1, output);
    }

    protected void formatTimeZoneOffset(StringBuilder target, TemporalAccessor ta, GeneralFlags genFlags, int width) {
        int offset = ta.get(ChronoField.OFFSET_SECONDS);
        int absOffset = Math.abs(offset);
        int minutes = absOffset / 60 % 60;
        int hours = absOffset / 3600;
        boolean lj = genFlags.contains(GeneralFlag.LEFT_JUSTIFY);
        if (width > 5 && !lj) {
            Printf.appendSpaces(target, width - 5);
        }
        target.append(offset > 0 ? (char)'+' : '-');
        if (hours < 10) {
            target.append('0');
        }
        target.append(hours);
        if (minutes < 10) {
            target.append('0');
        }
        target.append(minutes);
        if (width > 5 && lj) {
            Printf.appendSpaces(target, width - 5);
        }
    }

    protected void formatTimeField(StringBuilder target, TemporalAccessor ta, TemporalField field, GeneralFlags genFlags, int width, int zeroPad) {
        long val = ta.getLong(field);
        String valStr = Long.toString(val);
        int length = valStr.length();
        int extLen = Math.max(zeroPad, length);
        boolean lj = genFlags.contains(GeneralFlag.LEFT_JUSTIFY);
        if (width > extLen && !lj) {
            Printf.appendSpaces(target, width - extLen);
        }
        if (zeroPad > length) {
            Printf.appendZeros(target, zeroPad - length);
        }
        target.append(valStr);
        if (width > extLen && lj) {
            Printf.appendSpaces(target, width - extLen);
        }
    }

    protected void formatPercent(StringBuilder target) {
        this.appendChar(target, GeneralFlags.NONE, 1, -1, '%');
    }

    protected void formatLineSeparator(StringBuilder target) {
        target.append(System.lineSeparator());
    }

    protected void formatFormattableString(StringBuilder target, Formattable formattable, GeneralFlags genFlags, int width, int precision) {
        int fmtFlags = 0;
        if (genFlags.contains(GeneralFlag.LEFT_JUSTIFY)) {
            fmtFlags |= 1;
        }
        if (genFlags.contains(GeneralFlag.UPPERCASE)) {
            fmtFlags |= 2;
        }
        if (genFlags.contains(GeneralFlag.ALTERNATE)) {
            fmtFlags |= 4;
        }
        formattable.formatTo(new Formatter(target), fmtFlags, width, precision);
    }

    protected void formatPlainString(StringBuilder target, Object item, GeneralFlags genFlags, int width, int precision) {
        this.appendStr(target, genFlags, width, precision, String.valueOf(item));
    }

    protected void formatBoolean(StringBuilder target, Object item, GeneralFlags genFlags, int width, int precision) {
        this.appendStr(target, genFlags, width, precision, item instanceof Boolean ? item.toString() : Boolean.toString(item != null));
    }

    protected void formatHashCode(StringBuilder target, Object item, GeneralFlags genFlags, int width, int precision) {
        this.appendStr(target, genFlags, width, precision, Integer.toHexString(Objects.hashCode(item)));
    }

    protected void formatCharacter(StringBuilder target, int codePoint, GeneralFlags genFlags, int width, int precision) {
        if (Character.isBmpCodePoint(codePoint)) {
            this.appendChar(target, genFlags, width, precision, (char)codePoint);
        } else {
            this.appendStr(target, genFlags, width, precision, new String(new int[]{codePoint}, 0, 1));
        }
    }

    protected void formatDecimalInteger(StringBuilder target, Number item, GeneralFlags genFlags, NumericFlags numFlags, int width) {
        if (item == null) {
            this.appendStr(target, genFlags, width, -1, "null");
        } else {
            DecimalFormat fmt = (DecimalFormat)NumberFormat.getIntegerInstance(this.locale);
            if (numFlags.contains(NumericFlag.SIGN)) {
                fmt.setPositivePrefix("+");
            } else if (numFlags.contains(NumericFlag.SPACE_POSITIVE)) {
                fmt.setPositivePrefix(" ");
            } else {
                fmt.setPositivePrefix("");
            }
            fmt.setPositiveSuffix("");
            if (numFlags.contains(NumericFlag.NEGATIVE_PARENTHESES)) {
                fmt.setNegativePrefix("(");
                fmt.setNegativeSuffix(")");
            } else {
                fmt.setNegativePrefix("-");
                fmt.setNegativeSuffix("");
            }
            fmt.setGroupingUsed(numFlags.contains(NumericFlag.LOCALE_GROUPING_SEPARATORS));
            if (numFlags.contains(NumericFlag.ZERO_PAD)) {
                fmt.setMinimumIntegerDigits(width);
            }
            fmt.setDecimalSeparatorAlwaysShown(genFlags.contains(GeneralFlag.ALTERNATE));
            this.appendStr(target, genFlags, width, -1, fmt.format(item));
        }
    }

    protected void formatOctalInteger(StringBuilder target, Number item, GeneralFlags genFlags, NumericFlags numFlags, int width) {
        if (item == null) {
            this.appendStr(target, genFlags, width, -1, "null");
        } else {
            boolean addRadix = genFlags.contains(GeneralFlag.ALTERNATE);
            int fillCount = Math.max(0, width - (Printf.bitLengthOf(item) + 2) / 3 - (addRadix ? 1 : 0));
            boolean lj = genFlags.contains(GeneralFlag.LEFT_JUSTIFY);
            if (numFlags.contains(NumericFlag.ZERO_PAD)) {
                if (addRadix) {
                    target.append('0');
                }
                Printf.appendZeros(target, fillCount);
            } else if (lj) {
                if (addRadix) {
                    target.append('0');
                }
            } else {
                Printf.appendSpaces(target, fillCount);
                if (addRadix) {
                    target.append('0');
                }
            }
            Printf.appendOctal(target, item);
            if (lj) {
                Printf.appendSpaces(target, fillCount);
            }
        }
    }

    protected void formatHexInteger(StringBuilder target, Number item, GeneralFlags genFlags, NumericFlags numFlags, int width) {
        if (item == null) {
            this.appendStr(target, genFlags, width, -1, "null");
        } else {
            boolean upper = genFlags.contains(GeneralFlag.UPPERCASE);
            boolean addRadix = genFlags.contains(GeneralFlag.ALTERNATE);
            int fillCount = Math.max(0, width - (Printf.bitLengthOf(item) + 3) / 4 - (addRadix ? 2 : 0));
            boolean lj = genFlags.contains(GeneralFlag.LEFT_JUSTIFY);
            if (numFlags.contains(NumericFlag.ZERO_PAD)) {
                if (addRadix) {
                    target.append(upper ? "0X" : "0x");
                }
                Printf.appendZeros(target, fillCount);
            } else if (lj) {
                if (addRadix) {
                    target.append(upper ? "0X" : "0x");
                }
            } else {
                Printf.appendSpaces(target, fillCount);
                if (addRadix) {
                    target.append(upper ? "0X" : "0x");
                }
            }
            Printf.appendHex(target, item, upper);
            if (lj) {
                Printf.appendSpaces(target, fillCount);
            }
        }
    }

    protected void formatFloatingPointSci(StringBuilder target, Number item, GeneralFlags genFlags, NumericFlags numFlags, int width, int precision) {
        if (item == null) {
            this.appendStr(target, genFlags, width, precision, "null");
        } else {
            boolean upper = genFlags.contains(GeneralFlag.UPPERCASE);
            DecimalFormatSymbols sym = DecimalFormatSymbols.getInstance(this.locale);
            if (this.negativeExp(item)) {
                sym.setExponentSeparator(upper ? "E" : "e");
            } else {
                sym.setExponentSeparator(upper ? "E+" : "e+");
            }
            this.formatDFP(target, item, genFlags, numFlags, width, precision == -1 ? 6 : (precision == 0 ? 1 : precision), true, sym, "0.#E00");
        }
    }

    protected void formatFloatingPointDecimal(StringBuilder target, Number item, GeneralFlags genFlags, NumericFlags numFlags, int width, int precision) {
        if (item == null) {
            this.appendStr(target, genFlags, width, precision, "null");
        } else {
            this.formatDFP(target, item, genFlags, numFlags, width, precision == 0 ? 1 : precision, false, DecimalFormatSymbols.getInstance(this.locale), "0.#");
        }
    }

    protected void formatFloatingPointGeneral(StringBuilder target, Number item, GeneralFlags genFlags, NumericFlags numFlags, int width, int precision) {
        if (item == null) {
            this.appendStr(target, genFlags, width, precision, "null");
        } else {
            boolean sci;
            if (item instanceof BigDecimal) {
                BigDecimal mag = ((BigDecimal)item).abs();
                sci = mag.compareTo(NEG_TEN_EM4) < 0 || mag.compareTo(BigDecimal.valueOf(10L, precision)) >= 0;
            } else if (item instanceof Float) {
                float fv = Math.abs(item.floatValue());
                sci = Float.isFinite(fv) && (fv < 0.001f || (double)fv >= Math.pow(10.0, precision));
            } else {
                assert (item instanceof Double);
                double dv = Math.abs(item.doubleValue());
                boolean bl = sci = Double.isFinite(dv) && (dv < (double)0.001f || dv >= Math.pow(10.0, precision));
            }
            if (sci) {
                this.formatFloatingPointSci(target, item, genFlags, numFlags, width, precision);
            } else {
                this.formatFloatingPointDecimal(target, item, genFlags, numFlags, width, precision);
            }
        }
    }

    private void formatDFP(StringBuilder target, Number item, GeneralFlags genFlags, NumericFlags numFlags, int width, int precision, boolean oneIntDigit, DecimalFormatSymbols sym, String s) {
        double dv;
        if (!(item instanceof BigDecimal) && !Double.isFinite(dv = item.doubleValue())) {
            this.appendStr(target, genFlags, width, -1, Double.toString(dv));
            return;
        }
        DecimalFormat fmt = new DecimalFormat(s, sym);
        if (numFlags.contains(NumericFlag.SIGN)) {
            fmt.setPositivePrefix("+");
        } else if (numFlags.contains(NumericFlag.SPACE_POSITIVE)) {
            fmt.setPositivePrefix(" ");
        } else {
            fmt.setPositivePrefix("");
        }
        fmt.setPositiveSuffix("");
        if (numFlags.contains(NumericFlag.NEGATIVE_PARENTHESES)) {
            fmt.setNegativePrefix("(");
            fmt.setNegativeSuffix(")");
        } else {
            fmt.setNegativePrefix("-");
            fmt.setNegativeSuffix("");
        }
        fmt.setGroupingUsed(numFlags.contains(NumericFlag.LOCALE_GROUPING_SEPARATORS));
        fmt.setMinimumFractionDigits(precision == -1 ? 1 : precision);
        fmt.setMaximumFractionDigits(precision == -1 ? Integer.MAX_VALUE : precision);
        fmt.setMinimumIntegerDigits(1);
        if (oneIntDigit) {
            fmt.setMaximumIntegerDigits(1);
        }
        fmt.setRoundingMode(RoundingMode.HALF_UP);
        AttributedCharacterIterator iterator = fmt.formatToCharacterIterator(item);
        int end = iterator.getEndIndex();
        boolean lj = genFlags.contains(GeneralFlag.LEFT_JUSTIFY);
        boolean zp = numFlags.contains(NumericFlag.ZERO_PAD);
        if (!lj && !zp && width > end) {
            Printf.appendSpaces(target, width - end);
        }
        while (iterator.getAttribute(NumberFormat.Field.SIGN) != null) {
            target.append(iterator.current());
            iterator.next();
        }
        assert (iterator.getAttribute(NumberFormat.Field.INTEGER) != null);
        if (zp && width > end) {
            Printf.appendZeros(target, width - end);
        }
        while (iterator.getIndex() < end) {
            target.append(iterator.current());
            iterator.next();
        }
        if (lj && width > end) {
            Printf.appendSpaces(target, width - end);
        }
    }

    private boolean negativeExp(Number item) {
        if (item instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)item;
            return bigDecimal.compareTo(BigDecimal.ONE) < 0 && bigDecimal.compareTo(NEG_ONE) > 0;
        }
        double val = item.doubleValue();
        return -1.0 < val && val < 1.0;
    }

    private static int bitLengthOf(Number item) {
        if (item instanceof Byte) {
            return 32 - Integer.numberOfLeadingZeros(item.byteValue() & 0xFF);
        }
        if (item instanceof Short) {
            return 32 - Integer.numberOfLeadingZeros(item.shortValue() & 0xFFFF);
        }
        if (item instanceof Integer) {
            return 32 - Integer.numberOfLeadingZeros(item.intValue());
        }
        if (item instanceof Long) {
            return 64 - Long.numberOfLeadingZeros(item.longValue());
        }
        assert (item instanceof BigInteger);
        return ((BigInteger)item).bitLength();
    }

    private static void appendOctal(StringBuilder target, Number item) {
        if (item instanceof Byte) {
            target.append(Integer.toOctalString(item.byteValue() & 0xFF));
        } else if (item instanceof Short) {
            target.append(Integer.toOctalString(item.shortValue() & 0xFFFF));
        } else if (item instanceof Integer) {
            target.append(Integer.toOctalString(item.shortValue()));
        } else if (item instanceof Long) {
            target.append(Long.toOctalString(item.longValue()));
        } else if (item instanceof BigInteger) {
            BigInteger bi = (BigInteger)item;
            int bl = bi.bitLength();
            if (bl <= 64) {
                target.append(Long.toOctalString(bi.longValue()));
            } else {
                int max = (bl + 2) / 3 * 3;
                for (int i = 0; i < max; i += 3) {
                    int val = 0;
                    if (bi.testBit(max - i)) {
                        val |= 4;
                    }
                    if (bi.testBit(max - i - 1)) {
                        val |= 2;
                    }
                    if (bi.testBit(max - i - 2)) {
                        val |= 1;
                    }
                    target.append(val);
                }
            }
        }
    }

    private static void appendHex(StringBuilder target, Number item, boolean upper) {
        if (item instanceof Byte) {
            String str = Integer.toHexString(item.byteValue() & 0xFF);
            target.append(upper ? str.toUpperCase() : str);
        } else if (item instanceof Short) {
            String str = Integer.toHexString(item.shortValue() & 0xFFFF);
            target.append(upper ? str.toUpperCase() : str);
        } else if (item instanceof Integer) {
            String str = Integer.toHexString(item.shortValue());
            target.append(upper ? str.toUpperCase() : str);
        } else if (item instanceof Long) {
            String str = Long.toHexString(item.longValue());
            target.append(upper ? str.toUpperCase() : str);
        } else if (item instanceof BigInteger) {
            BigInteger bi = (BigInteger)item;
            int bl = bi.bitLength();
            if (bl <= 64) {
                target.append(Long.toHexString(bi.longValue()));
            } else {
                int max = (bl + 3) / 4 * 4;
                for (int i = 0; i < max; i += 4) {
                    int val = 0;
                    if (bi.testBit(max - i)) {
                        val |= 8;
                    }
                    if (bi.testBit(max - i - 1)) {
                        val |= 4;
                    }
                    if (bi.testBit(max - i - 2)) {
                        val |= 2;
                    }
                    if (bi.testBit(max - i - 3)) {
                        val |= 1;
                    }
                    if (val > 9) {
                        val += upper ? 65 : 87;
                    }
                    target.append((char)(val > 9 ? val - 10 + (upper ? 65 : 97) : val + 48));
                }
            }
        }
    }

    private void appendChar(StringBuilder target, GeneralFlags genFlags, int width, int precision, char c) {
        if (genFlags.contains(GeneralFlag.UPPERCASE) && Character.isLowerCase(c)) {
            this.appendStr(target, genFlags, width, precision, Character.toString(c));
        } else if (width <= 1) {
            target.append(c);
        } else if (genFlags.contains(GeneralFlag.LEFT_JUSTIFY)) {
            target.append(c);
            Printf.appendSpaces(target, width - 1);
        } else {
            Printf.appendSpaces(target, width - 1);
            target.append(c);
        }
    }

    private void appendStr(StringBuilder target, GeneralFlags genFlags, int width, int precision, String itemStr) {
        String str;
        String string = str = genFlags.contains(GeneralFlag.UPPERCASE) ? itemStr.toUpperCase(this.locale) : itemStr;
        if (width == -1 && precision == -1) {
            target.append(str);
        } else {
            int length = str.codePointCount(0, str.length());
            if (precision != -1 && precision < length) {
                str = str.substring(0, precision);
            }
            if (width != -1 && length < width) {
                if (genFlags.contains(GeneralFlag.LEFT_JUSTIFY)) {
                    target.append(str);
                    Printf.appendSpaces(target, width - length);
                } else {
                    Printf.appendSpaces(target, width - length);
                    target.append(str);
                }
            } else {
                target.append(str);
            }
        }
    }

    @SafeVarargs
    private static <T> T checkType(int convCp, Object arg, Class<T> commonType, Class<? extends T> ... allowedSubTypes) {
        if (arg == null) {
            return null;
        }
        if (commonType.isInstance(arg)) {
            if (allowedSubTypes.length == 0) {
                return commonType.cast(arg);
            }
            for (Class<T> clazz : allowedSubTypes) {
                if (!clazz.isInstance(arg)) continue;
                return commonType.cast(arg);
            }
        }
        throw new IllegalFormatConversionException((char)convCp, arg.getClass());
    }

    private static void appendFiller(StringBuilder target, String filler, int cnt) {
        while (cnt > 32) {
            target.append(filler);
            cnt -= 32;
        }
        target.append(filler, 0, cnt);
    }

    private static IllegalFormatPrecisionException precisionException(int prec) {
        return new IllegalFormatPrecisionException(prec);
    }

    private static UnknownFormatConversionException unknownFormat(String format, int i) {
        return Printf.unknownFormat(format.substring(i, format.offsetByCodePoints(i, 1)));
    }

    private static UnknownFormatConversionException unknownFormat(String arg) {
        return new UnknownFormatConversionException(arg);
    }
}

