/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.util.Objects;
import org.jboss.logging.Logger;
import org.keycloak.representations.idm.OAuth2ErrorRepresentation;
import org.keycloak.services.util.ObjectMapperResolver;

public class RejectNonNormalizedPathFilter
implements Handler<RoutingContext> {
    private static final Logger LOGGER = Logger.getLogger(RejectNonNormalizedPathFilter.class);
    private final ObjectMapper MAPPER = ObjectMapperResolver.createStreamSerializer();

    public void handle(RoutingContext routingContext) {
        if (!Objects.equals(routingContext.request().path(), routingContext.normalizedPath())) {
            String jsonString;
            LOGGER.debugf("Request with a non-normalized path blocked: %s vs. %s", (Object)routingContext.request().path(), (Object)routingContext.normalizedPath());
            OAuth2ErrorRepresentation error = new OAuth2ErrorRepresentation("missingNormalization", "Request path not normalized");
            routingContext.response().headers().add("Content-Type", "application/json; charset=UTF-8");
            try {
                jsonString = this.MAPPER.writeValueAsString((Object)error);
            }
            catch (JsonProcessingException e) {
                jsonString = "";
            }
            routingContext.response().setStatusCode(400).end(jsonString);
        } else {
            routingContext.next();
        }
    }
}

