/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.internal.dynamic;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.hibernate.AssertionFailure;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EntityAssociationMapping;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.metamodel.mapping.internal.EmbeddedAttributeMapping;
import org.hibernate.metamodel.mapping.internal.EntityCollectionPart;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.results.FetchBuilder;
import org.hibernate.query.results.LegacyFetchBuilder;
import org.hibernate.query.results.internal.DomainResultCreationStateImpl;
import org.hibernate.query.results.internal.ResultsHelper;
import org.hibernate.query.results.internal.dynamic.DynamicFetchBuilder;
import org.hibernate.query.results.internal.dynamic.DynamicFetchBuilderContainer;
import org.hibernate.query.results.internal.dynamic.DynamicFetchBuilderStandard;
import org.hibernate.query.results.internal.dynamic.DynamicResultBuilderEntityStandard;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.SqlAliasBaseConstant;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupJoinProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class DynamicFetchBuilderLegacy
implements LegacyFetchBuilder,
DynamicFetchBuilder,
NativeQuery.FetchReturn,
NativeQuery.ReturnableResultNode,
DynamicFetchBuilderContainer {
    private static final String ELEMENT_PREFIX = "element.";
    private static final int ELEMENT_PREFIX_LENGTH = 8;
    private final String tableAlias;
    private final String ownerTableAlias;
    private final Fetchable fetchable;
    private final List<String> columnNames;
    private final Map<Fetchable, FetchBuilder> fetchBuilderMap;
    private final DynamicResultBuilderEntityStandard resultBuilderEntity;
    private LockMode lockMode;

    public DynamicFetchBuilderLegacy(String tableAlias, String ownerTableAlias, Fetchable fetchable, List<String> columnNames, Map<Fetchable, FetchBuilder> fetchBuilderMap) {
        this(tableAlias, ownerTableAlias, fetchable, columnNames, fetchBuilderMap, null);
    }

    public DynamicFetchBuilderLegacy(String tableAlias, String ownerTableAlias, Fetchable fetchable, List<String> columnNames, Map<Fetchable, FetchBuilder> fetchBuilderMap, DynamicResultBuilderEntityStandard resultBuilderEntity) {
        this.tableAlias = tableAlias;
        this.ownerTableAlias = ownerTableAlias;
        this.fetchable = fetchable;
        this.columnNames = columnNames;
        this.fetchBuilderMap = fetchBuilderMap;
        this.resultBuilderEntity = resultBuilderEntity;
    }

    @Override
    public String getTableAlias() {
        return this.tableAlias;
    }

    @Override
    public String getOwnerAlias() {
        return this.ownerTableAlias;
    }

    @Override
    public Fetchable getFetchable() {
        return this.fetchable;
    }

    @Override
    public String getFetchableName() {
        return this.fetchable.getFetchableName();
    }

    @Override
    public NativeQuery.FetchReturn setLockMode(LockMode lockMode) {
        this.lockMode = lockMode;
        return this;
    }

    @Override
    public NativeQuery.FetchReturn addProperty(String propertyName, String columnAlias) {
        this.addProperty(this.resolveFetchable(propertyName), columnAlias);
        return this;
    }

    private Fetchable resolveFetchable(String propertyName) {
        Fetchable fetchable = this.fetchable;
        if (fetchable instanceof EntityAssociationMapping) {
            EntityAssociationMapping attributeMapping = (EntityAssociationMapping)fetchable;
            return (Fetchable)attributeMapping.findByPath(propertyName);
        }
        fetchable = this.fetchable;
        if (fetchable instanceof PluralAttributeMapping) {
            PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)fetchable;
            if (propertyName.equals("key")) {
                return pluralAttributeMapping.getIndexDescriptor();
            }
            if (propertyName.equals("element")) {
                return pluralAttributeMapping.getElementDescriptor().getCollectionAttribute();
            }
            CollectionPart elementDescriptor = pluralAttributeMapping.getElementDescriptor();
            if (elementDescriptor instanceof EntityCollectionPart) {
                EntityCollectionPart entityCollectionPart = (EntityCollectionPart)elementDescriptor;
                if (propertyName.startsWith(ELEMENT_PREFIX)) {
                    propertyName = propertyName.substring(8);
                }
                return (Fetchable)entityCollectionPart.getEntityMappingType().findByPath(propertyName);
            }
        }
        throw new UnsupportedOperationException("Unsupported fetchable type: " + this.fetchable.getClass().getName());
    }

    @Override
    public NativeQuery.ReturnProperty addProperty(String propertyName) {
        return this.addProperty(this.resolveFetchable(propertyName));
    }

    @Override
    public DynamicFetchBuilderLegacy cacheKeyInstance() {
        return new DynamicFetchBuilderLegacy(this.tableAlias, this.ownerTableAlias, this.fetchable, this.columnNames == null ? null : List.copyOf(this.columnNames), this.fetchBuilderMap(), this.resultBuilderEntity == null ? null : this.resultBuilderEntity.cacheKeyInstance());
    }

    private Map<Fetchable, FetchBuilder> fetchBuilderMap() {
        if (this.fetchBuilderMap == null) {
            return null;
        }
        HashMap<Fetchable, FetchBuilder> fetchBuilderMap = new HashMap<Fetchable, FetchBuilder>(this.fetchBuilderMap.size());
        for (Map.Entry<Fetchable, FetchBuilder> entry : this.fetchBuilderMap.entrySet()) {
            fetchBuilderMap.put(entry.getKey(), entry.getValue().cacheKeyInstance());
        }
        return fetchBuilderMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Fetch buildFetch(FetchParent parent, NavigablePath fetchPath, JdbcValuesMetadata jdbcResultsMetadata, DomainResultCreationState domainResultCreationState) {
        DomainResultCreationStateImpl creationState = ResultsHelper.impl(domainResultCreationState);
        TableGroup ownerTableGroup = creationState.getFromClauseAccess().findByAlias(this.ownerTableAlias);
        TableGroup tableGroup = this.tableGroup(fetchPath, ownerTableGroup, creationState);
        if (this.lockMode != null) {
            domainResultCreationState.getSqlAstCreationState().registerLockMode(this.tableAlias, this.lockMode);
        }
        if (this.columnNames != null) {
            Fetchable fetchable2 = this.fetchable;
            if (fetchable2 instanceof EmbeddedAttributeMapping) {
                EmbeddedAttributeMapping embeddedAttributeMapping = (EmbeddedAttributeMapping)fetchable2;
                embeddedAttributeMapping.forEachSelectable((selectionIndex, selectableMapping) -> this.resolveSqlSelection(this.columnNames.get(selectionIndex), tableGroup.resolveTableReference(fetchPath, (ValuedModelPart)((Object)selectableMapping), selectableMapping.getContainingTableExpression()), selectableMapping, jdbcResultsMetadata, domainResultCreationState));
            } else {
                ForeignKeyDescriptor keyDescriptor = DynamicFetchBuilderLegacy.getForeignKeyDescriptor(this.fetchable);
                if (!this.columnNames.isEmpty()) {
                    keyDescriptor.forEachSelectable((selectionIndex, selectableMapping) -> this.resolveSqlSelection(this.columnNames.get(selectionIndex), tableGroup.resolveTableReference(fetchPath, keyDescriptor.getKeyPart(), selectableMapping.getContainingTableExpression()), selectableMapping, jdbcResultsMetadata, domainResultCreationState));
                }
            }
            if (this.resultBuilderEntity != null) {
                return this.resultBuilderEntity.buildFetch(parent, this.fetchable, jdbcResultsMetadata, creationState);
            }
        }
        try {
            creationState.pushExplicitFetchMementoResolver(fetchable -> {
                if (fetchable != null) {
                    return this.findFetchBuilder((Fetchable)fetchable);
                }
                return null;
            });
            Fetch fetch = parent.generateFetchableFetch(this.fetchable, parent.resolveNavigablePath(this.fetchable), FetchTiming.IMMEDIATE, true, null, domainResultCreationState);
            return fetch;
        }
        finally {
            creationState.popExplicitFetchMementoResolver();
        }
    }

    private TableGroup tableGroup(NavigablePath fetchPath, TableGroup ownerTableGroup, DomainResultCreationStateImpl creationState) {
        Fetchable fetchable = this.fetchable;
        if (fetchable instanceof TableGroupJoinProducer) {
            TableGroupJoinProducer tableGroupJoinProducer = (TableGroupJoinProducer)((Object)fetchable);
            TableGroupJoin tableGroupJoin = tableGroupJoinProducer.createTableGroupJoin(fetchPath, ownerTableGroup, this.tableAlias, new SqlAliasBaseConstant(this.tableAlias), SqlAstJoinType.INNER, true, false, creationState);
            ownerTableGroup.addTableGroupJoin(tableGroupJoin);
            TableGroup tableGroup = tableGroupJoin.getJoinedGroup();
            creationState.getFromClauseAccess().registerTableGroup(fetchPath, tableGroup);
            return tableGroup;
        }
        return ownerTableGroup;
    }

    private static ForeignKeyDescriptor getForeignKeyDescriptor(Fetchable fetchable) {
        if (fetchable instanceof PluralAttributeMapping) {
            PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)fetchable;
            return pluralAttributeMapping.getKeyDescriptor();
        }
        if (fetchable instanceof ToOneAttributeMapping) {
            ToOneAttributeMapping toOneAttributeMapping = (ToOneAttributeMapping)fetchable;
            return toOneAttributeMapping.getForeignKeyDescriptor();
        }
        throw new AssertionFailure("Unrecognized AttributeMapping");
    }

    @Override
    public void visitFetchBuilders(BiConsumer<Fetchable, FetchBuilder> consumer) {
        this.fetchBuilderMap.forEach(consumer);
    }

    private void resolveSqlSelection(String columnAlias, TableReference tableReference, SelectableMapping selectableMapping, JdbcValuesMetadata jdbcResultsMetadata, DomainResultCreationState domainResultCreationState) {
        DomainResultCreationStateImpl creationStateImpl = ResultsHelper.impl(domainResultCreationState);
        creationStateImpl.resolveSqlSelection(ResultsHelper.resolveSqlExpression(creationStateImpl, jdbcResultsMetadata, tableReference, selectableMapping, columnAlias), selectableMapping.getJdbcMapping().getJdbcJavaType(), null, domainResultCreationState.getSqlAstCreationState().getCreationContext().getTypeConfiguration());
    }

    @Override
    public NativeQuery.ReturnProperty addColumnAlias(String columnAlias) {
        this.columnNames.add(columnAlias);
        return this;
    }

    @Override
    public List<String> getColumnAliases() {
        return this.columnNames;
    }

    @Override
    public DynamicFetchBuilder addProperty(Fetchable fetchable) {
        DynamicFetchBuilderStandard fetchBuilder = new DynamicFetchBuilderStandard(fetchable);
        this.fetchBuilderMap.put(fetchable, fetchBuilder);
        return fetchBuilder;
    }

    @Override
    public FetchBuilder findFetchBuilder(Fetchable fetchable) {
        return this.fetchBuilderMap.get(fetchable);
    }

    @Override
    public DynamicFetchBuilderContainer addProperty(Fetchable fetchable, String columnAlias) {
        DynamicFetchBuilder fetchBuilder = this.addProperty(fetchable);
        fetchBuilder.addColumnAlias(columnAlias);
        return this;
    }

    @Override
    public DynamicFetchBuilderContainer addProperty(Fetchable fetchable, String ... columnAliases) {
        DynamicFetchBuilder fetchBuilder = this.addProperty(fetchable);
        for (String columnAlias : columnAliases) {
            fetchBuilder.addColumnAlias(columnAlias);
        }
        return this;
    }

    @Override
    public void addFetchBuilder(Fetchable fetchable, FetchBuilder fetchBuilder) {
        this.fetchBuilderMap.put(fetchable, fetchBuilder);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicFetchBuilderLegacy that = (DynamicFetchBuilderLegacy)o;
        return this.tableAlias.equals(that.tableAlias) && this.ownerTableAlias.equals(that.ownerTableAlias) && this.fetchable.equals(that.fetchable) && this.lockMode.equals((Object)that.lockMode) && Objects.equals(this.columnNames, that.columnNames) && Objects.equals(this.fetchBuilderMap, that.fetchBuilderMap) && Objects.equals(this.resultBuilderEntity, that.resultBuilderEntity);
    }

    public int hashCode() {
        int result = this.tableAlias.hashCode();
        result = 31 * result + this.ownerTableAlias.hashCode();
        result = 31 * result + this.fetchable.hashCode();
        result = 31 * result + this.lockMode.hashCode();
        result = 31 * result + (this.columnNames != null ? this.columnNames.hashCode() : 0);
        result = 31 * result + (this.fetchBuilderMap != null ? this.fetchBuilderMap.hashCode() : 0);
        result = 31 * result + (this.resultBuilderEntity != null ? this.resultBuilderEntity.hashCode() : 0);
        return result;
    }
}

