/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import jakarta.transaction.Synchronization;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.HibernateException;
import org.hibernate.Internal;
import org.hibernate.JDBCException;
import org.hibernate.LockMode;
import org.hibernate.cache.CacheException;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.type.SerializationException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@Internal
@MessageLogger(projectCode="HHH")
@ValidIdRange(min=2, max=20000)
public interface CoreMessageLogger
extends BasicLogger {
    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Already session bound on call to bind(); make sure you clean up your sessions", id=2)
    public void alreadySessionBound();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Configuration settings with for connection provider '%s' are set, but the connection provider is not on the classpath; these properties will be ignored", id=22)
    public void providerClassNotFound(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="I/O reported cached file could not be found: [%s]: %s", id=23)
    public void cachedFileNotFound(String var1, FileNotFoundException var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Second-level cache region factory [%s]", id=25)
    public void regionFactory(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Second-level cache disabled", id=26)
    public void noRegionFactory();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Instantiating factory [%s] with settings: %s", id=30)
    public void instantiatingFactory(String var1, Map<String, Object> var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Closing factory [%s]", id=31)
    public void closingFactory(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Serializing factory [%s]", id=32)
    public void serializingFactory(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Deserialized factory [%s]", id=33)
    public void deserializedFactory(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Composite id class does not override equals(): %s", id=38)
    public void compositeIdClassDoesNotOverrideEquals(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Composite id class does not override hashCode(): %s", id=39)
    public void compositeIdClassDoesNotOverrideHashCode(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Ignoring bag join fetch [%s] due to prior collection join fetch", id=51)
    public void containsJoinFetchedCollection(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Defining %s=true ignored in HEM", id=59)
    public void definingFlushBeforeCompletionIgnoredInHem(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="DEPRECATED: use [%s] instead with custom [%s] implementation", id=65)
    public void deprecatedUuidGenerator(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Duplicate generator name %s", id=69)
    public void duplicateGeneratorName(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="entity listener duplication, first event definition will be used: %s", id=73)
    public void duplicateListener(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Found more than one <persistence-unit-metadata>, subsequent ignored", id=74)
    public void duplicateMetadata();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Entity [%s] is abstract-class/interface explicitly mapped as non-abstract; be sure to supply entity-names", id=84)
    public void entityMappedAsNonAbstract(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Exception in interceptor afterTransactionCompletion()", id=87)
    public void exceptionInAfterTransactionCompletionInterceptor(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Exception in interceptor beforeTransactionCompletion()", id=88)
    public void exceptionInBeforeTransactionCompletionInterceptor(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Sub-resolver threw unexpected exception, continuing to next: %s", id=89)
    public void exceptionInSubResolver(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Expected type: %s, actual value: %s", id=91)
    public void expectedType(String var1, @Nullable String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="an assertion failure occurred (this may indicate a bug in Hibernate, but is more likely due to unsafe use of the session): %s", id=99)
    public void failed(Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="GUID identifier generated: %s", id=113)
    public void guidGenerated(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Handling transient entity in delete processing", id=114)
    public void handlingTransientEntity();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="HQL: %s, time: %sms, rows: %s", id=117)
    public void hql(String var1, Long var2, Long var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="HSQLDB supports only READ_UNCOMMITTED isolation", id=118)
    public void hsqldbSupportsOnlyReadCommittedIsolation();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Ignoring unique constraints specified on table generator [%s]", id=120)
    public void ignoringTableGeneratorConstraints(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="IllegalArgumentException in class: %s, getter method of property: %s", id=122)
    public void illegalPropertyGetterArgument(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="IllegalArgumentException in class: %s, setter method of property: %s", id=123)
    public void illegalPropertySetterArgument(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Instantiating explicit connection provider: %s", id=130)
    public void instantiatingExplicitConnectionProvider(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Array element type error\n%s", id=132)
    public void invalidArrayElementType(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="java.sql.Types mapped the same code [%s] multiple times; was [%s]; now [%s]", id=141)
    public void JavaSqlTypesMappedSameCodeMultipleTimes(int var1, String var2, String var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Lazy property fetching available for: %s", id=157)
    public void lazyPropertyFetchingAvailable(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Function template anticipated %s arguments, but %s arguments encountered", id=174)
    public void missingArguments(int var1, int var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Narrowing proxy to %s - this operation breaks ==", id=179)
    public void narrowingProxy(Class<?> var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="No appropriate connection provider encountered, assuming application will be supplying connections", id=181)
    public void noAppropriateConnectionProvider();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="No default (no-argument) constructor for class [%s] (class must be instantiated by Interceptor)", id=182)
    public void noDefaultConstructor(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Overriding %s is dangerous, this might break the EJB3 specification implementation", id=193)
    public void overridingTransactionStrategyDangerous(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Package not found or no package-info.java: %s", id=194)
    public void packageNotFound(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="LinkageError while attempting to load package: %s", id=195)
    public void linkageError(String var1, @Cause LinkageError var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Pooled optimizer source reported [%s] as the initial value; use of 1 or greater highly recommended", id=201)
    public void pooledOptimizerReportedInitialValue(IntegralDataTypeHolder var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Processing PersistenceUnitInfo [name: %s]", id=204)
    public void processingPersistenceUnitInfoName(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Loaded properties from resource hibernate.properties: %s", id=205)
    public void propertiesLoaded(Properties var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="'hibernate.properties' not found", id=206)
    public void propertiesNotFound();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Reading mappings from cache file: %s", id=219)
    public void readingCachedMappings(File var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Reading mappings from file: %s", id=220)
    public void readingMappingsFromFile(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Recognized obsolete hibernate namespace %s. Use namespace %s instead. Refer to Hibernate 3.6 Migration Guide", id=223)
    public void recognizedObsoleteHibernateNamespace(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Running hbm2ddl schema export", id=227)
    public void runningHbm2ddlSchemaExport();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Running hbm2ddl schema update", id=228)
    public void runningHbm2ddlSchemaUpdate();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Running schema validator", id=229)
    public void runningSchemaValidator();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Start time: %s", id=251)
    public void startTime(long var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Synchronization [%s] was already registered", id=259)
    public void synchronizationAlreadyRegistered(Synchronization var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Exception calling user Synchronization [%s]: %s", id=260)
    public void synchronizationFailed(Synchronization var1, Throwable var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Table not found: %s", id=262)
    public void tableNotFound(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="More than one table found: %s", id=263)
    public void multipleTablesFound(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Transactions: %s", id=266)
    public void transactions(long var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Type [%s] defined no registration keys; ignoring", id=269)
    public void typeDefinedNoRegistrationKeys(Object var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Error accessing type info result set: %s", id=273)
    public void unableToAccessTypeInfoResultSet(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to apply constraints on DDL for %s", id=274)
    public void unableToApplyConstraints(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to cleanup temporary id table after use [%s]", id=283)
    public void unableToCleanupTemporaryIdTable(Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Error closing InitialContext [%s]", id=285)
    public void unableToCloseInitialContext(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not close input stream", id=287)
    public void unableToCloseInputStream(@Cause IOException var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="IOException occurred closing output stream", id=292)
    public void unableToCloseOutputStream(@Cause IOException var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="IOException occurred closing stream", id=296)
    public void unableToCloseStream(@Cause IOException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Could not close stream on hibernate.properties: %s", id=297)
    public void unableToCloseStreamError(IOException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unable to construct current session context [%s]", id=302)
    public void unableToConstructCurrentSessionContext(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to close temporary session used to load lazy collection associated to no session", id=303)
    public void unableToCloseTemporarySession();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not copy system properties, system properties will be ignored", id=304)
    public void unableToCopySystemProperties();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not create proxy factory for:%s", id=305)
    public void unableToCreateProxyFactory(String var1, @Cause HibernateException var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error creating schema ", id=306)
    public void unableToCreateSchema(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not deserialize cache file [%s]: %s", id=307)
    public void unableToDeserializeCache(String var1, SerializationException var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Could not find any META-INF/persistence.xml file in the classpath", id=318)
    public void unableToFindPersistenceXmlInClasspath();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to interpret specified optimizer [%s], falling back to noop", id=321)
    public void unableToLocateCustomOptimizerClass(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to instantiate specified optimizer [%s], falling back to noop", id=322)
    public void unableToInstantiateOptimizer(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to instantiate UUID generation strategy class: %s", id=325)
    public void unableToInstantiateUuidGenerationStrategy(Exception var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Error performing load command", id=327)
    public void unableToLoadCommand(@Cause HibernateException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Problem loading properties from hibernate.properties", id=329)
    public void unableToLoadProperties();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to locate requested UUID generation strategy class: %s", id=334)
    public void unableToLocateUuidGenerationStrategy(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to log SQLWarnings: %s", id=335)
    public void unableToLogSqlWarnings(SQLException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unable to mark for rollback on PersistenceException: ", id=337)
    public void unableToMarkForRollbackOnPersistenceException(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unable to mark for rollback on TransientObjectException: ", id=338)
    public void unableToMarkForRollbackOnTransientObjectException(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not obtain connection metadata: %s", id=339)
    public void unableToObtainConnectionMetadata(SQLException var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not obtain connection to query JDBC database metadata", id=342)
    public void unableToObtainConnectionToQueryMetadata(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Could not release a cache lock: %s", id=353)
    public void unableToReleaseCacheLock(CacheException var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to release type info result set", id=357)
    public void unableToReleaseTypeInfoResultSet();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to erase previously added bag join fetch", id=358)
    public void unableToRemoveBagJoinFetch();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to retrieve type info result set: %s", id=362)
    public void unableToRetrieveTypeInfoResultSet(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error running schema update", id=366)
    public void unableToRunSchemaUpdate(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="I/O reported error writing cached file: %s: %s", id=378)
    public void unableToWriteCachedFile(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The %s.%s.%s version of H2 implements temporary table creation such that it commits current transaction; multi-table, bulk HQL/JPQL will not work properly", id=393)
    public void unsupportedMultiTableBulkHqlJpaql(int var1, int var2, int var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Don't use old DTDs, read the Hibernate 3.x Migration Guide", id=404)
    public void usingOldDtd();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Using %s which does not generate IETF RFC 4122 compliant UUID values; consider using %s instead", id=409)
    public void usingUuidHexGenerator(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Hibernate ORM core version %s", id=412)
    public void version(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Warnings creating temp table: %s", id=413)
    public void warningsCreatingTempTable(SQLWarning var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Write locks via update not supported for non-versioned entities [%s]", id=416)
    public void writeLocksNotSupported(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=437, value="Attempting to save one or more entities that have a non-nullable association with an unsaved transient entity.\nThe unsaved transient entity must be saved in an operation prior to saving these dependent entities.\n\tUnsaved transient entity: %s\n\tDependent entities: %s\n\tNon-nullable associations: %s")
    public void cannotResolveNonNullableTransientDependencies(String var1, Set<String> var2, Set<String> var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Dialect [%s] limits the number of elements in an IN predicate to %s entries.  However, the given parameter list [%s] contained %s entries, which will likely cause failures to execute the query in the database", id=443)
    public void tooManyInExpressions(String var1, int var2, String var3, int var4);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Encountered request for locking however dialect reports that database prefers locking be done in a separate select (follow-on locking); results will be locked after initial query executes", id=444)
    public void usingFollowOnLocking();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Alias-specific lock modes requested, which is not currently supported with follow-on locking; all acquired locks will be [%s]", id=445)
    public void aliasSpecificLockingWithFollowOnLocking(LockMode var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Explicit use of UPGRADE_SKIPLOCKED in lock() calls is not recommended; use normal UPGRADE locking instead", id=447)
    public void explicitSkipLockedLockCombo();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="'jakarta.persistence.validation.mode' named multiple values: %s", id=448)
    public void multipleValidationModes(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=449, value="@Convert annotation applied to Map attribute [%s] did not explicitly specify 'attributeName' using 'key'/'value' as required by spec; attempting to DoTheRightThing")
    public void nonCompliantMapConversion(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Creating pooled optimizer (lo) with [incrementSize=%s; returnClass=%s]", id=467)
    public void creatingPooledLoOptimizer(int var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="An unexpected session is defined for a collection, but the collection is not connected to that session. A persistent collection may only be associated with one session at a time. Overwriting session. %s", id=470)
    public void logUnexpectedSessionInCollectionNotConnected(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Cannot unset session in a collection because an unexpected session is defined. A persistent collection may only be associated with one session at a time. %s", id=471)
    public void logCannotUnsetUnexpectedSessionInCollection(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Omitting cached file [%s] as the mapping file is newer", id=473)
    public void cachedFileObsolete(File var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Cannot locate column information using identifier [%s]; ignoring index [%s]", id=475)
    public void logCannotLocateIndexColumnInformation(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Executing script [%s]", id=476)
    public void executingScript(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Starting delayed evictData of schema as part of SessionFactory shut-down'", id=477)
    public void startingDelayedSchemaDrop();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unsuccessful: %s", id=478)
    public void unsuccessfulSchemaManagementCommand(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="A ManagedEntity was associated with a stale PersistenceContext. A ManagedEntity may only be associated with one PersistenceContext at a time; %s", id=480)
    public void stalePersistenceContextInEntityEntry(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Illegally attempted to associate a proxy for entity [%s] with id [%s] with two open sessions.", id=485)
    public void attemptToAssociateProxyWithTwoOpenSessions(String var1, Object var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The query [%s] updates an immutable entity: %s", id=487)
    public void immutableEntityUpdateQuery(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="The query [%s] updates an immutable entity: %s", id=488)
    public void immutableEntityUpdateQueryAllowed(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="No JTA platform available (set 'hibernate.transaction.jta.platform' to enable JTA platform integration)", id=489)
    public void noJtaPlatform();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Using JTA platform [%s]", id=490)
    public void usingJtaPlatform(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="'%1$s.%2$s' uses both @NotFound and FetchType.LAZY. @ManyToOne and @OneToOne associations mapped with @NotFound are forced to EAGER fetching.", id=491)
    public void ignoreNotFoundWithFetchTypeLazy(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Attempt to merge an uninitialized collection with queued operations; queued operations will be ignored: %s", id=494)
    public void ignoreQueuedOperationsOnMerge(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Attaching an uninitialized collection with queued operations to a session: %s", id=495)
    public void queuedOperationWhenAttachToSession(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Detaching an uninitialized collection with queued operations from a session: %s", id=496)
    public void queuedOperationWhenDetachFromSession(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Detaching an uninitialized collection with queued operations from a session due to rollback: %s", id=498)
    public void queuedOperationWhenDetachFromSessionOnRollback(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The [%s] property of the [%s] entity was modified, but it won't be updated because the property is immutable.", id=502)
    public void ignoreImmutablePropertyModification(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Multiple configuration properties defined to create schema. Choose at most one among 'jakarta.persistence.create-database-schemas' or 'hibernate.hbm2ddl.create_namespaces'.", id=504)
    public void multipleSchemaCreationSettingsDefined();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Detaching an uninitialized collection with enabled filters from a session: %s", id=506)
    public void enabledFiltersWhenDetachFromSession(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Multi-table insert is not available due to missing identity and window function support for: %s", id=509)
    public void multiTableInsertNotAvailable(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Association with '@Fetch(JOIN)' and 'fetch=FetchType.LAZY' found. This is interpreted as lazy: %s", id=510)
    public void fetchModeJoinWithLazyWarning(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The %2$s version for [%s] is no longer supported, hence certain features may not work properly. The minimum supported version is %3$s. Check the community dialects project for available legacy versions.", id=511)
    public void unsupportedDatabaseVersion(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Unable to create the ReflectionOptimizer for [%s]: %s", id=513)
    public void unableToGenerateReflectionOptimizer(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Failed to discover types for enhancement from class: %s", id=516)
    public void enhancementDiscoveryFailed(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="JDBCException was thrown for a transaction marked for rollback.  This is probably due to an operation failing fast due to the transaction being marked for rollback.", id=520)
    public void jdbcExceptionThrownWithTransactionRolledBack(@Cause JDBCException var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Flushing and evicting managed instance of type [%s] before removing detached instance with same id", id=530)
    public void flushAndEvictOnRemove(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Illegal argument on static metamodel field injection: %s#%s; expected type: %s; encountered type: %s", id=15007)
    public void illegalArgumentOnStaticMetamodelFieldInjection(String var1, String var2, String var3, String var4);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to locate static metamodel field: %s#%s; this may or may not indicate a problem with the static metamodel", id=15011)
    public void unableToLocateStaticMetamodelField(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Returning null (as required by JPA spec) rather than throwing EntityNotFoundException since the entity of type '%s' with id [%s] does not exist", id=15013)
    public void ignoringEntityNotFound(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=15015, value="Encountered a MappedSuperclass [%s] not used in any entity hierarchy")
    public void unusedMappedSuperclass(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15018, value="Encountered multiple persistence-unit stanzas defining same name [%s]; persistence-unit names must be unique")
    public void duplicatedPersistenceUnitName(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15019, value="Invalid JSON column type [%s], was expecting [%s]; for efficiency schema should be migrate to JSON DDL type")
    public void invalidJSONColumnType(String var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Closing logical connection", id=456)
    public void closingLogicalConnection();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Logical connection closed", id=457)
    public void logicalConnectionClosed();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Statistics initialized", id=460)
    public void statisticsInitialized();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Statistics collection enabled", id=461)
    public void statisticsEnabled();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Statistics collection disabled", id=462)
    public void statisticsDisabled();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Statistics reset", id=463)
    public void statisticsReset();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Initializing service: %s", id=500)
    public void initializingService(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Error stopping service: %s", id=369)
    public void unableToStopService(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Ignoring ServiceConfigurationError caught while instantiating service: %s", id=505)
    public void ignoringServiceConfigurationError(String var1, @Cause ServiceConfigurationError var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Encountered request for service by non-primary service role [%s -> %s]", id=450)
    public void alternateServiceRole(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=401, value="Logging session metrics:\n\t%s ns acquiring %s JDBC connections\n\t%s ns releasing %s JDBC connections\n\t%s ns preparing %s JDBC statements\n\t%s ns executing %s JDBC statements\n\t%s ns executing %s JDBC batches\n\t%s ns performing %s second-level cache puts\n\t%s ns performing %s second-level cache hits\n\t%s ns performing %s second-level cache misses\n\t%s ns executing %s flushes (flushing a total of %s entities and %s collections)\n\t%s ns executing %s pre-partial-flushes\n\t%s ns executing %s partial-flushes (flushing a total of %s entities and %s collections)\n")
    public void sessionMetrics(long var1, int var3, long var4, int var6, long var7, int var9, long var10, int var12, long var13, int var15, long var16, int var18, long var19, int var21, long var22, int var24, long var25, int var27, long var28, long var30, long var32, int var34, long var35, int var37, long var38, long var40);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=400, value="Logging statistics:\n\tStart time: %s\n\tSessions opened (closed): %s (%s)\n\tTransactions started (successful): %s (%s)\n\tOptimistic lock failures: %s\n\tFlushes: %s\n\tConnections obtained: %s\n\tStatements prepared (closed): %s (%s)\n\tSecond-level cache puts: %s\n\tSecond-level cache hits (misses): %s (%s)\n\tEntities loaded: %s\n\tEntities fetched: %s (minimize this)\n\tEntities updated, upserted, inserted, deleted: %s, %s, %s, %s\n\tCollections loaded: %s\n\tCollections fetched: %s (minimize this)\n\tCollections updated, removed, recreated: %s, %s, %s\n\tNatural id queries executed on database: %s\n\tNatural id cache puts: %s\n\tNatural id cache hits (misses): %s (%s)\n\tMax natural id query execution time: %s ms\n\tQueries executed on database: %s\n\tQuery cache puts: %s\n\tQuery cache hits (misses): %s (%s)\n\tMax query execution time: %s ms\n\tUpdate timestamps cache puts: %s\n\tUpdate timestamps cache hits (misses): %s (%s)\n\tQuery plan cache hits (misses): %s (%s)\n")
    public void logStatistics(long var1, long var3, long var5, long var7, long var9, long var11, long var13, long var15, long var17, long var19, long var21, long var23, long var25, long var27, long var29, long var31, long var33, long var35, long var37, long var39, long var41, long var43, long var45, long var47, long var49, long var51, long var53, long var55, long var57, long var59, long var61, long var63, long var65, long var67, long var69, long var71, long var73, long var75, long var77);
}

