/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.spi;

import org.hibernate.Incubating;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.sql.results.internal.RowProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesSourceProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.spi.JdbcValues;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.NoRowException;
import org.hibernate.sql.results.spi.ResultsConsumer;
import org.hibernate.sql.results.spi.RowReader;

@Incubating
public class SingleResultConsumer<T>
implements ResultsConsumer<T, T> {
    private static final SingleResultConsumer<?> INSTANCE = new SingleResultConsumer();

    public static <T> SingleResultConsumer<T> instance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T consume(JdbcValues jdbcValues, SharedSessionContractImplementor session, JdbcValuesSourceProcessingOptions processingOptions, JdbcValuesSourceProcessingStateStandardImpl jdbcValuesSourceProcessingState, RowProcessingStateStandardImpl rowProcessingState, RowReader<T> rowReader) {
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        RuntimeException ex = null;
        persistenceContext.beforeLoad();
        persistenceContext.getLoadContexts().register(jdbcValuesSourceProcessingState);
        try {
            rowReader.startLoading(rowProcessingState);
            boolean hadResult = rowProcessingState.next();
            if (!hadResult) {
                throw new NoRowException("SQL query returned no results");
            }
            T result = rowReader.readRow(rowProcessingState);
            rowProcessingState.finishRowProcessing(true);
            rowReader.finishUp(rowProcessingState);
            jdbcValuesSourceProcessingState.finishUp(true);
            T t = result;
            return t;
        }
        catch (RuntimeException e) {
            ex = e;
            return (T)ex;
        }
        finally {
            try {
                jdbcValues.finishUp(session);
                persistenceContext.afterLoad();
                persistenceContext.getLoadContexts().deregister(jdbcValuesSourceProcessingState);
                persistenceContext.initializeNonLazyCollections();
            }
            catch (RuntimeException e) {
                if (ex != null) {
                    ex.addSuppressed(e);
                }
                ex = e;
                return (T)ex;
            }
            finally {
                if (ex == null) throw new IllegalStateException("Should not reach this");
                throw ex;
            }
        }
    }

    @Override
    public boolean canResultsBeCached() {
        return false;
    }
}

