/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.IrDeclarationDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrDeserializationSettings;
import org.jetbrains.kotlin.backend.common.serialization.IrFileDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrInterningService;
import org.jetbrains.kotlin.backend.common.serialization.IrLibraryFile;
import org.jetbrains.kotlin.backend.common.serialization.IrLibraryFileFromBytes;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrSymbolDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrSymbolDeserializerKt;
import org.jetbrains.kotlin.backend.common.serialization.KotlinIrLinker;
import org.jetbrains.kotlin.backend.common.serialization.encodings.BinarySymbolData;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrFile;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.symbols.IrFileSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.ReferenceSymbolTable;
import org.jetbrains.kotlin.ir.util.SymbolTable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020(J\u0006\u0010-\u001a\u00020+J\u0006\u0010.\u001a\u00020+R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001e\u0010&\u001a\u0012\u0012\u0004\u0012\u00020(0'j\b\u0012\u0004\u0012\u00020(`)X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/FileDeserializationState;", "", "linker", "Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;", "fileIndex", "", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "fileReader", "Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryFileFromBytes;", "fileProto", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrFile;", "settings", "Lorg/jetbrains/kotlin/backend/common/serialization/IrDeserializationSettings;", "moduleDeserializer", "Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;ILorg/jetbrains/kotlin/ir/declarations/IrFile;Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryFileFromBytes;Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrFile;Lorg/jetbrains/kotlin/backend/common/serialization/IrDeserializationSettings;Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;)V", "getLinker", "()Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;", "getFileIndex", "()I", "getFile", "()Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "getFileReader", "()Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryFileFromBytes;", "symbolDeserializer", "Lorg/jetbrains/kotlin/backend/common/serialization/IrSymbolDeserializer;", "getSymbolDeserializer", "()Lorg/jetbrains/kotlin/backend/common/serialization/IrSymbolDeserializer;", "declarationDeserializer", "Lorg/jetbrains/kotlin/backend/common/serialization/IrDeclarationDeserializer;", "getDeclarationDeserializer", "()Lorg/jetbrains/kotlin/backend/common/serialization/IrDeclarationDeserializer;", "fileDeserializer", "Lorg/jetbrains/kotlin/backend/common/serialization/IrFileDeserializer;", "getFileDeserializer", "()Lorg/jetbrains/kotlin/backend/common/serialization/IrFileDeserializer;", "reachableTopLevels", "Ljava/util/LinkedHashSet;", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Lkotlin/collections/LinkedHashSet;", "addIdSignature", "", "topLevelDeclarationSignature", "enqueueAllDeclarations", "deserializeAllFileReachableTopLevel", "ir.serialization.common"})
@SourceDebugExtension(value={"SMAP\nIrFileDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrFileDeserializer.kt\norg/jetbrains/kotlin/backend/common/serialization/FileDeserializationState\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,254:1\n231#2:255\n1869#3,2:256\n1#4:258\n*S KotlinDebug\n*F\n+ 1 IrFileDeserializer.kt\norg/jetbrains/kotlin/backend/common/serialization/FileDeserializationState\n*L\n108#1:255\n142#1:256,2\n*E\n"})
public final class FileDeserializationState {
    @NotNull
    private final KotlinIrLinker linker;
    private final int fileIndex;
    @NotNull
    private final org.jetbrains.kotlin.ir.declarations.IrFile file;
    @NotNull
    private final IrLibraryFileFromBytes fileReader;
    @NotNull
    private final IrSymbolDeserializer symbolDeserializer;
    @NotNull
    private final IrDeclarationDeserializer declarationDeserializer;
    @NotNull
    private final IrFileDeserializer fileDeserializer;
    @NotNull
    private final LinkedHashSet<IdSignature> reachableTopLevels;

    public FileDeserializationState(@NotNull KotlinIrLinker linker2, int fileIndex, @NotNull org.jetbrains.kotlin.ir.declarations.IrFile file2, @NotNull IrLibraryFileFromBytes fileReader, @NotNull IrFile fileProto, @NotNull IrDeserializationSettings settings, @NotNull IrModuleDeserializer moduleDeserializer) {
        Function2<IrSymbol, BinarySymbolData.SymbolKind, IrSymbol> function2;
        Intrinsics.checkNotNullParameter(linker2, "linker");
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(fileReader, "fileReader");
        Intrinsics.checkNotNullParameter(fileProto, "fileProto");
        Intrinsics.checkNotNullParameter(settings, "settings");
        Intrinsics.checkNotNullParameter(moduleDeserializer, "moduleDeserializer");
        this.linker = linker2;
        this.fileIndex = fileIndex;
        this.file = file2;
        this.fileReader = fileReader;
        SymbolTable symbolTable = this.linker.getSymbolTable();
        IrLibraryFileFromBytes irLibraryFileFromBytes = this.fileReader;
        IrFileSymbol irFileSymbol = this.file.getSymbol();
        KFunction kFunction = (KFunction)((Object)new Function1<IdSignature, Unit>((Object)this){

            public final void invoke(IdSignature p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                ((FileDeserializationState)this.receiver).addIdSignature(p0);
            }
        });
        Function3<IrSymbolDeserializer, IrSymbol, IdSignature, IrSymbol> function3 = this.linker.getSymbolProcessor();
        IrInterningService irInterningService = this.linker.getIrInterner();
        this.symbolDeserializer = new IrSymbolDeserializer(symbolTable, irLibraryFileFromBytes, irFileSymbol, (Function1)((Object)kFunction), irInterningService, function3, null, (arg_0, arg_1) -> FileDeserializationState.symbolDeserializer$lambda$0(this, moduleDeserializer, arg_0, arg_1), 64, null);
        FileDeserializationState fileDeserializationState = this;
        IrBuiltIns irBuiltIns = this.linker.getBuiltIns();
        SymbolTable symbolTable2 = this.linker.getSymbolTable();
        IrFactory irFactory = this.linker.getSymbolTable().getIrFactory();
        IrLibraryFile irLibraryFile = this.fileReader;
        IrDeclarationParent irDeclarationParent = this.file;
        IrDeserializationSettings irDeserializationSettings = settings;
        IrSymbolDeserializer irSymbolDeserializer = this.symbolDeserializer;
        Function2<IrClass, IdSignature, Unit> function22 = (arg_0, arg_1) -> FileDeserializationState.declarationDeserializer$lambda$1(this, moduleDeserializer, arg_0, arg_1);
        Function1<IrClass, Boolean> function1 = arg_0 -> FileDeserializationState.declarationDeserializer$lambda$2(this, arg_0);
        boolean condition$iv = this.linker.getPartialLinkageSupport().isEnabled();
        boolean $i$f$runIf = false;
        if (condition$iv) {
            Function1<IrClass, Boolean> function12 = function1;
            Function2<IrClass, IdSignature, Unit> function23 = function22;
            IrSymbolDeserializer irSymbolDeserializer2 = irSymbolDeserializer;
            IrDeserializationSettings irDeserializationSettings2 = irDeserializationSettings;
            IrDeclarationParent irDeclarationParent2 = irDeclarationParent;
            IrLibraryFile irLibraryFile2 = irLibraryFile;
            IrFactory irFactory2 = irFactory;
            SymbolTable symbolTable3 = symbolTable2;
            IrBuiltIns irBuiltIns2 = irBuiltIns;
            FileDeserializationState fileDeserializationState2 = fileDeserializationState;
            boolean bl = false;
            Function2<IrSymbol, BinarySymbolData.SymbolKind, IrSymbol> function24 = (arg_0, arg_1) -> FileDeserializationState.declarationDeserializer$lambda$5$lambda$4(this, arg_0, arg_1);
            fileDeserializationState = fileDeserializationState2;
            irBuiltIns = irBuiltIns2;
            symbolTable2 = symbolTable3;
            irFactory = irFactory2;
            irLibraryFile = irLibraryFile2;
            irDeclarationParent = irDeclarationParent2;
            irDeserializationSettings = irDeserializationSettings2;
            irSymbolDeserializer = irSymbolDeserializer2;
            function22 = function23;
            function1 = function12;
            function2 = function24;
        } else {
            function2 = null;
        }
        IrInterningService irInterningService2 = this.linker.getIrInterner();
        Function2<IrSymbol, BinarySymbolData.SymbolKind, IrSymbol> function25 = function2;
        Function1<IrClass, Boolean> function13 = function1;
        Function2<IrClass, IdSignature, Unit> function26 = function22;
        IrSymbolDeserializer irSymbolDeserializer3 = irSymbolDeserializer;
        IrDeserializationSettings irDeserializationSettings3 = irDeserializationSettings;
        IrDeclarationParent irDeclarationParent3 = irDeclarationParent;
        IrLibraryFile irLibraryFile3 = irLibraryFile;
        IrFactory irFactory3 = irFactory;
        SymbolTable symbolTable4 = symbolTable2;
        IrBuiltIns irBuiltIns3 = irBuiltIns;
        fileDeserializationState.declarationDeserializer = new IrDeclarationDeserializer(irBuiltIns3, symbolTable4, irFactory3, irLibraryFile3, irDeclarationParent3, irDeserializationSettings3, irSymbolDeserializer3, function26, function13, function25, irInterningService2);
        this.fileDeserializer = new IrFileDeserializer(this.file, this.fileReader, fileProto, this.symbolDeserializer, this.declarationDeserializer);
        this.reachableTopLevels = new LinkedHashSet();
        List<Long> list = fileProto.getExplicitlyExportedToCompilerList();
        Intrinsics.checkNotNullExpressionValue(list, "getExplicitlyExportedToCompilerList(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            Long it = (Long)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull(it);
            long symbolData = this.symbolDeserializer.parseSymbolData-9x8F8T0(it);
            IdSignature sig = this.symbolDeserializer.deserializeIdSignature(BinarySymbolData.getSignatureId-impl(symbolData));
            boolean bl3 = bl = !sig.isPackageSignature();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            this.addIdSignature(sig.topLevelSignature());
        }
    }

    @NotNull
    public final KotlinIrLinker getLinker() {
        return this.linker;
    }

    public final int getFileIndex() {
        return this.fileIndex;
    }

    @NotNull
    public final org.jetbrains.kotlin.ir.declarations.IrFile getFile() {
        return this.file;
    }

    @NotNull
    public final IrLibraryFileFromBytes getFileReader() {
        return this.fileReader;
    }

    @NotNull
    public final IrSymbolDeserializer getSymbolDeserializer() {
        return this.symbolDeserializer;
    }

    @NotNull
    public final IrDeclarationDeserializer getDeclarationDeserializer() {
        return this.declarationDeserializer;
    }

    @NotNull
    public final IrFileDeserializer getFileDeserializer() {
        return this.fileDeserializer;
    }

    public final void addIdSignature(@NotNull IdSignature topLevelDeclarationSignature) {
        Intrinsics.checkNotNullParameter(topLevelDeclarationSignature, "topLevelDeclarationSignature");
        this.reachableTopLevels.add(topLevelDeclarationSignature);
    }

    public final void enqueueAllDeclarations() {
        this.reachableTopLevels.addAll((Collection<IdSignature>)this.fileDeserializer.getReversedSignatureIndex().keySet());
    }

    public final void deserializeAllFileReachableTopLevel() {
        while (!((Collection)this.reachableTopLevels).isEmpty()) {
            IdSignature topLevelDeclarationSignature = (IdSignature)CollectionsKt.first((Iterable)this.reachableTopLevels);
            IrSymbol topLevelDeclarationSymbol = this.symbolDeserializer.getDeserializedSymbols().get(topLevelDeclarationSignature);
            if (topLevelDeclarationSymbol == null || !topLevelDeclarationSymbol.isBound()) {
                IrDeclaration topLevelDeclaration = this.fileDeserializer.deserializeDeclaration(topLevelDeclarationSignature);
                this.linker.getPartialLinkageSupport().enqueueDeclaration(topLevelDeclaration);
            }
            this.reachableTopLevels.remove(topLevelDeclarationSignature);
        }
    }

    private static final IrSymbol symbolDeserializer$lambda$0(FileDeserializationState this$0, IrModuleDeserializer $moduleDeserializer, IdSignature idSignature, BinarySymbolData.SymbolKind symbolKind) {
        Intrinsics.checkNotNullParameter(idSignature, "idSignature");
        Intrinsics.checkNotNullParameter((Object)symbolKind, "symbolKind");
        return this$0.linker.deserializeOrReturnUnboundIrSymbolIfPartialLinkageEnabled(idSignature, symbolKind, $moduleDeserializer);
    }

    private static final Unit declarationDeserializer$lambda$1(FileDeserializationState this$0, IrModuleDeserializer $moduleDeserializer, IrClass clazz, IdSignature signature) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        Intrinsics.checkNotNullParameter(signature, "signature");
        this$0.linker.getFakeOverrideBuilder().enqueueClass(clazz, signature, $moduleDeserializer.getCompatibilityMode());
        return Unit.INSTANCE;
    }

    private static final boolean declarationDeserializer$lambda$2(FileDeserializationState this$0, IrClass clazz) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        return !this$0.linker.getFakeOverrideBuilder().getPlatformSpecificClassFilter().needToConstructFakeOverrides(clazz);
    }

    /*
     * WARNING - void declaration
     */
    private static final IrSymbol declarationDeserializer$lambda$5$lambda$4(FileDeserializationState this$0, IrSymbol deserializedSymbol, BinarySymbolData.SymbolKind fallbackSymbolKind) {
        IdSignature idSignature;
        BinarySymbolData.SymbolKind symbolKind;
        IrFileSymbol irFileSymbol;
        ReferenceSymbolTable referenceSymbolTable;
        block5: {
            block4: {
                void it;
                IdSignature idSignature2;
                Intrinsics.checkNotNullParameter(deserializedSymbol, "deserializedSymbol");
                referenceSymbolTable = this$0.linker.getSymbolTable();
                irFileSymbol = null;
                symbolKind = fallbackSymbolKind;
                if (symbolKind == null) {
                    throw new IllegalStateException(("No fallback symbol kind specified for symbol " + deserializedSymbol).toString());
                }
                idSignature = deserializedSymbol.getSignature();
                if (idSignature == null) break block4;
                IdSignature idSignature3 = idSignature2 = idSignature;
                BinarySymbolData.SymbolKind symbolKind2 = symbolKind;
                IrFileSymbol irFileSymbol2 = irFileSymbol;
                ReferenceSymbolTable referenceSymbolTable2 = referenceSymbolTable;
                boolean bl = false;
                boolean bl2 = it.isPubliclyVisible();
                referenceSymbolTable = referenceSymbolTable2;
                irFileSymbol = irFileSymbol2;
                symbolKind = symbolKind2;
                idSignature = bl2 ? idSignature2 : null;
                if (idSignature != null) break block5;
            }
            throw new IllegalStateException(("No public signature for symbol " + deserializedSymbol).toString());
        }
        return IrSymbolDeserializerKt.referenceDeserializedSymbol(referenceSymbolTable, irFileSymbol, symbolKind, idSignature);
    }
}

