/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.jvm;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.JvmIrAttributesKt;
import org.jetbrains.kotlin.backend.jvm.mapping.IrTypeMapper;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.serialization.FirElementAwareStringTable;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmNameResolver;
import org.jetbrains.kotlin.metadata.jvm.serialization.JvmStringTable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\f\u0010\u000b\u001a\u00020\f*\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/backend/jvm/FirJvmElementAwareStringTable;", "Lorg/jetbrains/kotlin/metadata/jvm/serialization/JvmStringTable;", "Lorg/jetbrains/kotlin/fir/serialization/FirElementAwareStringTable;", "typeMapper", "Lorg/jetbrains/kotlin/backend/jvm/mapping/IrTypeMapper;", "components", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "nameResolver", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmNameResolver;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/mapping/IrTypeMapper;Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmNameResolver;)V", "getLocalClassIdReplacement", "Lorg/jetbrains/kotlin/name/ClassId;", "firClass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "jvm-backend"})
@SourceDebugExtension(value={"SMAP\nFirJvmElementAwareStringTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmElementAwareStringTable.kt\norg/jetbrains/kotlin/fir/backend/jvm/FirJvmElementAwareStringTable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n1869#2,2:64\n*S KotlinDebug\n*F\n+ 1 FirJvmElementAwareStringTable.kt\norg/jetbrains/kotlin/fir/backend/jvm/FirJvmElementAwareStringTable\n*L\n56#1:64,2\n*E\n"})
public final class FirJvmElementAwareStringTable
extends JvmStringTable
implements FirElementAwareStringTable {
    @NotNull
    private final IrTypeMapper typeMapper;
    @NotNull
    private final Fir2IrComponents components;

    public FirJvmElementAwareStringTable(@NotNull IrTypeMapper typeMapper2, @NotNull Fir2IrComponents components, @Nullable JvmNameResolver nameResolver) {
        Intrinsics.checkNotNullParameter(typeMapper2, "typeMapper");
        Intrinsics.checkNotNullParameter(components, "components");
        super(nameResolver);
        this.typeMapper = typeMapper2;
        this.components = components;
    }

    public /* synthetic */ FirJvmElementAwareStringTable(IrTypeMapper irTypeMapper, Fir2IrComponents fir2IrComponents, JvmNameResolver jvmNameResolver, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            jvmNameResolver = null;
        }
        this(irTypeMapper, fir2IrComponents, jvmNameResolver);
    }

    @Override
    @NotNull
    public ClassId getLocalClassIdReplacement(@NotNull FirClass firClass) {
        Intrinsics.checkNotNullParameter(firClass, "firClass");
        if (this.components.getConfiguration().getSkipBodies()) {
            Object object = CollectionsKt.firstOrNull(FirDeclarationUtilKt.getSuperConeTypes(firClass));
            if (object == null || (object = ((ConeClassLikeType)object).getLookupTag()) == null || (object = ((ConeClassLikeLookupTag)object).getClassId()) == null) {
                object = StandardClassIds.INSTANCE.getAny();
            }
            return object;
        }
        return this.getLocalClassIdReplacement(this.components.getClassifierStorage().getIrClass(firClass));
    }

    private final ClassId getLocalClassIdReplacement(IrClass $this$getLocalClassIdReplacement) {
        String thisClassName = StringsKt.replace$default(this.typeMapper.classInternalName($this$getLocalClassIdReplacement), '/', '.', false, 4, null);
        if (JvmIrAttributesKt.isEnclosedInConstructor($this$getLocalClassIdReplacement)) {
            FqName thisClassFqName = new FqName(thisClassName);
            return new ClassId(thisClassFqName.parent(), FqName.Companion.topLevel(thisClassFqName.shortName()), true);
        }
        IrClass topmostClassParent = SequencesKt.last(SequencesKt.generateSequence($this$getLocalClassIdReplacement, FirJvmElementAwareStringTable::getLocalClassIdReplacement$lambda$0));
        String topmostClassParentName = StringsKt.replace$default(this.typeMapper.classInternalName(topmostClassParent), '/', '.', false, 4, null);
        FqName prefixFqName = new FqName(topmostClassParentName);
        ClassId classId = null;
        classId = new ClassId(prefixFqName.parent(), FqName.Companion.topLevel(prefixFqName.shortName()), true);
        if (thisClassName.length() == topmostClassParentName.length()) {
            return classId;
        }
        String string = thisClassName.substring(topmostClassParentName.length() + 1);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        char[] cArray = new char[]{'$'};
        Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)string, cArray, false, 0, 6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            Name name2 = Name.identifier(it);
            Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
            classId = classId.createNestedClassId(name2);
        }
        return classId;
    }

    private static final IrClass getLocalClassIdReplacement$lambda$0(IrClass it) {
        Intrinsics.checkNotNullParameter(it, "it");
        IrDeclarationParent irDeclarationParent = it.getParent();
        return irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
    }
}

