/*
 * Decompiled with CFR 0.152.
 */
package mediathek.javafx.bookmark;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javafx.collections.ObservableList;
import mediathek.config.Daten;
import mediathek.config.StandardLocations;
import mediathek.controller.history.SeenHistoryController;
import mediathek.daten.DatenFilm;
import mediathek.daten.ListeFilme;
import mediathek.javafx.bookmark.BookmarkData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BookmarkDataList {
    private static final Logger logger = LogManager.getLogger();
    private final ObservableList<BookmarkData> bookmarks;

    /*
     * Exception decompiling
     */
    public BookmarkDataList(@NotNull Daten daten) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @JsonGetter(value="bookmarks")
    public ObservableList<BookmarkData> getObervableList() {
        return this.bookmarks;
    }

    public void checkAndBookmarkMovies(@NotNull List<DatenFilm> movies) {
        ArrayList<DatenFilm> addlist = new ArrayList<DatenFilm>();
        ArrayList<BookmarkData> dellist = new ArrayList<BookmarkData>();
        boolean add = false;
        for (DatenFilm datenFilm : movies) {
            if (!datenFilm.isBookmarked()) {
                add = true;
                addlist.add(datenFilm);
                continue;
            }
            BookmarkData bookmarkData = this.findMovieInList(datenFilm);
            if (bookmarkData == null) continue;
            dellist.add(bookmarkData);
        }
        if (add) {
            try (SeenHistoryController history = new SeenHistoryController();){
                for (DatenFilm datenFilm : addlist) {
                    BookmarkData bdata = new BookmarkData(datenFilm);
                    datenFilm.setBookmark(bdata);
                    bdata.setSeen(!bdata.isLiveStream() && history.hasBeenSeen(datenFilm));
                    this.bookmarks.add((Object)bdata);
                }
            }
            catch (Exception ex) {
                logger.error("history produced error", (Throwable)ex);
            }
        } else {
            for (DatenFilm datenFilm : movies) {
                datenFilm.setBookmark(null);
            }
            this.bookmarks.removeAll(dellist);
        }
    }

    public void deleteEntries(@NotNull List<BookmarkData> bookmarkList) {
        for (BookmarkData bookmark : bookmarkList) {
            DatenFilm movie = bookmark.getDatenFilm();
            if (movie == null) continue;
            movie.setBookmark(null);
        }
        this.bookmarks.removeAll(bookmarkList);
    }

    public void loadFromFile() {
        Path filePath = StandardLocations.getBookmarkFilePath();
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            BookmarksWrapper wrapper = (BookmarksWrapper)objectMapper.readValue(filePath.toFile(), BookmarksWrapper.class);
            List<BookmarkData> bookmarkList = wrapper.getBookmarks();
            if (bookmarkList != null) {
                this.bookmarks.addAll(bookmarkList);
                bookmarkList.clear();
            }
        }
        catch (Exception e) {
            logger.error("Could not read bookmarks from file {}, error {} => file ignored", (Object)filePath.toString(), (Object)e.getMessage());
        }
    }

    public synchronized void saveToFile() {
        Path filePath = StandardLocations.getBookmarkFilePath();
        try {
            ObjectWriter objectMapper = new ObjectMapper().writerWithDefaultPrettyPrinter();
            objectMapper.writeValue(filePath.toFile(), (Object)this);
            logger.trace("Bookmarks written");
        }
        catch (IOException e) {
            logger.error("Could not save bookmarks to {}", (Object)filePath, (Object)e);
        }
    }

    public void updateSeen(boolean seen, @NotNull List<DatenFilm> list) {
        list.stream().filter(DatenFilm::isBookmarked).forEachOrdered(movie -> {
            BookmarkData bookmark = movie.getBookmark();
            if (bookmark != null) {
                bookmark.setSeen(seen);
            }
        });
    }

    public void updateSeen(boolean seen, @NotNull DatenFilm film) {
        BookmarkData bookmark;
        if (film.isBookmarked() && (bookmark = film.getBookmark()) != null) {
            bookmark.setSeen(seen);
        }
    }

    private BookmarkData findMovieInList(@NotNull DatenFilm movie) {
        BookmarkData result = null;
        for (BookmarkData data : this.bookmarks) {
            if (data.getDatenFilm() == null || !data.getDatenFilm().equals(movie)) continue;
            result = data;
            break;
        }
        return result;
    }

    private void updateBookMarksFromFilmList() {
        if (this.bookmarks.isEmpty()) {
            return;
        }
        ListeFilme listefilme = Daten.getInstance().getListeFilme();
        for (BookmarkData bookmark : this.bookmarks) {
            DatenFilm film = listefilme.getFilmByUrl(bookmark.getUrl());
            bookmark.setDatenFilm(film);
            if (film == null) continue;
            film.setBookmark(bookmark);
        }
    }

    private static class BookmarksWrapper {
        private List<BookmarkData> bookmarks;

        private BookmarksWrapper() {
        }

        public List<BookmarkData> getBookmarks() {
            return this.bookmarks;
        }

        public void setBookmarks(List<BookmarkData> bookmarks) {
            this.bookmarks = bookmarks;
        }
    }
}

