/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.cellrenderer;

import com.formdev.flatlaf.extras.FlatSVGIcon;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import mediathek.config.MVColor;
import mediathek.controller.starter.Start;
import mediathek.daten.Country;
import mediathek.daten.DatenFilm;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.MessageBus;
import mediathek.tool.SVGIconUtilities;
import mediathek.tool.cellrenderer.CellRendererBase;
import mediathek.tool.swing.CompoundIcon;
import org.apache.commons.configuration2.Configuration;
import org.jetbrains.annotations.NotNull;

public class CellRendererBaseWithStart
extends CellRendererBase {
    public static final String ICON_POSITION_RIGHT = "ui.list.iconposition_right";
    private static final EnumSet<Country> euCountryList = EnumSet.of(Country.DE, Country.AT, Country.FR);
    protected final Configuration config = ApplicationConfiguration.getConfiguration();
    protected final FlatSVGIcon lockedIcon;
    protected final FlatSVGIcon lockedIconSelected;
    protected final FlatSVGIcon unlockedIcon;
    protected final FlatSVGIcon unlockedIconSelected;
    private final List<Icon> iconList = new ArrayList<Icon>();
    private final FlatSVGIcon subtitleIcon;
    private final FlatSVGIcon subtitleIconSelected;
    private final FlatSVGIcon highQualityIcon;
    private final FlatSVGIcon highQualityIconSelected;
    private final FlatSVGIcon liveStreamIcon;
    private final FlatSVGIcon liveStreamIconSelected;
    private final FlatSVGIcon audioDescription;
    private final FlatSVGIcon audioDescriptionSelected;
    protected final FlatSVGIcon.ColorFilter whiteColorFilter = new FlatSVGIcon.ColorFilter(color -> Color.WHITE);

    public CellRendererBaseWithStart() {
        MessageBus.getMessageBus().subscribe((Object)this);
        this.lockedIcon = SVGIconUtilities.createSVGIcon("icons/fontawesome/lock.svg");
        this.lockedIconSelected = SVGIconUtilities.createSVGIcon("icons/fontawesome/lock.svg");
        this.lockedIconSelected.setColorFilter(this.whiteColorFilter);
        this.unlockedIcon = SVGIconUtilities.createSVGIcon("icons/fontawesome/lock-open.svg");
        this.unlockedIconSelected = SVGIconUtilities.createSVGIcon("icons/fontawesome/lock-open.svg");
        this.unlockedIconSelected.setColorFilter(this.whiteColorFilter);
        this.subtitleIcon = SVGIconUtilities.createSVGIcon("icons/fontawesome/closed-captioning.svg");
        this.subtitleIconSelected = SVGIconUtilities.createSVGIcon("icons/fontawesome/closed-captioning.svg");
        this.subtitleIconSelected.setColorFilter(this.whiteColorFilter);
        this.highQualityIcon = SVGIconUtilities.createSVGIcon("icons/derreisende77/high-quality.svg");
        this.highQualityIconSelected = SVGIconUtilities.createSVGIcon("icons/derreisende77/high-quality.svg");
        this.highQualityIconSelected.setColorFilter(this.whiteColorFilter);
        this.liveStreamIcon = SVGIconUtilities.createSVGIcon("icons/fontawesome/tower-cell.svg");
        this.liveStreamIconSelected = SVGIconUtilities.createSVGIcon("icons/fontawesome/tower-cell.svg");
        this.liveStreamIconSelected.setColorFilter(this.whiteColorFilter);
        this.audioDescription = SVGIconUtilities.createSVGIcon("icons/fontawesome/audio-description.svg");
        this.audioDescriptionSelected = SVGIconUtilities.createSVGIcon("icons/fontawesome/audio-description.svg");
        this.audioDescriptionSelected.setColorFilter(this.whiteColorFilter);
    }

    protected void drawGeolocationIcons(@NotNull DatenFilm film, boolean isSelected) {
        this.setHorizontalAlignment(0);
        this.setText("");
        if (film.countrySet.isEmpty()) {
            this.setToolTipText("Keine Geoinformationen vorhanden");
            if (isSelected) {
                this.setIcon((Icon)this.unlockedIconSelected);
            } else {
                this.setIcon((Icon)this.unlockedIcon);
            }
        } else {
            String geoString = film.countrySet.stream().map(Enum::toString).collect(Collectors.joining("-"));
            this.setToolTipText(geoString);
            if (this.filmIsCountryUnlocked(film)) {
                if (isSelected) {
                    this.setIcon((Icon)this.unlockedIconSelected);
                } else {
                    this.setIcon((Icon)this.unlockedIcon);
                }
            } else if (isSelected) {
                this.setIcon((Icon)this.lockedIconSelected);
            } else {
                this.setIcon((Icon)this.lockedIcon);
            }
        }
    }

    private boolean filmIsCountryUnlocked(@NotNull DatenFilm film) {
        Country curLocation = ApplicationConfiguration.getInstance().getGeographicLocation();
        if (film.countrySet.contains((Object)Country.EU)) {
            return film.countrySet.contains((Object)curLocation) || euCountryList.contains((Object)curLocation);
        }
        return film.countrySet.contains((Object)curLocation);
    }

    protected void resetComponent() {
        this.setBackground(null);
        this.setForeground(null);
        this.setIcon(null);
        this.setToolTipText(null);
        this.setHorizontalAlignment(10);
    }

    protected void setBackgroundColor(Component c, Start s, boolean isSelected) {
        if (s != null) {
            Color color = null;
            switch (s.status) {
                case 1: {
                    if (isSelected) {
                        color = MVColor.DOWNLOAD_WAIT_SEL.color;
                        break;
                    }
                    color = MVColor.DOWNLOAD_WAIT.color;
                    break;
                }
                case 2: {
                    if (isSelected) {
                        color = MVColor.DOWNLOAD_RUN_SEL.color;
                        break;
                    }
                    color = MVColor.DOWNLOAD_RUN.color;
                    break;
                }
                case 3: {
                    if (isSelected) {
                        color = MVColor.DOWNLOAD_FERTIG_SEL.color;
                        break;
                    }
                    color = MVColor.DOWNLOAD_FERTIG.color;
                    break;
                }
                case 4: {
                    color = isSelected ? MVColor.DOWNLOAD_FEHLER_SEL.color : MVColor.DOWNLOAD_FEHLER.color;
                }
            }
            c.setBackground(color);
        }
    }

    protected void setIndicatorIcons(@NotNull JTable table, @NotNull DatenFilm datenFilm, boolean isSelected) {
        TableColumn tc;
        if (!datenFilm.countrySet.isEmpty() && !this.filmIsCountryUnlocked(datenFilm)) {
            if (isSelected) {
                this.iconList.add((Icon)this.lockedIconSelected);
            } else {
                this.iconList.add((Icon)this.lockedIcon);
            }
        }
        if ((tc = table.getColumn("HQ")).getWidth() == 0 && datenFilm.isHighQuality()) {
            if (isSelected) {
                this.iconList.add((Icon)this.highQualityIconSelected);
            } else {
                this.iconList.add((Icon)this.highQualityIcon);
            }
        }
        if (datenFilm.isAudioVersion()) {
            if (isSelected) {
                this.iconList.add((Icon)this.audioDescriptionSelected);
            } else {
                this.iconList.add((Icon)this.audioDescription);
            }
        }
        if ((tc = table.getColumn("UT")).getWidth() == 0 && datenFilm.hasSubtitle()) {
            if (isSelected) {
                this.iconList.add((Icon)this.subtitleIconSelected);
            } else {
                this.iconList.add((Icon)this.subtitleIcon);
            }
        }
        if (datenFilm.isLivestream()) {
            if (isSelected) {
                this.iconList.add((Icon)this.liveStreamIconSelected);
            } else {
                this.iconList.add((Icon)this.liveStreamIcon);
            }
        }
        Icon icon = this.iconList.size() == 1 ? this.iconList.getFirst() : new CompoundIcon(CompoundIcon.Axis.X_AXIS, 3, this.iconList.toArray(new Icon[0]));
        this.setIcon(icon);
        int position = ApplicationConfiguration.getConfiguration().getBoolean(ICON_POSITION_RIGHT, false) ? 10 : 11;
        this.setHorizontalTextPosition(position);
        this.iconList.clear();
    }
}

