/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.io;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.ThreadModuleBuiltins;
import com.oracle.graal.python.builtins.modules.io.BufferedIOUtil;
import com.oracle.graal.python.builtins.modules.io.BufferedWriterNodes;
import com.oracle.graal.python.builtins.modules.io.IONodes;
import com.oracle.graal.python.builtins.modules.io.PBuffered;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.truffle.PythonIntegerTypes;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaLongExactNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

public class BufferedIONodes {
    static long tell(VirtualFrame frame, Node inliningTarget, Object raw, PyObjectCallMethodObjArgs callMethod, AsOffNumberNode asOffNumberNode) {
        Object res = callMethod.execute((Frame)frame, inliningTarget, raw, IONodes.T_TELL, new Object[0]);
        return asOffNumberNode.execute(frame, inliningTarget, res, PythonErrorType.ValueError);
    }

    @ImportStatic(value={PGuards.class})
    @TypeSystemReference(value=PythonIntegerTypes.class)
    @GenerateInline
    @GenerateCached(value=false)
    static abstract class AsOffNumberNode
    extends PNodeWithContext {
        AsOffNumberNode() {
        }

        public abstract long execute(VirtualFrame var1, Node var2, Object var3, PythonBuiltinClassType var4);

        @Specialization
        static long doInt(long number, PythonBuiltinClassType err) {
            return number;
        }

        @Specialization
        static long toLong(VirtualFrame frame, Node inliningTarget, Object number, PythonBuiltinClassType err, @Cached PRaiseNode raiseNode, @Cached PyNumberIndexNode indexNode, @Cached CastToJavaLongExactNode cast, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile) {
            Object index = indexNode.execute((Frame)frame, inliningTarget, number);
            try {
                return cast.execute(inliningTarget, index);
            }
            catch (PException e) {
                e.expect(inliningTarget, PythonBuiltinClassType.OverflowError, errorProfile);
                throw raiseNode.raise(inliningTarget, err, ErrorMessages.CANNOT_FIT_P_IN_OFFSET_SIZE, number);
            }
            catch (CannotCastException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class EnterBufferedBusyNode
    extends PNodeWithContext {
        EnterBufferedBusyNode() {
        }

        public abstract void execute(Node var1, PBuffered var2);

        @Specialization(guards={"!self.isOwn()", "!getContext().isFinalizing()"})
        static void normal(Node inliningTarget, PBuffered self, @Cached(inline=false) GilNode gil) {
            gil.release(true);
            try {
                self.getLock().acquireBlocking(inliningTarget);
            }
            finally {
                gil.acquire();
            }
        }

        @Specialization(guards={"!self.isOwn()", "getContext().isFinalizing()"})
        static void finalizing(Node inliningTarget, PBuffered self, @Cached.Shared @Cached PRaiseNode lazyRaise) {
            if (!self.getLock().acquireTimeout(inliningTarget, 1000L)) {
                throw lazyRaise.raise(inliningTarget, PythonErrorType.SystemError, ErrorMessages.SHUTDOWN_POSSIBLY_DUE_TO_DAEMON_THREADS);
            }
        }

        @Specialization(guards={"self.isOwn()"})
        static void error(Node inliningTarget, PBuffered self, @Cached.Shared @Cached PRaiseNode lazyRaise) {
            throw lazyRaise.raise(inliningTarget, PythonErrorType.RuntimeError, ErrorMessages.REENTRANT_CALL_INSIDE_P, self);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class EnterBufferedNode
    extends Node {
        EnterBufferedNode() {
        }

        public abstract void execute(Node var1, PBuffered var2);

        @Specialization
        static void doEnter(Node inliningTarget, PBuffered self, @Cached EnterBufferedBusyNode enterBufferedBusyNode, @Cached InlinedConditionProfile isBusy) {
            if (isBusy.profile(inliningTarget, !self.getLock().acquireNonBlocking())) {
                enterBufferedBusyNode.execute(inliningTarget, self);
            }
            self.setOwner(ThreadModuleBuiltins.GetCurrentThreadIdNode.getId());
        }

        void enter(Node inliningTarget, PBuffered self) {
            this.execute(inliningTarget, self);
        }

        static void leave(PBuffered self) {
            self.setOwner(0L);
            self.getLock().release();
        }
    }

    @GenerateInline
    @GenerateCached
    static abstract class SeekNode
    extends PNodeWithContext {
        SeekNode() {
        }

        public abstract long execute(VirtualFrame var1, Node var2, PBuffered var3, long var4, int var6);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static long seek(VirtualFrame frame, Node ignored, PBuffered self, long off, int whence, @Bind Node inliningTarget, @Cached EnterBufferedNode lock, @Cached(inline=false) BufferedWriterNodes.FlushUnlockedNode flushUnlockedNode, @Cached(inline=false) RawSeekNode rawSeekNode, @Cached LazyRawTellNode rawTellNode, @Cached InlinedConditionProfile whenceSeekSetProfile, @Cached InlinedConditionProfile whenceSeekCurProfile, @Cached InlinedConditionProfile isReadbleProfile, @Cached InlinedConditionProfile isWriteableProfile, @Cached InlinedConditionProfile isSetOrCur, @Cached InlinedConditionProfile isAvail) {
            long target = off;
            boolean whenceSeekSet = whenceSeekSetProfile.profile(inliningTarget, whence == 0);
            boolean whenceSeekCur = whenceSeekCurProfile.profile(inliningTarget, whence == 1);
            boolean selfIsReadable = isReadbleProfile.profile(inliningTarget, self.isReadable());
            if (isSetOrCur.profile(inliningTarget, (whenceSeekSet || whenceSeekCur) && selfIsReadable)) {
                long current = self.getAbsPos() != -1L ? self.getAbsPos() : rawTellNode.get(inliningTarget).executeCached(frame, self);
                int avail = BufferedIOUtil.readahead(self);
                if (isAvail.profile(inliningTarget, avail > 0)) {
                    long offset = target;
                    if (whenceSeekSet) {
                        offset -= current - BufferedIOUtil.rawOffset(self);
                    }
                    if (offset >= (long)(-self.getPos()) && offset <= (long)avail) {
                        self.incPos((int)offset);
                        return current - (long)avail + offset;
                    }
                }
            }
            lock.enter(inliningTarget, self);
            try {
                if (isWriteableProfile.profile(inliningTarget, self.isWritable())) {
                    flushUnlockedNode.execute(frame, self);
                }
                if (whenceSeekCur) {
                    target -= BufferedIOUtil.rawOffset(self);
                }
                long n = rawSeekNode.execute(frame, self, target, whence);
                self.setRawPos(-1L);
                if (selfIsReadable) {
                    self.resetRead();
                }
                long l = n;
                return l;
            }
            finally {
                EnterBufferedNode.leave(self);
            }
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class FlushAndRewindUnlockedNode
    extends PNodeWithContext {
        FlushAndRewindUnlockedNode() {
        }

        public abstract void execute(VirtualFrame var1, Node var2, PBuffered var3);

        @Specialization(guards={"self.isReadable()", "!self.isWritable()"})
        protected static void readOnly(VirtualFrame frame, PBuffered self, @Cached.Shared @Cached(inline=false) RawSeekNode rawSeekNode) {
            long n = rawSeekNode.execute(frame, self, -BufferedIOUtil.rawOffset(self), 1);
            self.resetRead();
            assert (n != -1L);
        }

        @Specialization(guards={"!self.isReadable()", "self.isWritable()"})
        protected static void writeOnly(VirtualFrame frame, PBuffered self, @Cached.Shared @Cached(inline=false) BufferedWriterNodes.FlushUnlockedNode flushUnlockedNode) {
            flushUnlockedNode.execute(frame, self);
        }

        @Specialization(guards={"self.isReadable()", "self.isWritable()"})
        protected static void readWrite(VirtualFrame frame, PBuffered self, @Cached.Shared @Cached(inline=false) BufferedWriterNodes.FlushUnlockedNode flushUnlockedNode, @Cached.Shared @Cached(inline=false) RawSeekNode rawSeekNode) {
            flushUnlockedNode.execute(frame, self);
            long n = rawSeekNode.execute(frame, self, -BufferedIOUtil.rawOffset(self), 1);
            self.resetRead();
            assert (n != -1L);
        }
    }

    @GenerateInline(value=false)
    static abstract class RawSeekNode
    extends PNodeWithContext {
        RawSeekNode() {
        }

        public abstract long execute(VirtualFrame var1, PBuffered var2, long var3, int var5);

        @Specialization
        static long bufferedRawSeek(VirtualFrame frame, PBuffered self, long target, int whence, @Bind Node inliningTarget, @Cached PRaiseNode raise, @Cached PyObjectCallMethodObjArgs callMethod, @Cached AsOffNumberNode asOffNumberNode) {
            Object res = callMethod.execute((Frame)frame, inliningTarget, self.getRaw(), IONodes.T_SEEK, target, whence);
            long n = asOffNumberNode.execute(frame, inliningTarget, res, PythonErrorType.ValueError);
            if (n < 0L) {
                raise.raise(inliningTarget, PythonErrorType.OSError, ErrorMessages.IO_STREAM_INVALID_POS, n);
            }
            self.setAbsPos(n);
            return n;
        }
    }

    @GenerateInline(inlineByDefault=true)
    @GenerateCached(value=false)
    static abstract class RawTellIgnoreErrorNode
    extends PNodeWithContext {
        RawTellIgnoreErrorNode() {
        }

        public abstract long execute(VirtualFrame var1, Node var2, PBuffered var3);

        @Specialization
        static long bufferedRawTellIgnoreException(VirtualFrame frame, Node inliningTarget, PBuffered self, @Cached PyObjectCallMethodObjArgs callMethod, @Cached AsOffNumberNode asOffNumberNode) {
            long n;
            try {
                n = BufferedIONodes.tell(frame, inliningTarget, self.getRaw(), callMethod, asOffNumberNode);
            }
            catch (PException e) {
                n = -1L;
            }
            self.setAbsPos(n);
            return n;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class LazyRawTellNode
    extends Node {
        LazyRawTellNode() {
        }

        public final RawTellNode get(Node inliningTarget) {
            return this.execute(inliningTarget);
        }

        protected abstract RawTellNode execute(Node var1);

        @Specialization
        RawTellNode doIt(@Cached(inline=false) RawTellNode node) {
            return node;
        }
    }

    @GenerateInline(inlineByDefault=true)
    @GenerateCached
    static abstract class RawTellNode
    extends PNodeWithContext {
        RawTellNode() {
        }

        public abstract long execute(VirtualFrame var1, Node var2, PBuffered var3);

        public final long executeCached(VirtualFrame frame, PBuffered self) {
            return this.execute(frame, this, self);
        }

        @Specialization
        static long bufferedRawTell(VirtualFrame frame, Node inliningTarget, PBuffered self, @Cached PRaiseNode lazyRaiseNode, @Cached PyObjectCallMethodObjArgs callMethod, @Cached AsOffNumberNode asOffNumberNode) {
            long n = BufferedIONodes.tell(frame, inliningTarget, self.getRaw(), callMethod, asOffNumberNode);
            if (n < 0L) {
                throw lazyRaiseNode.raise(inliningTarget, PythonErrorType.OSError, ErrorMessages.IO_STREAM_INVALID_POS, n);
            }
            self.setAbsPos(n);
            return n;
        }
    }

    @GenerateInline(value=false)
    static abstract class CheckIsSeekabledNode
    extends Node {
        CheckIsSeekabledNode() {
        }

        public abstract boolean execute(VirtualFrame var1, PBuffered var2);

        @Specialization
        static boolean isSeekable(VirtualFrame frame, PBuffered self, @Bind Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod, @Cached PyObjectIsTrueNode isTrue, @Cached PRaiseNode raiseNode) {
            assert (self.isOK());
            Object res = callMethod.execute((Frame)frame, inliningTarget, self.getRaw(), IONodes.T_SEEKABLE, new Object[0]);
            if (!isTrue.execute((Frame)frame, res)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.IOUnsupportedOperation, ErrorMessages.FILE_OR_STREAM_IS_NOT_SEEKABLE);
            }
            return true;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class IsClosedNode
    extends PNodeWithContext {
        IsClosedNode() {
        }

        public abstract boolean execute(VirtualFrame var1, Node var2, PBuffered var3);

        @Specialization(guards={"self.getBuffer() == null"})
        static boolean isClosed(PBuffered self) {
            return true;
        }

        @Specialization(guards={"self.getBuffer() != null", "self.isFastClosedChecks()"})
        static boolean isClosedFileIO(PBuffered self) {
            return self.getFileIORaw().isClosed();
        }

        @Specialization(guards={"self.getBuffer() != null", "!self.isFastClosedChecks()"})
        static boolean isClosedBuffered(VirtualFrame frame, Node inliningTarget, PBuffered self, @Cached PyObjectGetAttr getAttr, @Cached PyObjectIsTrueNode isTrue) {
            Object res = getAttr.execute((Frame)frame, inliningTarget, self.getRaw(), IONodes.T_CLOSED);
            return isTrue.execute((Frame)frame, res);
        }
    }

    static abstract class CheckIsClosedNode
    extends PNodeWithContext {
        private final TruffleString method;
        private final TruffleString messageFmt;

        public CheckIsClosedNode(TruffleString method) {
            this.method = method;
            this.messageFmt = IONodes.T_WRITE.equalsUncached((AbstractTruffleString)method, PythonUtils.TS_ENCODING) ? ErrorMessages.S_TO_CLOSED_FILE : ErrorMessages.S_OF_CLOSED_FILE;
        }

        public abstract boolean execute(VirtualFrame var1, PBuffered var2);

        @Specialization
        boolean isClosedBuffered(VirtualFrame frame, PBuffered self, @Bind Node inliningTarget, @Cached PRaiseNode raiseNode, @Cached IsClosedNode isClosedNode) {
            if (isClosedNode.execute(frame, inliningTarget, self)) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, this.messageFmt, this.method);
            }
            return false;
        }
    }
}

