/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.pegparser.tokenizer;

import java.util.Arrays;

public final class CodePoints {
    public static final CodePoints EMPTY = new CodePoints(new int[0], 0, 0);
    private final int[] buffer;
    private final int offset;
    private final int length;

    private CodePoints(int[] buffer, int offset, int length) {
        assert (0 <= offset && 0 <= length && offset + length <= buffer.length);
        this.buffer = buffer;
        this.offset = offset;
        this.length = length;
    }

    public static CodePoints fromBuffer(int[] buffer, int offset, int length) {
        return length == 0 ? EMPTY : new CodePoints(buffer, offset, length);
    }

    public static CodePoints fromJavaString(String s) {
        int cp;
        Builder b = new Builder(s.length());
        for (int o = 0; o < s.length(); o += Character.charCount(cp)) {
            cp = s.codePointAt(o);
            b.appendCodePoint(cp);
        }
        return b.build();
    }

    public int[] getBuffer() {
        return this.buffer;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    public String toJavaString() {
        return new String(this.buffer, this.offset, this.length);
    }

    private int indexOf(int cp) {
        for (int i = 0; i < this.length; ++i) {
            if (this.buffer[this.offset + i] != cp) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(int cp) {
        return this.indexOf(cp) >= 0;
    }

    public int get(int index) {
        assert (index >= 0 && index < this.length);
        return this.buffer[this.offset + index];
    }

    public CodePoints withLength(int l) {
        assert (0 <= l && l <= this.length);
        return l == this.length ? this : new CodePoints(this.buffer, this.offset, l);
    }

    public static final class Builder {
        private int[] buffer;
        private int length;

        public Builder(int initialCapacity) {
            this.buffer = new int[initialCapacity];
        }

        public void appendCodePoint(int codePoint) {
            this.ensureCanAppend(1);
            this.buffer[this.length++] = codePoint;
        }

        public void appendCodePoints(int[] srcBuffer, int srcOffset, int srcLength) {
            this.ensureCanAppend(srcLength);
            System.arraycopy(srcBuffer, srcOffset, this.buffer, this.length, srcLength);
            this.length += srcLength;
        }

        public void appendCodePoints(CodePoints cp) {
            this.appendCodePoints(cp.buffer, cp.offset, cp.length);
        }

        public CodePoints build() {
            return this.length == 0 ? EMPTY : new CodePoints(this.buffer, 0, this.length);
        }

        private void ensureCanAppend(int delta) {
            int newLength = this.length + delta;
            if (newLength > this.buffer.length) {
                newLength = Math.max(newLength, this.buffer.length + this.buffer.length >> 1);
                this.buffer = Arrays.copyOf(this.buffer, newLength);
            }
        }
    }
}

