// Generated by gmmproc 2.76.0 -- DO NOT MODIFY!
#ifndef _ATKMM_RELATION_H
#define _ATKMM_RELATION_H

#include <atkmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <glibmm/object.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
using AtkRelation = struct _AtkRelation;
using AtkRelationClass = struct _AtkRelationClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Atk
{ class ATKMM_API Relation_Class; } // namespace Atk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Atk
{


class ATKMM_API Object;

/** An Atk::Relation describes a relation between an object and one or more other objects.
 * The actual relations that an object has with other objects are defined as an Atk::RelationSet,
 * which is a set of Atk::Relations.
 */

class ATKMM_API Relation : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = Relation;
  using CppClassType = Relation_Class;
  using BaseObjectType = AtkRelation;
  using BaseClassType = AtkRelationClass;

  // noncopyable
  Relation(const Relation&) = delete;
  Relation& operator=(const Relation&) = delete;

private:  friend class Relation_Class;
  static CppClassType relation_class_;

protected:
  explicit Relation(const Glib::ConstructParams& construct_params);
  explicit Relation(AtkRelation* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  Relation(Relation&& src) noexcept;
  Relation& operator=(Relation&& src) noexcept;

  ~Relation() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  AtkRelation*       gobj()       { return reinterpret_cast<AtkRelation*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const AtkRelation* gobj() const { return reinterpret_cast<AtkRelation*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  AtkRelation* gobj_copy();

private:


public:
  /** @addtogroup atkmmEnums atkmm Enums and Flags */

  /** 
   *  @var Type NONE
   * Not used, represens "no relationship" or an error condition.
   * 
   *  @var Type CONTROLLED_BY
   * Indicates an object controlled by one or more target objects.
   * 
   *  @var Type CONTROLLER_FOR
   * Indicates an object is an controller for one or more target objects.
   * 
   *  @var Type LABEL_FOR
   * Indicates an object is a label for one or more target objects.
   * 
   *  @var Type LABELLED_BY
   * Indicates an object is labelled by one or more target objects.
   * 
   *  @var Type MEMBER_OF
   * Indicates an object is a member of a group of one or more target objects.
   * 
   *  @var Type NODE_CHILD_OF
   * Indicates an object is a cell in a treetable which is displayed because a cell in the same column is expanded and identifies that cell.
   * 
   *  @var Type FLOWS_TO
   * Indicates that the object has content that flows logically to another
   * AtkObject in a sequential way, (for instance text-flow).
   * 
   *  @var Type FLOWS_FROM
   * Indicates that the object has content that flows logically from
   * another AtkObject in a sequential way, (for instance text-flow).
   * 
   *  @var Type SUBWINDOW_OF
   * Indicates a subwindow attached to a component but otherwise has no connection in  the UI heirarchy to that component.
   * 
   *  @var Type EMBEDS
   * Indicates that the object visually embeds 
   * another object's content, i.e. this object's content flows around 
   * another's content.
   * 
   *  @var Type EMBEDDED_BY
   * Reciprocal of Atk::Relation::Type::EMBEDS, indicates that
   * this object's content is visualy embedded in another object.
   * 
   *  @var Type POPUP_FOR
   * Indicates that an object is a popup for another object.
   * 
   *  @var Type PARENT_WINDOW_OF
   * Indicates that an object is a parent window of another object.
   * 
   *  @var Type DESCRIBED_BY
   * Reciprocal of Atk::Relation::Type::DESCRIPTION_FOR. Indicates that one
   * or more target objects provide descriptive information about this object. This relation
   * type is most appropriate for information that is not essential as its presentation may
   * be user-configurable and/or limited to an on-demand mechanism such as an assistive
   * technology command. For brief, essential information such as can be found in a widget's
   * on-screen label, use Atk::Relation::Type::LABELLED_BY. For an on-screen error message, use
   * Atk::Relation::Type::ERROR_MESSAGE. For lengthy extended descriptive information contained in
   * an on-screen object, consider using Atk::Relation::Type::DETAILS as assistive technologies may
   * provide a means for the user to navigate to objects containing detailed descriptions so
   * that their content can be more closely reviewed.
   * 
   *  @var Type DESCRIPTION_FOR
   * Reciprocal of Atk::Relation::Type::DESCRIBED_BY. Indicates that this
   * object provides descriptive information about the target object(s). See also
   * Atk::Relation::Type::DETAILS_FOR and Atk::Relation::Type::ERROR_FOR.
   * 
   *  @var Type NODE_PARENT_OF
   * Indicates an object is a cell in a treetable and is expanded to display other cells in the same column.
   * 
   *  @var Type DETAILS
   * Reciprocal of Atk::Relation::Type::DETAILS_FOR. Indicates that this object
   * has a detailed or extended description, the contents of which can be found in the target
   * object(s). This relation type is most appropriate for information that is sufficiently
   * lengthy as to make navigation to the container of that information desirable. For less
   * verbose information suitable for announcement only, see Atk::Relation::Type::DESCRIBED_BY. If
   * the detailed information describes an error condition, Atk::Relation::Type::ERROR_FOR should be
   * used instead. @a Since: ATK-2.26.
   * 
   *  @var Type DETAILS_FOR
   * Reciprocal of Atk::Relation::Type::DETAILS. Indicates that this object
   * provides a detailed or extended description about the target object(s). See also
   * Atk::Relation::Type::DESCRIPTION_FOR and Atk::Relation::Type::ERROR_FOR. @a Since: ATK-2.26.
   * 
   *  @var Type ERROR_MESSAGE
   * Reciprocal of Atk::Relation::Type::ERROR_FOR. Indicates that this object
   * has one or more errors, the nature of which is described in the contents of the target
   * object(s). Objects that have this relation type should also contain Atk::StateType::INVALID_ENTRY
   * in their Atk::StateSet. @a Since: ATK-2.26.
   * 
   *  @var Type ERROR_FOR
   * Reciprocal of Atk::Relation::Type::ERROR_MESSAGE. Indicates that this object
   * contains an error message describing an invalid condition in the target object(s). @a Since:
   * ATK_2.26.
   * 
   *  @var Type LAST_DEFINED
   * Not used, this value indicates the end of the enumeration.
   * 
   *  @enum Type
   * 
   * Describes the type of the relation
   *
   * @ingroup atkmmEnums
   */
  enum class Type
  {
    NONE,
    CONTROLLED_BY,
    CONTROLLER_FOR,
    LABEL_FOR,
    LABELLED_BY,
    MEMBER_OF,
    NODE_CHILD_OF,
    FLOWS_TO,
    FLOWS_FROM,
    SUBWINDOW_OF,
    EMBEDS,
    EMBEDDED_BY,
    POPUP_FOR,
    PARENT_WINDOW_OF,
    DESCRIBED_BY,
    DESCRIPTION_FOR,
    NODE_PARENT_OF,
    DETAILS,
    DETAILS_FOR,
    ERROR_MESSAGE,
    ERROR_FOR,
    LAST_DEFINED
  };


protected:
  explicit Relation(const std::vector<Glib::RefPtr<Atk::Object>>& targets,
                    Relation::Type relationship);

public:
  
  static Glib::RefPtr<Relation> create(const std::vector<Glib::RefPtr<Atk::Object>>& targets, Type relationship =  Type::NONE);


  /** Gets the type of @a relation
   * 
   * @return The type of @a relation.
   */
  Type get_relation_type() const;

  std::vector<Glib::RefPtr<Atk::Object>> get_target();
  std::vector<Glib::RefPtr<const Atk::Object>> get_target() const;
  
  
  /** Adds the specified AtkObject to the target for the relation, if it is
   * not already present.  See also Atk::Object::add_relationship().
   * 
   * 
   * @newin{1,9}
   * 
   * @param target An Atk::Object.
   */
  void add_target(const Glib::RefPtr<Atk::Object>& target);


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Atk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class ATKMM_API Value<Atk::Relation::Type> : public Glib::Value_Enum<Atk::Relation::Type>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Atk::Relation
   */
  ATKMM_API
  Glib::RefPtr<Atk::Relation> wrap(AtkRelation* object, bool take_copy = false);
}


#endif /* _ATKMM_RELATION_H */

