// Generated by gmmproc 2.76.0 -- DO NOT MODIFY!
#ifndef _ATKMM_STATESET_H
#define _ATKMM_STATESET_H

#include <atkmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* $Id: stateset.hg,v 1.3 2004/01/02 09:56:43 murrayc Exp $ */

/* Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <glibmm/object.h>
#include <glibmm/value.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
using AtkStateSet = struct _AtkStateSet;
using AtkStateSetClass = struct _AtkStateSetClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Atk
{ class ATKMM_API StateSet_Class; } // namespace Atk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Atk
{


/** @addtogroup atkmmEnums atkmm Enums and Flags */

/** 
 *  @var StateType INVALID
 * Indicates an invalid state - probably an error condition.
 * 
 *  @var StateType ACTIVE
 * Indicates a window is currently the active window, or an object is the active subelement within a container or table. ATK_STATE_ACTIVE should not be used for objects which have ATK_STATE_FOCUSABLE or ATK_STATE_SELECTABLE: Those objects should use ATK_STATE_FOCUSED and ATK_STATE_SELECTED respectively. ATK_STATE_ACTIVE is a means to indicate that an object which is not focusable and not selectable is the currently-active item within its parent container.
 * 
 *  @var StateType ARMED
 * Indicates that the object is 'armed', i.e. will be activated by if a pointer button-release event occurs within its bounds.  Buttons often enter this state when a pointer click occurs within their bounds, as a precursor to activation. ATK_STATE_ARMED has been deprecated since ATK-2.16 and should not be used in newly-written code.
 * 
 *  @var StateType BUSY
 * Indicates the current object is busy, i.e. onscreen representation is in the process of changing, or the object is temporarily unavailable for interaction due to activity already in progress.  This state may be used by implementors of Document to indicate that content loading is underway.  It also may indicate other 'pending' conditions; clients may wish to interrogate this object when the ATK_STATE_BUSY flag is removed.
 * 
 *  @var StateType CHECKED
 * Indicates this object is currently checked, for instance a checkbox is 'non-empty'.
 * 
 *  @var StateType DEFUNCT
 * Indicates that this object no longer has a valid backing widget (for instance, if its peer object has been destroyed).
 * 
 *  @var StateType EDITABLE
 * Indicates that this object can contain text, and that the
 * user can change the textual contents of this object by editing those contents
 * directly. For an object which is expected to be editable due to its type, but
 * which cannot be edited due to the application or platform preventing the user
 * from doing so, that object's Atk::StateSet should lack ATK_STATE_EDITABLE and
 * should contain ATK_STATE_READ_ONLY.
 * 
 *  @var StateType ENABLED
 * Indicates that this object is enabled, i.e. that it currently reflects some application state. Objects that are "greyed out" may lack this state, and may lack the STATE_SENSITIVE if direct user interaction cannot cause them to acquire STATE_ENABLED. See also: ATK_STATE_SENSITIVE.
 * 
 *  @var StateType EXPANDABLE
 * Indicates this object allows progressive disclosure of its children.
 * 
 *  @var StateType EXPANDED
 * Indicates this object its expanded - see ATK_STATE_EXPANDABLE above.
 * 
 *  @var StateType FOCUSABLE
 * Indicates this object can accept keyboard focus, which means all events resulting from typing on the keyboard will normally be passed to it when it has focus.
 * 
 *  @var StateType FOCUSED
 * Indicates this object currently has the keyboard focus.
 * 
 *  @var StateType HORIZONTAL
 * Indicates the orientation of this object is horizontal; used, for instance, by objects of ATK_ROLE_SCROLL_BAR.  For objects where vertical/horizontal orientation is especially meaningful.
 * 
 *  @var StateType ICONIFIED
 * Indicates this object is minimized and is represented only by an icon.
 * 
 *  @var StateType MODAL
 * Indicates something must be done with this object before the user can interact with an object in a different window.
 * 
 *  @var StateType MULTI_LINE
 * Indicates this (text) object can contain multiple lines of text.
 * 
 *  @var StateType MULTISELECTABLE
 * Indicates this object allows more than one of its children to be selected at the same time, or in the case of text objects, that the object supports non-contiguous text selections.
 * 
 *  @var StateType OPAQUE
 * Indicates this object paints every pixel within its rectangular region.
 * 
 *  @var StateType PRESSED
 * Indicates this object is currently pressed.
 * 
 *  @var StateType RESIZABLE
 * Indicates the size of this object is not fixed.
 * 
 *  @var StateType SELECTABLE
 * Indicates this object is the child of an object that allows its children to be selected and that this child is one of those children that can be selected.
 * 
 *  @var StateType SELECTED
 * Indicates this object is the child of an object that allows its children to be selected and that this child is one of those children that has been selected.
 * 
 *  @var StateType SENSITIVE
 * Indicates this object is sensitive, e.g. to user interaction. 
 * STATE_SENSITIVE usually accompanies STATE_ENABLED for user-actionable controls,
 * but may be found in the absence of STATE_ENABLED if the current visible state of the 
 * control is "disconnected" from the application state.  In such cases, direct user interaction
 * can often result in the object gaining STATE_SENSITIVE, for instance if a user makes 
 * an explicit selection using an object whose current state is ambiguous or undefined.
 *  @a see STATE_ENABLED, STATE_INDETERMINATE.
 * 
 *  @var StateType SHOWING
 * Indicates this object, the object's parent, the object's parent's parent, and so on, 
 * are all 'shown' to the end-user, i.e. subject to "exposure" if blocking or obscuring objects do not interpose
 * between this object and the top of the window stack.
 * 
 *  @var StateType SINGLE_LINE
 * Indicates this (text) object can contain only a single line of text.
 * 
 *  @var StateType STALE
 * Indicates that the information returned for this object may no longer be
 * synchronized with the application state.  This is implied if the object has STATE_TRANSIENT,
 * and can also occur towards the end of the object peer's lifecycle. It can also be used to indicate that 
 * the index associated with this object has changed since the user accessed the object (in lieu of
 * "index-in-parent-changed" events).
 * 
 *  @var StateType TRANSIENT
 * Indicates this object is transient, i.e. a snapshot which may not emit events when its
 * state changes.  Data from objects with ATK_STATE_TRANSIENT should not be cached, since there may be no
 * notification given when the cached data becomes obsolete.
 * 
 *  @var StateType VERTICAL
 * Indicates the orientation of this object is vertical.
 * 
 *  @var StateType VISIBLE
 * Indicates this object is visible, e.g. has been explicitly marked for exposure to the user.
 * **note**: Atk::StateType::VISIBLE is no guarantee that the object is actually unobscured on the screen, only
 * that it is 'potentially' visible, barring obstruction, being scrolled or clipped out of the 
 * field of view, or having an ancestor container that has not yet made visible.
 * A widget is potentially onscreen if it has both Atk::StateType::VISIBLE and Atk::StateType::SHOWING.
 * The absence of Atk::StateType::VISIBLE and Atk::StateType::SHOWING is semantically equivalent to saying
 * that an object is 'hidden'.  See also Atk::StateType::TRUNCATED, which applies if an object with
 * Atk::StateType::VISIBLE and Atk::StateType::SHOWING set lies within a viewport which means that its
 * contents are clipped, e.g. a truncated spreadsheet cell or
 * an image within a scrolling viewport.  Mostly useful for screen-review and magnification
 * algorithms.
 * 
 *  @var StateType MANAGES_DESCENDANTS
 * Indicates that "active-descendant-changed" event
 * is sent when children become 'active' (i.e. are selected or navigated to onscreen).
 * Used to prevent need to enumerate all children in very large containers, like tables.
 * The presence of STATE_MANAGES_DESCENDANTS is an indication to the client.
 * that the children should not, and need not, be enumerated by the client.
 * Objects implementing this state are expected to provide relevant state
 * notifications to listening clients, for instance notifications of visibility
 * changes and activation of their contained child objects, without the client 
 * having previously requested references to those children.
 * 
 *  @var StateType INDETERMINATE
 * Indicates that the value, or some other quantifiable
 * property, of this AtkObject cannot be fully determined. In the case of a large
 * data set in which the total number of items in that set is unknown (e.g. 1 of
 * 999+), implementors should expose the currently-known set size (999) along
 * with this state. In the case of a check box, this state should be used to
 * indicate that the check box is a tri-state check box which is currently
 * neither checked nor unchecked.
 * 
 *  @var StateType TRUNCATED
 * Indicates that an object is truncated, e.g. a text value in a speradsheet cell.
 * 
 *  @var StateType REQUIRED
 * Indicates that explicit user interaction with an object is required by the user interface, e.g. a required field in a "web-form" interface.
 * 
 *  @var StateType INVALID_ENTRY
 * Indicates that the object has encountered an error condition due to failure of input validation. For instance, a form control may acquire this state in response to invalid or malformed user input.
 * 
 *  @var StateType SUPPORTS_AUTOCOMPLETION
 * Indicates that the object in question implements some form of ¨typeahead¨ or 
 * pre-selection behavior whereby entering the first character of one or more sub-elements
 * causes those elements to scroll into view or become selected.  Subsequent character input
 * may narrow the selection further as long as one or more sub-elements match the string.
 * This state is normally only useful and encountered on objects that implement Selection.
 * In some cases the typeahead behavior may result in full or partial ¨completion¨ of 
 * the data in the input field, in which case these input events may trigger text-changed
 * events from the AtkText interface.  This state supplants @a ATK_ROLE_AUTOCOMPLETE.
 * 
 *  @var StateType SELECTABLE_TEXT
 * Indicates that the object in question supports text selection. It should only be exposed on objects which implement the Text interface, in order to distinguish this state from @a ATK_STATE_SELECTABLE, which infers that the object in question is a selectable child of an object which implements Selection. While similar, text selection and subelement selection are distinct operations.
 * 
 *  @var StateType DEFAULT
 * Indicates that the object is the "default" active component, i.e. the object which is activated by an end-user press of the "Enter" or "Return" key.  Typically a "close" or "submit" button.
 * 
 *  @var StateType ANIMATED
 * Indicates that the object changes its appearance dynamically as an inherent part of its presentation.  This state may come and go if an object is only temporarily animated on the way to a 'final' onscreen presentation.
 * **note**: some applications, notably content viewers, may not be able to detect
 * all kinds of animated content.  Therefore the absence of this state should not
 * be taken as definitive evidence that the object's visual representation is
 * static; this state is advisory.
 * 
 *  @var StateType VISITED
 * Indicates that the object (typically a hyperlink) has already been 'activated', and/or its backing data has already been downloaded, rendered, or otherwise "visited".
 * 
 *  @var StateType CHECKABLE
 * Indicates this object has the potential to be
 * checked, such as a checkbox or toggle-able table cell. @a Since:
 * ATK-2.12.
 * 
 *  @var StateType HAS_POPUP
 * Indicates that the object has a popup context
 * menu or sub-level menu which may or may not be showing. This means
 * that activation renders conditional content.  Note that ordinary
 * tooltips are not considered popups in this context. @a Since: ATK-2.12.
 * 
 *  @var StateType HAS_TOOLTIP
 * Indicates this object has a tooltip. @a Since: ATK-2.16.
 * 
 *  @var StateType READ_ONLY
 * Indicates that a widget which is ENABLED and SENSITIVE
 * has a value which can be read, but not modified, by the user. Note that this
 * state should only be applied to widget types whose value is normally directly
 * user modifiable, such as check boxes, radio buttons, spin buttons, text input
 * fields, and combo boxes, as a means to convey that the expected interaction
 * with that widget is not possible. When the expected interaction with a
 * widget does not include modification by the user, as is the case with
 * labels and containers, ATK_STATE_READ_ONLY should not be applied. See also
 * ATK_STATE_EDITABLE. @a Since: ATK-2-16.
 * 
 *  @var StateType LAST_DEFINED
 * Not a valid state, used for finding end of enumeration.
 * 
 *  @enum StateType
 * 
 * The possible types of states of an object
 *
 * @ingroup atkmmEnums
 */
enum class StateType
{
  INVALID,
  ACTIVE,
  ARMED,
  BUSY,
  CHECKED,
  DEFUNCT,
  EDITABLE,
  ENABLED,
  EXPANDABLE,
  EXPANDED,
  FOCUSABLE,
  FOCUSED,
  HORIZONTAL,
  ICONIFIED,
  MODAL,
  MULTI_LINE,
  MULTISELECTABLE,
  OPAQUE,
  PRESSED,
  RESIZABLE,
  SELECTABLE,
  SELECTED,
  SENSITIVE,
  SHOWING,
  SINGLE_LINE,
  STALE,
  TRANSIENT,
  VERTICAL,
  VISIBLE,
  MANAGES_DESCENDANTS,
  INDETERMINATE,
  TRUNCATED,
  REQUIRED,
  INVALID_ENTRY,
  SUPPORTS_AUTOCOMPLETION,
  SELECTABLE_TEXT,
  DEFAULT,
  ANIMATED,
  VISITED,
  CHECKABLE,
  HAS_POPUP,
  HAS_TOOLTIP,
  READ_ONLY,
  LAST_DEFINED
};


} // namespace Atk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class ATKMM_API Value<Atk::StateType> : public Glib::Value_Enum<Atk::StateType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Atk
{


/** An AtkStateSet determines a component's state set.
 * It is composed of a set of Atk::States.
 */

class ATKMM_API StateSet : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = StateSet;
  using CppClassType = StateSet_Class;
  using BaseObjectType = AtkStateSet;
  using BaseClassType = AtkStateSetClass;

  // noncopyable
  StateSet(const StateSet&) = delete;
  StateSet& operator=(const StateSet&) = delete;

private:  friend class StateSet_Class;
  static CppClassType stateset_class_;

protected:
  explicit StateSet(const Glib::ConstructParams& construct_params);
  explicit StateSet(AtkStateSet* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  StateSet(StateSet&& src) noexcept;
  StateSet& operator=(StateSet&& src) noexcept;

  ~StateSet() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  AtkStateSet*       gobj()       { return reinterpret_cast<AtkStateSet*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const AtkStateSet* gobj() const { return reinterpret_cast<AtkStateSet*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  AtkStateSet* gobj_copy();

private:


protected:
  StateSet();
  
public:
  
  static Glib::RefPtr<StateSet> create();


  /** Checks whether the state set is empty, i.e.\ has no states set.
   * 
   * @return <tt>true</tt> if @a set has no states set, otherwise <tt>false</tt>.
   */
  bool is_empty() const;

  //Note that we use Atk::StateType instead of StateType, because there is a Gtk::StateType too, and Doxygen gets confused.
  
  /** Adds the state of the specified type to the state set if it is not already
   * present.
   * 
   * Note that because an Atk::StateSet is a read-only object, this method should
   * be used to add a state to a newly-created set which will then be returned by
   * #atk_object_ref_state_set. It should not be used to modify the existing state
   * of an object. See also #atk_object_notify_state_change.
   * 
   * @param type An Atk::StateType.
   * @return <tt>true</tt> if  the state for @a type is not already in @a set.
   */
  bool add_state(Atk::StateType type);
  void add_states(const std::vector<Atk::StateType>& types);
  
  
  /** Removes all states from the state set.
   */
  void clear_states();
  
  /** Checks whether the state for the specified type is in the specified set.
   * 
   * @param type An Atk::StateType.
   * @return <tt>true</tt> if @a type is the state type is in @a set.
   */
  bool contains_state(Atk::StateType type);
   bool contains_states(const std::vector<Atk::StateType>& types) const;
  
  
  /** Removes the state for the specified type from the state set.
   * 
   * Note that because an Atk::StateSet is a read-only object, this method should
   * be used to remove a state to a newly-created set which will then be returned
   * by #atk_object_ref_state_set. It should not be used to modify the existing
   * state of an object. See also #atk_object_notify_state_change.
   * 
   * @param type An Atk::Type.
   * @return <tt>true</tt> if @a type was the state type is in @a set.
   */
  bool remove_state(Atk::StateType type);
  
  /** Constructs the intersection of the two sets, returning <tt>nullptr</tt> if the
   * intersection is empty.
   * 
   * @param compare_set Another Atk::StateSet.
   * @return A new Atk::StateSet which is the intersection of
   * the two sets.
   */
  Glib::RefPtr<StateSet> and_sets(const Glib::RefPtr<StateSet>& compare_set);
  
  /** Constructs the union of the two sets.
   * 
   * @param compare_set Another Atk::StateSet.
   * @return A new Atk::StateSet which is
   * the union of the two sets, returning <tt>nullptr</tt> is empty.
   */
  Glib::RefPtr<StateSet> or_sets(const Glib::RefPtr<StateSet>& compare_set);
  
  /** Constructs the exclusive-or of the two sets, returning <tt>nullptr</tt> is empty.
   * The set returned by this operation contains the states in exactly
   * one of the two sets.
   * 
   * @param compare_set Another Atk::StateSet.
   * @return A new Atk::StateSet which contains the states
   * which are in exactly one of the two sets.
   */
  Glib::RefPtr<StateSet> xor_sets(const Glib::RefPtr<StateSet>& compare_set);


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Atk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Atk::StateSet
   */
  ATKMM_API
  Glib::RefPtr<Atk::StateSet> wrap(AtkStateSet* object, bool take_copy = false);
}


#endif /* _ATKMM_STATESET_H */

