/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.selector;

import java.awt.BorderLayout;
import java.awt.Component;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import org.protege.editor.core.ui.util.CheckTable;
import org.protege.editor.core.ui.util.CheckTableModel;
import org.protege.editor.core.ui.util.Icons;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.renderer.OWLCellRenderer;
import org.semanticweb.owlapi.model.OWLOntology;

public class OWLOntologySelectorPanel2
extends JComponent {
    private CheckTable<OWLOntology> list;

    public OWLOntologySelectorPanel2(OWLEditorKit eKit, Set<OWLOntology> onts) {
        this.setLayout(new BorderLayout(6, 12));
        ArrayList<OWLOntology> ontologies = new ArrayList<OWLOntology>(onts);
        ArrayList<URI> files = new ArrayList<URI>(ontologies.size());
        ArrayList<Boolean> dirty = new ArrayList<Boolean>(ontologies.size());
        for (OWLOntology ont : ontologies) {
            files.add(eKit.getModelManager().getOntologyPhysicalURI(ont));
            dirty.add(eKit.getModelManager().getDirtyOntologies().contains(ont));
        }
        this.list = new CheckTable("Ontologies");
        this.list.getModel().setData(ontologies, true);
        this.list.checkAll(true);
        CheckTableModel model = this.list.getModel();
        model.addColumn((Object)"Location", files.toArray());
        model.addColumn((Object)"", dirty.toArray());
        this.list.setDefaultRenderer((TableCellRenderer)new OWLCellRenderer(eKit){

            @Override
            protected String getRendering(Object object) {
                if (object instanceof Boolean) {
                    if (((Boolean)object).booleanValue()) {
                        return "Local changes have been made";
                    }
                    return "";
                }
                return super.getRendering(object);
            }

            @Override
            protected Icon getIcon(Object object) {
                if (object instanceof Boolean && ((Boolean)object).booleanValue()) {
                    return Icons.getIcon((String)"warning.png");
                }
                return super.getIcon(object);
            }
        });
        JScrollPane scroller = new JScrollPane((Component)this.list);
        this.add((Component)scroller, "Center");
    }

    public Set<OWLOntology> getSelectedOntologies() {
        return new HashSet<OWLOntology>(this.list.getFilteredValues());
    }

    public void checkAll(boolean checkAll) {
        this.list.checkAll(checkAll);
    }
}

