# Comparison with Pry

👋 IRB is on a mission to match feature parity with Pry. This document is here to help us track the similarities and differences between the two.

Feel free to chip in and update this table - we appreciate your help!

| Feature                   | Pry                                                                                                                  | IRB                                                                            | Note                                                                                                         |
| ------------------------- | -------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------ |
| Supported Rubies          | `>= 2.0`                                                                                                             | `>= 2.7`                                                                       |                                                                                                              |
| Source code browsing      | `show-source`                                                                                                        | `show_source`                                                                  | IRB's `show_source` can't display C source. See [#664](https://github.com/ruby/irb/issues/664)               |
| Document browsing         | `ri`                                                                                                                 | `show_doc`                                                                     |                                                                                                              |
| Live help system          | `help` or `command_name --help`                                                                                      | `help`                                                                         | IRB doesn't support detailed descriptions for individual commands yet                                        |
| Open methods in editors   | `edit`                                                                                                               | `edit`                                                                         |                                                                                                              |
| Syntax highlighting       | Yes                                                                                                                  | Yes                                                                            |                                                                                                              |
| Command shell integration | Yes                                                                                                                  | No                                                                             | Currently, there's no plan to support such features in IRB                                                   |
| Navigation                | - `cd object` to enter `object` <br/> - `cd ..` to leave the current object <br/> - `nesting` to list nesting levels | - `pushws object` <br/> - `popws` <br/> - `workspaces`                         | We plan to refine IRB's commands in the future                                                               |
| Runtime invocation        | `binding.pry`                                                                                                        | `binding.irb`                                                                  |                                                                                                              |
| Command system            | Yes                                                                                                                  | No                                                                             | Planned in [#513](https://github.com/ruby/irb/issues/513) and [#588](https://github.com/ruby/irb/issues/588) |
| Input history             | [Comprehensive support](https://github.com/pry/pry/wiki/History)                                                     | Supports retrieving previous input and the `history` command                   | The `history` command doesn't support as many flags yet, but contributions are welcome.                      |
| Pager support             | Command output and return value                                                                                      | Command output and return value                                                |                                                                                                              |
| Debugger integration      | With `byebug` through [pry-byebug](https://github.com/deivid-rodriguez/pry-byebug) gem                               | Supports [`irb:rdbg`](https://github.com/ruby/irb#debugging-with-irb) sessions |                                                                                                              |
| Rails console             | Through [`pry-rails`](https://github.com/pry/pry-rails) gem                                                          | Rails' default                                                                 | Rails console with IRB doesn't have commands like `show-routes` or `show-models`                             |
