/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui;

import java.util.concurrent.TimeUnit;
import javafx.collections.ObservableList;
import mediathek.config.Daten;
import mediathek.daten.DatenFilm;
import mediathek.daten.ListeFilme;
import mediathek.javafx.filterpanel.FilmActionPanel;
import mediathek.tool.Filter;
import mediathek.tool.models.TModelFilm;
import mediathek.tool.table.MVTable;

public class GuiFilmeModelHelper {
    private final FilmActionPanel fap;
    private final Daten daten;
    private final MVTable tabelle;
    private final TModelFilm filmModel;
    private final ListeFilme listeFilme;
    private boolean searchThroughDescriptions;
    private boolean nurNeue;
    private boolean nurUt;
    private boolean showOnlyHd;
    private boolean kGesehen;
    private boolean keineAbos;
    private boolean showOnlyLivestreams;
    private boolean dontShowTrailers;
    private boolean dontShowGebaerdensprache;
    private boolean dontShowAudioVersions;
    private long maxLength;
    private String[] arrIrgendwo;
    private long minLengthInSeconds;
    private long maxLengthInSeconds;

    public GuiFilmeModelHelper(FilmActionPanel fap, Daten daten, MVTable tabelle) {
        this.fap = fap;
        this.daten = daten;
        this.tabelle = tabelle;
        this.filmModel = new TModelFilm();
        this.listeFilme = daten.getListeFilmeNachBlackList();
    }

    private String getFilterThema() {
        String filterThema = (String)this.fap.themaBox.getSelectionModel().getSelectedItem();
        if (filterThema == null) {
            filterThema = "";
        }
        return filterThema;
    }

    private String[] evaluateThemaTitel() {
        String[] arrThemaTitel;
        String filterThemaTitel = this.fap.roSearchStringProperty.getValueSafe();
        if (Filter.isPattern(filterThemaTitel)) {
            arrThemaTitel = new String[]{filterThemaTitel};
        } else {
            arrThemaTitel = filterThemaTitel.split(",");
            for (int i = 0; i < arrThemaTitel.length; ++i) {
                arrThemaTitel[i] = arrThemaTitel[i].trim().toLowerCase();
            }
        }
        return arrThemaTitel;
    }

    private boolean noFiltersAreSet() {
        boolean ret = false;
        if (!(!this.fap.senderList.getCheckModel().isEmpty() || !this.getFilterThema().isEmpty() || !this.fap.roSearchStringProperty.getValueSafe().isEmpty() || (int)this.fap.filmLengthSlider.getLowValue() != 0 || (int)this.fap.filmLengthSlider.getHighValue() != 110 || this.fap.dontShowAbos.getValue().booleanValue() || this.fap.showUnseenOnly.getValue().booleanValue() || this.fap.showOnlyHd.getValue().booleanValue() || this.fap.showSubtitlesOnly.getValue().booleanValue() || this.fap.showLivestreamsOnly.getValue().booleanValue() || this.fap.showNewOnly.getValue().booleanValue() || this.fap.dontShowTrailers.getValue().booleanValue() || this.fap.dontShowSignLanguage.getValue().booleanValue() || this.fap.dontShowAudioVersions.getValue().booleanValue())) {
            ret = true;
        }
        return ret;
    }

    private void updateFilterVars() {
        this.nurNeue = this.fap.showNewOnly.getValue();
        this.nurUt = this.fap.showSubtitlesOnly.getValue();
        this.showOnlyHd = this.fap.showOnlyHd.getValue();
        this.kGesehen = this.fap.showUnseenOnly.getValue();
        this.keineAbos = this.fap.dontShowAbos.getValue();
        this.showOnlyLivestreams = this.fap.showLivestreamsOnly.getValue();
        this.dontShowTrailers = this.fap.dontShowTrailers.getValue();
        this.dontShowGebaerdensprache = this.fap.dontShowSignLanguage.getValue();
        this.dontShowAudioVersions = this.fap.dontShowAudioVersions.getValue();
        this.searchThroughDescriptions = this.fap.searchThroughDescription.getValue();
        this.arrIrgendwo = this.evaluateThemaTitel();
    }

    private void calculateFilmLengthSliderValues() {
        long minLength = (long)this.fap.filmLengthSlider.getLowValue();
        this.maxLength = (long)this.fap.filmLengthSlider.getHighValue();
        this.minLengthInSeconds = TimeUnit.SECONDS.convert(minLength, TimeUnit.MINUTES);
        this.maxLengthInSeconds = TimeUnit.SECONDS.convert(this.maxLength, TimeUnit.MINUTES);
    }

    private void performTableFiltering() {
        this.updateFilterVars();
        this.calculateFilmLengthSliderValues();
        String filterThema = this.getFilterThema();
        boolean searchFieldEmpty = this.arrIrgendwo.length == 0;
        ObservableList selectedSenders = this.fap.senderList.getCheckModel().getCheckedItems();
        for (DatenFilm film : this.listeFilme) {
            long filmLength;
            if (!selectedSenders.isEmpty() && !selectedSenders.contains(film.getSender()) || (filmLength = film.getFilmLength()) < this.minLengthInSeconds || this.maxLength < 110L && filmLength > this.maxLengthInSeconds || this.nurNeue && !film.isNew() || this.showOnlyLivestreams && !film.isLivestream() || this.showOnlyHd && !film.isHighQuality() || this.nurUt && !film.hasSubtitle() || this.keineAbos && !film.getAboName().isEmpty() || this.kGesehen && this.daten.getSeenHistoryController().urlPruefen(film.getUrl()) || this.dontShowTrailers && film.isTrailerTeaser() || this.dontShowGebaerdensprache && film.isSignLanguage() || this.dontShowAudioVersions && film.isAudioVersion() || !filterThema.isEmpty() && !film.getThema().equalsIgnoreCase(filterThema)) continue;
            if (searchFieldEmpty) {
                this.addFilmToTableModel(film);
                continue;
            }
            if (!this.finalStageFiltering(film)) continue;
            this.addFilmToTableModel(film);
        }
    }

    private boolean finalStageFiltering(DatenFilm film) {
        boolean result = this.searchThroughDescriptions && !film.getDescription().isEmpty() ? this.searchEntriesWithDescription(film) : this.searchEntries(film);
        return result;
    }

    private boolean searchEntries(DatenFilm film) {
        boolean result = false;
        if (Filter.pruefen(this.arrIrgendwo, film.getThema()) || Filter.pruefen(this.arrIrgendwo, film.getTitle())) {
            result = true;
        }
        return result;
    }

    private boolean searchEntriesWithDescription(DatenFilm film) {
        boolean result = false;
        if (Filter.pruefen(this.arrIrgendwo, film.getDescription()) || this.searchEntries(film)) {
            result = true;
        }
        return result;
    }

    private void fillTableModel() {
        if (this.noFiltersAreSet()) {
            this.addAllFilmsToTableModel();
        } else {
            this.performTableFiltering();
        }
        this.tabelle.setModel(this.filmModel);
    }

    public void prepareTableModel() {
        if (!this.listeFilme.isEmpty()) {
            this.fillTableModel();
        }
        this.tabelle.setModel(this.filmModel);
    }

    private void addAllFilmsToTableModel() {
        if (!this.listeFilme.isEmpty()) {
            for (DatenFilm film : this.listeFilme) {
                this.addFilmToTableModel(film);
            }
        }
    }

    private void addFilmToTableModel(DatenFilm film) {
        Object[] object = new Object[]{film};
        this.filmModel.addRow(object);
    }
}

