/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.actions.import_actions;

import java.awt.event.ActionEvent;
import java.io.File;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.stage.FileChooser;
import javax.swing.AbstractAction;
import mediathek.controller.IoXmlLesen;
import mediathek.gui.actions.import_actions.ImportSettingsAlert;
import mediathek.tool.javafx.FXErrorDialog;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public class ImportOldReplacementListAction
extends AbstractAction {
    public ImportOldReplacementListAction() {
        this.putValue("Name", "Alte Ersetzungstabelle...");
        this.putValue("ShortDescription", "Erm\u00f6glicht den Import der Ersetzungstabelle aus einer alten Konfigurationsdatei.");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Platform.runLater(() -> {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Konfigurationsdatei \u00f6ffnen");
            File selectedFile = fileChooser.showOpenDialog(null);
            if (selectedFile != null) {
                try {
                    IoXmlLesen configReader = new IoXmlLesen();
                    ImmutableTriple<Integer, Integer, Integer> result = configReader.importAboBlacklist(selectedFile.getAbsolutePath(), false, false, true);
                    ImportSettingsAlert alert = new ImportSettingsAlert(Alert.AlertType.INFORMATION);
                    String text = "Es wurden " + result.right + " Eintr\u00e4ge importiert.";
                    alert.setContentText(text);
                    alert.showAndWait();
                }
                catch (Exception ex) {
                    FXErrorDialog.showErrorDialog("MediathekView", "Fehler beim Importieren der Ersetzungstabelle", "Es trat ein Fehler beim Import der Ersetzungstabelle auf.\nSollte dies h\u00e4ufiger auftreten kontaktieren Sie bitte das Entwicklerteam.", ex);
                }
            } else {
                ImportSettingsAlert alert = new ImportSettingsAlert(Alert.AlertType.WARNING);
                alert.setContentText("Der Import der Ersetzungstabelle wurde abgebrochen.");
                alert.showAndWait();
            }
        });
    }
}

