/*
 * Decompiled with CFR 0.152.
 */
package mediathek.javafx.filterpanel;

import impl.org.controlsfx.autocompletion.SuggestionProvider;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javafx.animation.PauseTransition;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javafx.scene.Scene;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Tooltip;
import javafx.util.Duration;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import mediathek.config.Daten;
import mediathek.filmeSuchen.ListenerFilmeLaden;
import mediathek.filmeSuchen.ListenerFilmeLadenEvent;
import mediathek.gui.actions.ManageAboAction;
import mediathek.gui.messages.FilmListWriteStartEvent;
import mediathek.gui.messages.FilmListWriteStopEvent;
import mediathek.javafx.filterpanel.CommonViewSettingsPane;
import mediathek.javafx.filterpanel.FXFilmToolBar;
import mediathek.javafx.filterpanel.SwingFilterDialog;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.Filter;
import mediathek.tool.GermanStringSorter;
import net.engio.mbassy.listener.Handler;
import org.apache.commons.configuration2.Configuration;
import org.controlsfx.control.CheckListView;
import org.controlsfx.control.RangeSlider;
import org.controlsfx.control.textfield.TextFields;

public class FilmActionPanel {
    private static final String PROMPT_THEMA_TITEL = "Thema/Titel";
    private static final String PROMPT_IRGENDWO = "Thema/Titel/Beschreibung";
    private final Daten daten;
    private final Configuration config = ApplicationConfiguration.getConfiguration();
    private final PauseTransition pause2 = new PauseTransition(Duration.millis(150.0));
    private final PauseTransition pause3 = new PauseTransition(Duration.millis(500.0));
    private final Tooltip themaTitelTooltip = new Tooltip("Thema/Titel durchsuchen");
    private final Tooltip irgendwoTooltip = new Tooltip("Thema/Titel/Beschreibung durchsuchen");
    private final Tooltip TOOLTIP_SEARCH_IRGENDWO = new Tooltip("Suche in Beschreibung aktiviert");
    private final Tooltip TOOLTIP_SEARCH_REGULAR = new Tooltip("Suche in Beschreibung deaktiviert");
    public ReadOnlyStringWrapper roSearchStringProperty = new ReadOnlyStringWrapper();
    public BooleanProperty showOnlyHd;
    public BooleanProperty showSubtitlesOnly;
    public BooleanProperty showNewOnly;
    public BooleanProperty showUnseenOnly;
    public BooleanProperty showLivestreamsOnly;
    public BooleanProperty dontShowAbos;
    public BooleanProperty dontShowTrailers;
    public BooleanProperty dontShowSignLanguage;
    public BooleanProperty dontShowAudioVersions;
    public BooleanProperty searchThroughDescription;
    public ReadOnlyObjectProperty<String> zeitraumProperty;
    public ComboBox<String> themaBox;
    public RangeSlider filmLengthSlider;
    public CheckListView<String> senderList;
    public JDialog filterDialog;
    public ManageAboAction manageAboAction;
    private SuggestionProvider<String> themaSuggestionProvider;
    private FXFilmToolBar toolBar = new FXFilmToolBar();
    private CommonViewSettingsPane viewSettingsPane;

    public FilmActionPanel(Daten daten) {
        this.daten = daten;
        this.setupViewSettingsPane();
        this.setupDeleteFilterButton();
        SwingUtilities.invokeLater(() -> {
            this.filterDialog = new SwingFilterDialog((Frame)MediathekGui.ui(), this.viewSettingsPane);
        });
        this.restoreConfigSettings();
        this.setupConfigListeners();
        daten.getMessageBus().subscribe(this);
    }

    private void setupDeleteFilterButton() {
        this.viewSettingsPane.btnDeleteFilterSettings.setOnAction(e -> {
            this.showOnlyHd.setValue(false);
            this.showSubtitlesOnly.setValue(false);
            this.showNewOnly.setValue(false);
            this.showLivestreamsOnly.setValue(false);
            this.showUnseenOnly.setValue(false);
            this.dontShowAbos.setValue(false);
            this.dontShowSignLanguage.setValue(false);
            this.dontShowTrailers.setValue(false);
            this.dontShowAudioVersions.setValue(false);
            this.senderList.getCheckModel().clearChecks();
            this.themaBox.getSelectionModel().select("");
            this.filmLengthSlider.lowValueProperty().setValue(0);
            this.filmLengthSlider.highValueProperty().setValue(110);
            this.viewSettingsPane.zeitraumSpinner.getValueFactory().setValue("\u221e");
        });
    }

    private void setupViewSettingsPane() {
        this.viewSettingsPane = new CommonViewSettingsPane();
        this.showOnlyHd = this.viewSettingsPane.cbShowOnlyHd.selectedProperty();
        this.showSubtitlesOnly = this.viewSettingsPane.cbShowSubtitlesOnly.selectedProperty();
        this.showNewOnly = this.viewSettingsPane.cbShowNewOnly.selectedProperty();
        this.showLivestreamsOnly = this.viewSettingsPane.cbShowOnlyLivestreams.selectedProperty();
        this.showUnseenOnly = this.viewSettingsPane.cbShowUnseenOnly.selectedProperty();
        this.dontShowAbos = this.viewSettingsPane.cbDontShowAbos.selectedProperty();
        this.dontShowSignLanguage = this.viewSettingsPane.cbDontShowGebaerdensprache.selectedProperty();
        this.dontShowTrailers = this.viewSettingsPane.cbDontShowTrailers.selectedProperty();
        this.dontShowAudioVersions = this.viewSettingsPane.cbDontShowAudioVersions.selectedProperty();
        this.senderList = this.viewSettingsPane.senderBoxNode.senderBox;
        this.viewSettingsPane.senderBoxNode.pauseTransition.setOnFinished(e -> this.updateThemaBox());
        this.themaBox = this.viewSettingsPane._themaComboBox;
        this.themaSuggestionProvider = SuggestionProvider.create(this.themaBox.getItems());
        TextFields.bindAutoCompletion(this.themaBox.getEditor(), this.themaSuggestionProvider);
        this.filmLengthSlider = this.viewSettingsPane.filmLengthSliderNode._filmLengthSlider;
        this.zeitraumProperty = this.viewSettingsPane.zeitraumSpinner.valueProperty();
    }

    private void restoreConfigSettings() {
        this.showOnlyHd.set(this.config.getBoolean("filter.show.hd_only", false));
        this.showSubtitlesOnly.set(this.config.getBoolean("filter.show.subtitles_only", false));
        this.showNewOnly.set(this.config.getBoolean("filter.show.new_only", false));
        this.showUnseenOnly.set(this.config.getBoolean("filter.show.unseen_only", false));
        this.showLivestreamsOnly.set(this.config.getBoolean("filter.show.livestreams_only", false));
        this.dontShowAbos.set(this.config.getBoolean("filter.dont_show.abos", false));
        this.dontShowTrailers.set(this.config.getBoolean("filter.dont_show.trailers", false));
        this.dontShowSignLanguage.set(this.config.getBoolean("filter.dont_show.sign_language", false));
        this.dontShowAudioVersions.set(this.config.getBoolean("filter.dont_show.audio_versions", false));
        try {
            this.filmLengthSlider.lowValueProperty().set(this.config.getDouble("filter.film_length.min"));
            this.filmLengthSlider.highValueProperty().set(this.config.getDouble("filter.film_length.max"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.viewSettingsPane.zeitraumSpinner.getValueFactory().setValue(this.config.getString("filter.zeitraum", "\u221e"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setupConfigListeners() {
        this.showOnlyHd.addListener((observable2, oldValue, newValue) -> this.config.setProperty("filter.show.hd_only", newValue));
        this.showSubtitlesOnly.addListener((observable2, oldValue, newValue) -> this.config.setProperty("filter.show.subtitles_only", newValue));
        this.showNewOnly.addListener((observable2, oldValue, newValue) -> this.config.setProperty("filter.show.new_only", newValue));
        this.showUnseenOnly.addListener((observable2, oldValue, newValue) -> this.config.setProperty("filter.show.unseen_only", newValue));
        this.showLivestreamsOnly.addListener((observable2, oldValue, newValue) -> this.config.setProperty("filter.show.livestreams_only", newValue));
        this.dontShowAbos.addListener((observable2, oldValue, newValue) -> this.config.setProperty("filter.dont_show.abos", newValue));
        this.dontShowTrailers.addListener((observable2, oldValue, newValue) -> this.config.setProperty("filter.dont_show.trailers", newValue));
        this.dontShowSignLanguage.addListener((observable2, oldValue, newValue) -> this.config.setProperty("filter.dont_show.sign_language", newValue));
        this.dontShowAudioVersions.addListener((observable2, oldValue, newValue) -> this.config.setProperty("filter.dont_show.audio_versions", newValue));
        this.filmLengthSlider.lowValueProperty().addListener((observable2, oldValue, newValue) -> this.config.setProperty("filter.film_length.min", newValue));
        this.filmLengthSlider.highValueProperty().addListener((observable2, oldValue, newValue) -> this.config.setProperty("filter.film_length.max", newValue));
        this.viewSettingsPane.zeitraumSpinner.valueProperty().addListener((observable2, oldValue, newValue) -> this.config.setProperty("filter.zeitraum", newValue));
    }

    @Handler
    private void handleFilmlistWriteStartEvent(FilmListWriteStartEvent e) {
        Platform.runLater(() -> this.toolBar.btnDownloadFilmList.setDisable(true));
    }

    @Handler
    private void handleFilmlistWriteStopEvent(FilmListWriteStopEvent e) {
        Platform.runLater(() -> this.toolBar.btnDownloadFilmList.setDisable(false));
    }

    private void checkPatternValidity() {
        this.toolBar.jfxSearchField.setStyle("-fx-text-fill: red");
        String text = this.toolBar.jfxSearchField.getText();
        if (Filter.isPattern(text)) {
            if (Filter.makePattern(text) == null) {
                this.toolBar.jfxSearchField.setStyle("-fx-text-fill: red");
            } else {
                this.toolBar.jfxSearchField.setStyle("-fx-text-fill: blue");
            }
        } else {
            this.toolBar.jfxSearchField.setStyle("-fx-text-fill: black");
        }
    }

    private void setupSearchField() {
        this.toolBar.jfxSearchField.setTooltip(this.themaTitelTooltip);
        this.toolBar.jfxSearchField.setPromptText(PROMPT_THEMA_TITEL);
        StringProperty textProperty = this.toolBar.jfxSearchField.textProperty();
        this.pause2.setOnFinished(evt -> this.checkPatternValidity());
        textProperty.addListener((observable2, oldValue, newValue) -> this.pause2.playFromStart());
        this.pause3.setOnFinished(evt -> SwingUtilities.invokeLater(() -> MediathekGui.ui().tabFilme.filterFilmAction.actionPerformed(null)));
        textProperty.addListener((observable2, oldValue, newValue) -> this.pause3.playFromStart());
        this.roSearchStringProperty.bind(textProperty);
    }

    private void setupSearchThroughDescriptionButton() {
        boolean enabled = ApplicationConfiguration.getConfiguration().getBoolean("searchfield.film.search_through_description", false);
        this.toolBar.btnSearchThroughDescription.setSelected(enabled);
        if (enabled) {
            this.setupForIrgendwoSearch();
        } else {
            this.setupForRegularSearch();
        }
        this.toolBar.btnSearchThroughDescription.setOnAction(e -> {
            boolean bSearchThroughDescription = this.toolBar.btnSearchThroughDescription.isSelected();
            ApplicationConfiguration.getConfiguration().setProperty("searchfield.film.search_through_description", bSearchThroughDescription);
            if (bSearchThroughDescription) {
                this.setupForIrgendwoSearch();
            } else {
                this.setupForRegularSearch();
            }
        });
        this.searchThroughDescription = this.toolBar.btnSearchThroughDescription.selectedProperty();
    }

    private void setupForRegularSearch() {
        this.toolBar.jfxSearchField.setTooltip(this.themaTitelTooltip);
        this.toolBar.jfxSearchField.setPromptText(PROMPT_THEMA_TITEL);
        this.toolBar.btnSearchThroughDescription.setTooltip(this.TOOLTIP_SEARCH_REGULAR);
    }

    private void setupForIrgendwoSearch() {
        this.toolBar.jfxSearchField.setTooltip(this.irgendwoTooltip);
        this.toolBar.jfxSearchField.setPromptText(PROMPT_IRGENDWO);
        this.toolBar.btnSearchThroughDescription.setTooltip(this.TOOLTIP_SEARCH_IRGENDWO);
    }

    public void updateThemaBox() {
        ObservableList<String> items = this.themaBox.getItems();
        items.clear();
        items.add("");
        ArrayList<String> finalList = new ArrayList<String>();
        ObservableList selectedSenders = this.senderList.getCheckModel().getCheckedItems();
        if (selectedSenders.isEmpty()) {
            List<String> lst = this.daten.getListeFilmeNachBlackList().getThemen("");
            finalList.addAll(lst);
            lst.clear();
        } else {
            for (String sender : selectedSenders) {
                List<String> lst = this.daten.getListeFilmeNachBlackList().getThemen(sender);
                finalList.addAll(lst);
                lst.clear();
            }
        }
        items.addAll(finalList.stream().distinct().sorted(GermanStringSorter.getInstance()).collect(Collectors.toList()));
        finalList.clear();
        this.themaSuggestionProvider.clearSuggestions();
        this.themaSuggestionProvider.addPossibleSuggestions((Collection<String>)items);
        this.themaBox.getSelectionModel().select(0);
    }

    private void setupToolBar() {
        this.toolBar = new FXFilmToolBar();
        this.toolBar.btnDownloadFilmList.setOnAction(e -> SwingUtilities.invokeLater(() -> MediathekGui.ui().performFilmListLoadOperation(false)));
        this.toolBar.btnFilmInfo.setOnAction(e -> SwingUtilities.invokeLater(MediathekGui.ui().getFilmInfoDialog()::showInfo));
        this.toolBar.btnPlay.setOnAction(evt -> SwingUtilities.invokeLater(() -> MediathekGui.ui().tabFilme.playAction.actionPerformed(null)));
        this.toolBar.btnRecord.setOnAction(e -> SwingUtilities.invokeLater(() -> MediathekGui.ui().tabFilme.saveFilmAction.actionPerformed(null)));
        this.toolBar.btnManageAbos.setOnAction(e -> SwingUtilities.invokeLater(() -> {
            if (this.manageAboAction.isEnabled()) {
                this.manageAboAction.actionPerformed(null);
            }
        }));
        this.toolBar.btnShowFilter.setOnAction(e -> SwingUtilities.invokeLater(() -> {
            if (this.filterDialog != null && !this.filterDialog.isVisible()) {
                this.filterDialog.setVisible(true);
            }
        }));
    }

    public Scene getFilmActionPanelScene() {
        this.setupToolBar();
        this.setupSearchField();
        this.setupSearchThroughDescriptionButton();
        this.daten.getFilmeLaden().addAdListener(new ListenerFilmeLaden(){

            @Override
            public void start(ListenerFilmeLadenEvent event) {
                Platform.runLater(() -> FilmActionPanel.this.toolBar.setDisable(true));
            }

            @Override
            public void fertig(ListenerFilmeLadenEvent event) {
                Platform.runLater(() -> FilmActionPanel.this.toolBar.setDisable(false));
            }
        });
        return new Scene(this.toolBar);
    }
}

