/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.BlackholeSink;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.InputStreamSource;
import okio.OutputStreamSink;
import okio.RealBufferedSink;
import okio.RealBufferedSource;
import okio.Sink;
import okio.SocketAsyncTimeout;
import okio.Source;
import okio.Timeout;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\r\u0010\u0005\u001a\u00020\u0006H\u0007\u00a2\u0006\u0002\b\u0007\u001a\n\u0010\b\u001a\u00020\u0006*\u00020\t\u001a\n\u0010\n\u001a\u00020\u000b*\u00020\u0006\u001a\n\u0010\n\u001a\u00020\f*\u00020\r\u001a\u0016\u0010\u000e\u001a\u00020\u0006*\u00020\t2\b\b\u0002\u0010\u000f\u001a\u00020\u0001H\u0007\u001a\n\u0010\u000e\u001a\u00020\u0006*\u00020\u0010\u001a\n\u0010\u000e\u001a\u00020\u0006*\u00020\u0011\u001a%\u0010\u000e\u001a\u00020\u0006*\u00020\u00122\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0014\"\u00020\u0015H\u0007\u00a2\u0006\u0002\u0010\u0016\u001a\n\u0010\u0017\u001a\u00020\r*\u00020\t\u001a\n\u0010\u0017\u001a\u00020\r*\u00020\u0018\u001a\n\u0010\u0017\u001a\u00020\r*\u00020\u0011\u001a%\u0010\u0017\u001a\u00020\r*\u00020\u00122\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0014\"\u00020\u0015H\u0007\u00a2\u0006\u0002\u0010\u0019\"\u001c\u0010\u0000\u001a\u00020\u0001*\u00060\u0002j\u0002`\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0004\u00a8\u0006\u001a"}, d2={"isAndroidGetsocknameError", "", "Ljava/lang/AssertionError;", "Lkotlin/AssertionError;", "(Ljava/lang/AssertionError;)Z", "blackholeSink", "Lokio/Sink;", "blackhole", "appendingSink", "Ljava/io/File;", "buffer", "Lokio/BufferedSink;", "Lokio/BufferedSource;", "Lokio/Source;", "sink", "append", "Ljava/io/OutputStream;", "Ljava/net/Socket;", "Ljava/nio/file/Path;", "options", "", "Ljava/nio/file/OpenOption;", "(Ljava/nio/file/Path;[Ljava/nio/file/OpenOption;)Lokio/Sink;", "source", "Ljava/io/InputStream;", "(Ljava/nio/file/Path;[Ljava/nio/file/OpenOption;)Lokio/Source;", "jvm"})
@JvmName(name="Okio")
public final class Okio {
    @NotNull
    public static final BufferedSource buffer(@NotNull Source $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return new RealBufferedSource($receiver);
    }

    @NotNull
    public static final BufferedSink buffer(@NotNull Sink $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return new RealBufferedSink($receiver);
    }

    @NotNull
    public static final Sink sink(@NotNull OutputStream $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return new OutputStreamSink($receiver, new Timeout());
    }

    @NotNull
    public static final Source source(@NotNull InputStream $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return new InputStreamSource($receiver, new Timeout());
    }

    @JvmName(name="blackhole")
    @NotNull
    public static final Sink blackhole() {
        return new BlackholeSink();
    }

    @NotNull
    public static final Sink sink(@NotNull Socket $receiver) throws IOException {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        SocketAsyncTimeout timeout2 = new SocketAsyncTimeout($receiver);
        OutputStream outputStream2 = $receiver.getOutputStream();
        Intrinsics.checkExpressionValueIsNotNull(outputStream2, "getOutputStream()");
        OutputStreamSink sink2 = new OutputStreamSink(outputStream2, timeout2);
        return timeout2.sink(sink2);
    }

    @NotNull
    public static final Source source(@NotNull Socket $receiver) throws IOException {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        SocketAsyncTimeout timeout2 = new SocketAsyncTimeout($receiver);
        InputStream inputStream2 = $receiver.getInputStream();
        Intrinsics.checkExpressionValueIsNotNull(inputStream2, "getInputStream()");
        InputStreamSource source2 = new InputStreamSource(inputStream2, timeout2);
        return timeout2.source(source2);
    }

    @JvmOverloads
    @NotNull
    public static final Sink sink(@NotNull File $receiver, boolean append) throws FileNotFoundException {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return Okio.sink(new FileOutputStream($receiver, append));
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ Sink sink$default(File file, boolean bl, int n, Object object) throws FileNotFoundException {
        if ((n & 1) != 0) {
            bl = false;
        }
        return Okio.sink(file, bl);
    }

    @JvmOverloads
    @NotNull
    public static final Sink sink(@NotNull File $receiver) throws FileNotFoundException {
        return Okio.sink$default($receiver, false, 1, null);
    }

    @NotNull
    public static final Sink appendingSink(@NotNull File $receiver) throws FileNotFoundException {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return Okio.sink(new FileOutputStream($receiver, true));
    }

    @NotNull
    public static final Source source(@NotNull File $receiver) throws FileNotFoundException {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        File file = $receiver;
        return Okio.source(new FileInputStream(file));
    }

    @IgnoreJRERequirement
    @NotNull
    public static final Sink sink(@NotNull Path $receiver, OpenOption ... options) throws IOException {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(options, "options");
        OutputStream outputStream2 = Files.newOutputStream($receiver, Arrays.copyOf(options, options.length));
        Intrinsics.checkExpressionValueIsNotNull(outputStream2, "Files.newOutputStream(this, *options)");
        return Okio.sink(outputStream2);
    }

    @IgnoreJRERequirement
    @NotNull
    public static final Source source(@NotNull Path $receiver, OpenOption ... options) throws IOException {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(options, "options");
        InputStream inputStream2 = Files.newInputStream($receiver, Arrays.copyOf(options, options.length));
        Intrinsics.checkExpressionValueIsNotNull(inputStream2, "Files.newInputStream(this, *options)");
        return Okio.source(inputStream2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isAndroidGetsocknameError(@NotNull AssertionError $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if (((Throwable)((Object)$receiver)).getCause() == null) return false;
        String string = ((Throwable)((Object)$receiver)).getMessage();
        if (string == null) return false;
        boolean bl = StringsKt.contains$default((CharSequence)string, "getsockname failed", false, 2, null);
        if (!bl) return false;
        return true;
    }
}

