/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.Variant;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.RecordStructure;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HtmlParameter;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.model.DefaultNameValuePair;
import org.zaproxy.zap.model.NameValuePair;
import org.zaproxy.zap.model.StructuralNode;
import org.zaproxy.zap.model.StructuralSiteNode;
import org.zaproxy.zap.model.StructuralTableNode;

public class SessionStructure {
    public static final String ROOT = "Root";
    public static final String DATA_DRIVEN_NODE_PREFIX = "\u00ab";
    public static final String DATA_DRIVEN_NODE_POSTFIX = "\u00bb";
    public static final String DATA_DRIVEN_NODE_REGEX = "(.+?)";
    private static final String MULTIPART_FORM_DATA = "multipart/form-data";
    private static final String MULTIPART_FORM_DATA_DISPLAY = "(multipart/form-data)";
    private static final Logger log = LogManager.getLogger(SessionStructure.class);

    @Deprecated
    public static StructuralNode addPath(Session session, HistoryReference ref, HttpMessage msg) {
        return SessionStructure.addPath(session, ref, msg, false);
    }

    public static StructuralNode addPath(Model model, HistoryReference ref, HttpMessage msg) {
        return SessionStructure.addPath(model, ref, msg, false);
    }

    @Deprecated
    public static StructuralNode addPath(Session session, HistoryReference ref, HttpMessage msg, boolean newOnly) {
        return SessionStructure.addPath(Model.getSingleton(), ref, msg, newOnly);
    }

    public static StructuralNode addPath(Model model, HistoryReference ref, HttpMessage msg, boolean newOnly) {
        Session session = model.getSession();
        if (!Constant.isLowMemoryOptionSet()) {
            SiteNode node = session.getSiteTree().addPath(ref, msg, newOnly);
            if (node != null) {
                return new StructuralSiteNode(node);
            }
            return null;
        }
        try {
            List<String> paths = SessionStructure.getTreePath(model, msg);
            String host = SessionStructure.getHostName(msg.getRequestHeader().getURI());
            RecordStructure rs = SessionStructure.addStructure(model, host, msg, paths, paths.size(), ref.getHistoryId(), newOnly);
            if (rs != null) {
                return new StructuralTableNode(rs);
            }
            return null;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static List<String> getTreePath(Model model, URI uri) throws URIException {
        return model.getSession().getUrlParamParser(uri.toString()).getTreePath(uri);
    }

    public static List<String> getTreePath(Model model, HttpMessage msg) throws URIException {
        for (Variant variant : model.getVariantFactory().createSiteModifyingVariants()) {
            try {
                List<String> path = variant.getTreePath(msg);
                if (path == null) continue;
                return path;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        URI uri = msg.getRequestHeader().getURI();
        return model.getSession().getUrlParamParser(uri.toString()).getTreePath(msg);
    }

    public static StructuralNode find(Model model, HttpMessage msg) throws DatabaseException, URIException {
        if (!Constant.isLowMemoryOptionSet()) {
            SiteNode node = model.getSession().getSiteTree().findNode(msg);
            if (node == null) {
                return null;
            }
            return new StructuralSiteNode(node);
        }
        String nodeName = SessionStructure.getNodeName(model, msg);
        RecordStructure rs = model.getDb().getTableStructure().find(model.getSession().getSessionId(), nodeName, msg.getRequestHeader().getMethod());
        if (rs == null) {
            return null;
        }
        return new StructuralTableNode(rs);
    }

    @Deprecated
    public static StructuralNode find(long sessionId, URI uri, String method, String postData) throws DatabaseException, URIException {
        Model model = Model.getSingleton();
        if (!Constant.isLowMemoryOptionSet()) {
            SiteNode node = model.getSession().getSiteTree().findNode(uri, method, postData);
            if (node == null) {
                return null;
            }
            return new StructuralSiteNode(node);
        }
        String nodeName = SessionStructure.getNodeName(model, uri, method, postData);
        RecordStructure rs = model.getDb().getTableStructure().find(sessionId, nodeName, method);
        if (rs == null) {
            return null;
        }
        return new StructuralTableNode(rs);
    }

    public static StructuralNode find(Model model, URI uri, String method, String postData) throws DatabaseException, URIException {
        Session session = model.getSession();
        if (!Constant.isLowMemoryOptionSet()) {
            SiteNode node = session.getSiteTree().findNode(uri, method, postData);
            if (node == null) {
                return null;
            }
            return new StructuralSiteNode(node);
        }
        String nodeName = SessionStructure.getNodeName(model, uri, method, postData);
        RecordStructure rs = model.getDb().getTableStructure().find(session.getSessionId(), nodeName, method);
        if (rs == null) {
            return null;
        }
        return new StructuralTableNode(rs);
    }

    private static String getNodeName(Model model, URI uri, String method, String postData) throws URIException {
        String params;
        Session session = model.getSession();
        List<String> paths = SessionStructure.getTreePath(model, uri);
        String host = SessionStructure.getHostName(uri);
        String nodeUrl = SessionStructure.pathsToUrl(host, paths, paths.size());
        if (postData != null && (params = SessionStructure.getParams(session, uri, postData)).length() > 0) {
            nodeUrl = nodeUrl + " " + params;
        }
        return nodeUrl;
    }

    private static String getNodeName(Session session, String host, HttpMessage msg, List<String> paths, int size) throws URIException {
        String params;
        String nodeUrl = SessionStructure.pathsToUrl(host, paths, size);
        if (msg != null && (params = SessionStructure.getParams(session, msg)).length() > 0) {
            nodeUrl = nodeUrl + " " + params;
        }
        return nodeUrl;
    }

    @Deprecated
    public static String getNodeName(HttpMessage msg) throws URIException {
        return SessionStructure.getNodeName(Model.getSingleton(), msg);
    }

    public static String getNodeName(Model model, HttpMessage msg) throws URIException {
        return SessionStructure.getNodeName(model, msg.getRequestHeader().getURI(), msg.getRequestHeader().getMethod(), msg.getRequestBody().toString());
    }

    public static String getLeafName(Model model, String nodeName, HttpMessage msg) {
        for (Variant variant : model.getVariantFactory().createSiteModifyingVariants()) {
            try {
                String name = variant.getLeafName(nodeName, msg);
                if (name == null) continue;
                return name;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        List<org.parosproxy.paros.core.scanner.NameValuePair> params = SessionStructure.convertNVP(model.getSession().getParameters(msg, HtmlParameter.Type.url), 1);
        if (msg.getRequestHeader().getMethod().equalsIgnoreCase("POST")) {
            params.addAll(SessionStructure.convertNVP(model.getSession().getParameters(msg, HtmlParameter.Type.form), 2));
        }
        return SessionStructure.getLeafName(nodeName, msg, params);
    }

    public static String getLeafName(Model model, String nodeName, URI uri, String method, String postData) throws HttpMalformedHeaderException {
        Objects.requireNonNull(uri);
        Objects.requireNonNull(method);
        HttpMessage msg = new HttpMessage(uri);
        msg.getRequestHeader().setMethod(method);
        if (method.equalsIgnoreCase("POST")) {
            msg.getRequestBody().setBody(postData);
            msg.getRequestHeader().setContentLength(msg.getRequestBody().length());
        }
        return SessionStructure.getLeafName(model, nodeName, msg);
    }

    public static String getLeafName(String nodeName, HttpMessage message, List<org.parosproxy.paros.core.scanner.NameValuePair> params) {
        String method = message.getRequestHeader().getMethod();
        StringBuilder sb = new StringBuilder();
        sb.append(method);
        sb.append(":");
        sb.append(nodeName);
        if (method.equalsIgnoreCase("POST")) {
            sb.append(SessionStructure.getQueryParamString(SessionStructure.convertParosNVP(params, 1), true));
            String contentType = message.getRequestHeader().getHeader("Content-Type");
            if (contentType != null && contentType.startsWith(MULTIPART_FORM_DATA)) {
                sb.append(MULTIPART_FORM_DATA_DISPLAY);
            } else {
                sb.append(SessionStructure.getQueryParamString(SessionStructure.convertParosNVP(params, 2), false));
            }
        } else {
            sb.append(SessionStructure.getQueryParamString(SessionStructure.convertParosNVP(params, 1), false));
            sb.append(SessionStructure.getQueryParamString(SessionStructure.convertParosNVP(params, 2), false));
        }
        return sb.toString();
    }

    private static List<org.parosproxy.paros.core.scanner.NameValuePair> convertNVP(List<NameValuePair> nvpList, int type) {
        ArrayList<org.parosproxy.paros.core.scanner.NameValuePair> params = new ArrayList<org.parosproxy.paros.core.scanner.NameValuePair>();
        for (NameValuePair nvp : nvpList) {
            params.add(new org.parosproxy.paros.core.scanner.NameValuePair(type, nvp.getName(), nvp.getValue(), -1));
        }
        return params;
    }

    private static List<NameValuePair> convertParosNVP(List<org.parosproxy.paros.core.scanner.NameValuePair> nvpList, int type) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        for (org.parosproxy.paros.core.scanner.NameValuePair nvp : nvpList) {
            if (nvp.getType() != type) continue;
            params.add(new DefaultNameValuePair(nvp.getName(), nvp.getValue()));
        }
        return params;
    }

    public static String regexEscape(String str) {
        String chrsToEscape = ".*+?^=!${}()|[]\\";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (chrsToEscape.indexOf(c) >= 0) {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String getRegexName(StructuralNode sn, boolean incParams) {
        return SessionStructure.getSpecifiedName(sn, incParams, true);
    }

    public static String getCleanRelativeName(StructuralNode sn, boolean incParams) {
        return SessionStructure.getSpecifiedName(sn, incParams, false);
    }

    private static String getSpecifiedName(StructuralNode sn, boolean incParams, boolean dataDrivenNodesAsRegex) {
        int colonIndex;
        int queryIndex;
        String name = sn.getName();
        if (sn.isDataDriven() && dataDrivenNodesAsRegex) {
            return DATA_DRIVEN_NODE_REGEX;
        }
        int bracketIndex = name.lastIndexOf("(");
        if (bracketIndex >= 0) {
            name = name.substring(0, bracketIndex);
        }
        if ((queryIndex = name.indexOf("?")) >= 0) {
            if (incParams) {
                String params = name.substring(queryIndex);
                name = name.substring(0, queryIndex) + SessionStructure.regexEscape(params);
            } else {
                name = name.substring(0, queryIndex);
            }
        }
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        try {
            if (sn.getURI().getPath() == null || sn.getURI().getPath().length() == 1) {
                return name;
            }
        }
        catch (URIException params) {
            // empty catch block
        }
        int slashIndex = name.lastIndexOf(47);
        if (slashIndex >= 0) {
            name = name.substring(slashIndex + 1);
        }
        if (sn.isLeaf() && (colonIndex = name.indexOf(":")) > 0) {
            name = name.substring(colonIndex + 1);
        }
        return name;
    }

    public static String getRegexPattern(StructuralNode sn) throws DatabaseException {
        return SessionStructure.getRegexPattern(sn, true);
    }

    public static String getRegexPattern(StructuralNode sn, boolean incChildren) throws DatabaseException {
        boolean incParams;
        StringBuilder sb = new StringBuilder();
        boolean bl = incParams = sn.isLeaf() || !incChildren;
        while (!sn.isRoot()) {
            if (sb.length() > 0) {
                sb.insert(0, "/");
            }
            sb.insert(0, SessionStructure.getRegexName(sn, incParams));
            sn = sn.getParent();
            incParams = false;
        }
        if (incChildren) {
            sb.append(".*");
        }
        return sb.toString();
    }

    private static RecordStructure addStructure(Model model, String host, HttpMessage msg, List<String> paths, int size, int historyId, boolean newOnly) throws DatabaseException, URIException {
        RecordStructure msgRs;
        Session session = model.getSession();
        String nodeName = SessionStructure.getNodeName(session, host, msg, paths, size);
        String parentName = SessionStructure.pathsToUrl(host, paths, size - 1);
        String url = "";
        if (msg != null) {
            url = msg.getRequestHeader().getURI().toString();
            String params = SessionStructure.getParams(session, msg);
            if (params.length() > 0) {
                nodeName = nodeName + " " + params;
            }
        }
        String method = "GET";
        if (msg != null) {
            method = msg.getRequestHeader().getMethod();
        }
        if ((msgRs = model.getDb().getTableStructure().find(session.getSessionId(), nodeName, method)) == null) {
            long parentId = -1L;
            if (!nodeName.equals(ROOT)) {
                HttpMessage tmpMsg = null;
                int parentHistoryId = -1;
                if (!parentName.equals(ROOT)) {
                    tmpMsg = SessionStructure.getTempHttpMessage(session, parentName, msg);
                    parentHistoryId = tmpMsg.getHistoryRef().getHistoryId();
                }
                RecordStructure parentRs = SessionStructure.addStructure(model, host, tmpMsg, paths, size - 1, parentHistoryId, false);
                parentId = parentRs.getStructureId();
            }
            msgRs = model.getDb().getTableStructure().insert(session.getSessionId(), parentId, historyId, nodeName, url, method);
        } else if (newOnly) {
            return null;
        }
        return msgRs;
    }

    private static HttpMessage getTempHttpMessage(Session session, String url, HttpMessage base) {
        try {
            HttpMessage newMsg = base.cloneRequest();
            URI uri = new URI(url, false);
            newMsg.getRequestHeader().setURI(uri);
            newMsg.getRequestHeader().setMethod("GET");
            newMsg.getRequestBody().setBody("");
            newMsg.getRequestHeader().setHeader("Content-Type", null);
            newMsg.getRequestHeader().setHeader("Content-Length", null);
            HistoryReference historyRef = new HistoryReference(session, 0, newMsg);
            newMsg.setHistoryRef(historyRef);
            return newMsg;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static String pathsToUrl(String host, List<String> paths, int size) {
        if (size < 0) {
            return ROOT;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(host);
        int i = 1;
        for (String path : paths) {
            if (i > size) break;
            if (sb.length() > 0 && !path.startsWith("/")) {
                sb.append("/");
            }
            sb.append(path);
            ++i;
        }
        return sb.toString();
    }

    public static String getHostName(HttpMessage msg) throws URIException {
        return SessionStructure.getHostName(msg.getRequestHeader().getURI());
    }

    public static String getHostName(URI uri) throws URIException {
        StringBuilder host = new StringBuilder();
        String scheme = uri.getScheme().toLowerCase();
        host.append(scheme).append("://").append(uri.getHost());
        int port = uri.getPort();
        if (port != -1 && (port == 80 && !"http".equals(scheme) || port == 443 && !"https".equals(scheme) || port != 80 && port != 443)) {
            host.append(":").append(port);
        }
        return host.toString();
    }

    @Deprecated
    public static StructuralNode getRootNode() {
        return SessionStructure.getRootNode(Model.getSingleton());
    }

    public static StructuralNode getRootNode(Model model) {
        if (!Constant.isLowMemoryOptionSet()) {
            return new StructuralSiteNode(model.getSession().getSiteTree().getRoot());
        }
        Session session = model.getSession();
        try {
            RecordStructure rs = model.getDb().getTableStructure().find(session.getSessionId(), ROOT, "GET");
            if (rs != null) {
                return new StructuralTableNode(rs);
            }
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private static String getParams(Session session, HttpMessage msg) throws URIException {
        String postData = null;
        if (msg.getRequestHeader().getMethod().equalsIgnoreCase("POST")) {
            String contentType = msg.getRequestHeader().getHeader("Content-Type");
            postData = contentType != null && contentType.startsWith(MULTIPART_FORM_DATA) ? MULTIPART_FORM_DATA_DISPLAY : msg.getRequestBody().toString();
        }
        return SessionStructure.getParams(session, msg.getRequestHeader().getURI(), postData);
    }

    private static String getParams(Session session, URI uri, String postData) throws URIException {
        String leafName = "";
        String query = "";
        boolean hasPostData = postData != null && postData.length() > 0;
        try {
            query = uri.getQuery();
        }
        catch (URIException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (query == null) {
            query = "";
        }
        leafName = leafName + SessionStructure.getQueryParamString(session.getUrlParameters(uri), hasPostData);
        query = "";
        if (hasPostData) {
            leafName = postData.equals(MULTIPART_FORM_DATA) ? leafName + MULTIPART_FORM_DATA_DISPLAY : leafName + SessionStructure.getQueryParamString(session.getFormParameters(uri, postData), false);
        }
        return leafName;
    }

    private static String getQueryParamString(List<NameValuePair> list, boolean isUrlWithPostData) {
        StringBuilder sb = new StringBuilder();
        list.stream().sorted().forEach(entry -> {
            String name = entry.getName();
            if (name != null) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                if (name.length() > 40) {
                    name = name.substring(0, 40) + "...";
                }
                sb.append(name);
            }
        });
        String result = "";
        if (sb.length() > 0 || isUrlWithPostData) {
            result = sb.insert(0, '(').append(')').toString();
        }
        return result;
    }
}

