/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.core.domain.JavaClassDescriptor;
import com.tngtech.archunit.core.domain.JavaType;
import com.tngtech.archunit.core.domain.JavaTypeVariable;
import com.tngtech.archunit.core.importer.DeclarationHandler;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.core.importer.ImportedClasses;
import com.tngtech.archunit.core.importer.JavaClassDescriptorImporter;
import com.tngtech.archunit.thirdparty.org.objectweb.asm.signature.SignatureVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SignatureTypeArgumentProcessor<TYPE extends HasDescription>
extends SignatureVisitor {
    private static final Logger log = LoggerFactory.getLogger(SignatureTypeArgumentProcessor.class);
    private final TypeArgumentType typeArgumentType;
    private final DomainBuilders.JavaParameterizedTypeBuilder<TYPE> parameterizedType;
    private final DomainBuilders.JavaTypeCreationProcess.JavaTypeFinisher typeFinisher;
    private final DeclarationHandler declarationHandler;
    private DomainBuilders.JavaParameterizedTypeBuilder<TYPE> currentTypeArgument;
    private static final TypeArgumentType PARAMETERIZED_TYPE = new TypeArgumentType("type argument"){

        <T extends HasDescription> void addTypeArgumentToBuilder(DomainBuilders.JavaParameterizedTypeBuilder<T> parameterizedType, DomainBuilders.JavaTypeCreationProcess<T> typeCreationProcess) {
            parameterizedType.addTypeArgument(typeCreationProcess);
        }
    };
    private static final TypeArgumentType WILDCARD_WITH_UPPER_BOUND = new TypeArgumentType("wildcard with upper bound"){

        <T extends HasDescription> void addTypeArgumentToBuilder(DomainBuilders.JavaParameterizedTypeBuilder<T> parameterizedType, DomainBuilders.JavaTypeCreationProcess<T> typeCreationProcess) {
            parameterizedType.addTypeArgument(new NewJavaTypeCreationProcess(new DomainBuilders.JavaWildcardTypeBuilder<T>().addUpperBound(typeCreationProcess)));
        }
    };
    private static final TypeArgumentType WILDCARD_WITH_LOWER_BOUND = new TypeArgumentType("wildcard with lower bound"){

        <T extends HasDescription> void addTypeArgumentToBuilder(DomainBuilders.JavaParameterizedTypeBuilder<T> parameterizedType, DomainBuilders.JavaTypeCreationProcess<T> typeCreationProcess) {
            parameterizedType.addTypeArgument(new NewJavaTypeCreationProcess(new DomainBuilders.JavaWildcardTypeBuilder<T>().addLowerBound(typeCreationProcess)));
        }
    };

    SignatureTypeArgumentProcessor(TypeArgumentType typeArgumentType, DomainBuilders.JavaParameterizedTypeBuilder<TYPE> parameterizedType, DomainBuilders.JavaTypeCreationProcess.JavaTypeFinisher typeFinisher, DeclarationHandler declarationHandler) {
        super(589824);
        this.typeArgumentType = typeArgumentType;
        this.parameterizedType = parameterizedType;
        this.typeFinisher = typeFinisher;
        this.declarationHandler = declarationHandler;
    }

    @Override
    public void visitClassType(String internalObjectName) {
        JavaClassDescriptor type = JavaClassDescriptorImporter.createFromAsmObjectTypeName(internalObjectName);
        log.trace("Encountered {} for {}: Class type {}", new Object[]{this.typeArgumentType.description, this.parameterizedType.getTypeName(), type.getFullyQualifiedClassName()});
        this.currentTypeArgument = new DomainBuilders.JavaParameterizedTypeBuilder(type);
        this.typeArgumentType.addTypeArgumentToBuilder(this.parameterizedType, new NewJavaTypeCreationProcess<TYPE>(this.currentTypeArgument, this.typeFinisher));
        this.declarationHandler.onDeclaredGenericSignatureType(type.getFullyQualifiedClassName());
    }

    @Override
    public void visitBaseType(char descriptor) {
        this.visitClassType(String.valueOf(descriptor));
    }

    @Override
    public void visitTypeArgument() {
        log.trace("Encountered wildcard for {}", (Object)this.currentTypeArgument.getTypeName());
        this.currentTypeArgument.addTypeArgument(new NewJavaTypeCreationProcess(new DomainBuilders.JavaWildcardTypeBuilder(), DomainBuilders.JavaTypeCreationProcess.JavaTypeFinisher.IDENTITY));
    }

    @Override
    public void visitTypeVariable(String name) {
        if (log.isTraceEnabled()) {
            log.trace("Encountered {} for {}: Type variable {}", new Object[]{this.typeArgumentType.description, this.parameterizedType.getTypeName(), this.typeFinisher.getFinishedName(name)});
        }
        this.typeArgumentType.addTypeArgumentToBuilder(this.parameterizedType, new ReferenceCreationProcess(name, this.typeFinisher));
    }

    @Override
    public SignatureVisitor visitTypeArgument(char wildcard) {
        return SignatureTypeArgumentProcessor.create(wildcard, this.currentTypeArgument, DomainBuilders.JavaTypeCreationProcess.JavaTypeFinisher.IDENTITY, this.declarationHandler);
    }

    @Override
    public SignatureVisitor visitArrayType() {
        return new SignatureTypeArgumentProcessor<TYPE>(this.typeArgumentType, this.parameterizedType, this.typeFinisher.after(DomainBuilders.JavaTypeCreationProcess.JavaTypeFinisher.ARRAY_CREATOR), this.declarationHandler);
    }

    static <TYPE extends HasDescription> SignatureTypeArgumentProcessor<TYPE> create(char identifier, DomainBuilders.JavaParameterizedTypeBuilder<TYPE> parameterizedType, DeclarationHandler declarationHandler) {
        return SignatureTypeArgumentProcessor.create(identifier, parameterizedType, DomainBuilders.JavaTypeCreationProcess.JavaTypeFinisher.IDENTITY, declarationHandler);
    }

    static <TYPE extends HasDescription> SignatureTypeArgumentProcessor<TYPE> create(char identifier, DomainBuilders.JavaParameterizedTypeBuilder<TYPE> parameterizedType, DomainBuilders.JavaTypeCreationProcess.JavaTypeFinisher typeFinisher, DeclarationHandler declarationHandler) {
        switch (identifier) {
            case '=': {
                return new SignatureTypeArgumentProcessor<TYPE>(PARAMETERIZED_TYPE, parameterizedType, typeFinisher, declarationHandler);
            }
            case '+': {
                return new SignatureTypeArgumentProcessor<TYPE>(WILDCARD_WITH_UPPER_BOUND, parameterizedType, typeFinisher, declarationHandler);
            }
            case '-': {
                return new SignatureTypeArgumentProcessor<TYPE>(WILDCARD_WITH_LOWER_BOUND, parameterizedType, typeFinisher, declarationHandler);
            }
        }
        throw new IllegalStateException(String.format("Cannot handle asm type argument identifier '%s'", Character.valueOf(identifier)));
    }

    private static abstract class TypeArgumentType {
        private final String description;

        TypeArgumentType(String description) {
            this.description = description;
        }

        abstract <TYPE extends HasDescription> void addTypeArgumentToBuilder(DomainBuilders.JavaParameterizedTypeBuilder<TYPE> var1, DomainBuilders.JavaTypeCreationProcess<TYPE> var2);
    }

    static class NewJavaTypeCreationProcess<OWNER extends HasDescription>
    implements DomainBuilders.JavaTypeCreationProcess<OWNER> {
        private final DomainBuilders.JavaTypeBuilder<OWNER> builder;
        private final DomainBuilders.JavaTypeCreationProcess.JavaTypeFinisher typeFinisher;

        NewJavaTypeCreationProcess(DomainBuilders.JavaTypeBuilder<OWNER> builder) {
            this(builder, DomainBuilders.JavaTypeCreationProcess.JavaTypeFinisher.IDENTITY);
        }

        NewJavaTypeCreationProcess(DomainBuilders.JavaTypeBuilder<OWNER> builder, DomainBuilders.JavaTypeCreationProcess.JavaTypeFinisher typeFinisher) {
            this.builder = builder;
            this.typeFinisher = typeFinisher;
        }

        @Override
        public JavaType finish(OWNER owner, Iterable<JavaTypeVariable<?>> allTypeParametersInContext, ImportedClasses classes) {
            JavaType type = this.builder.build(owner, allTypeParametersInContext, classes);
            return this.typeFinisher.finish(type, classes);
        }
    }

    static class ReferenceCreationProcess<OWNER extends HasDescription>
    implements DomainBuilders.JavaTypeCreationProcess<OWNER> {
        private final String typeVariableName;
        private final DomainBuilders.JavaTypeCreationProcess.JavaTypeFinisher finisher;

        ReferenceCreationProcess(String typeVariableName) {
            this(typeVariableName, DomainBuilders.JavaTypeCreationProcess.JavaTypeFinisher.IDENTITY);
        }

        ReferenceCreationProcess(String typeVariableName, DomainBuilders.JavaTypeCreationProcess.JavaTypeFinisher finisher) {
            this.typeVariableName = typeVariableName;
            this.finisher = finisher;
        }

        @Override
        public JavaType finish(OWNER owner, Iterable<JavaTypeVariable<?>> allTypeParametersInContext, ImportedClasses classes) {
            return this.finisher.finish(this.createTypeVariable(owner, allTypeParametersInContext, classes), classes);
        }

        private JavaType createTypeVariable(OWNER owner, Iterable<JavaTypeVariable<?>> allTypeParametersInContext, ImportedClasses classes) {
            for (JavaTypeVariable<?> existingTypeVariable : allTypeParametersInContext) {
                if (!existingTypeVariable.getName().equals(this.typeVariableName)) continue;
                return existingTypeVariable;
            }
            return new DomainBuilders.JavaTypeParameterBuilder<OWNER>(this.typeVariableName).build(owner, classes);
        }
    }
}

