/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.bookmarks.mindmapmode;

import org.freeplane.features.bookmarks.mindmapmode.MapBookmarks;
import org.freeplane.features.bookmarks.mindmapmode.NodeBookmarkDescriptor;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.filter.hidden.NodeVisibility;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.IMapViewManager;

public class NodeBookmark {
    private final NodeModel node;
    private final NodeBookmarkDescriptor descriptor;

    NodeBookmark(NodeModel node, NodeBookmarkDescriptor descriptor) {
        this.node = node;
        this.descriptor = descriptor;
    }

    public NodeModel getNode() {
        return this.node;
    }

    public NodeBookmarkDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void open(boolean asRoot) {
        NodeModel selectedNode;
        Controller controller = Controller.getCurrentController();
        IMapViewManager mapViewManager = controller.getMapViewManager();
        IMapSelection selection = controller.getSelection();
        if (asRoot) {
            MapBookmarks bookmarks = (MapBookmarks)selection.getMap().getExtension(MapBookmarks.class);
            NodeModel lastSelectedNode = bookmarks.getSelectedNodeForRoot(this.node);
            if (selection.getSelectionRoot() != this.node) {
                mapViewManager.setViewRoot(this.node);
                selectedNode = lastSelectedNode;
            } else {
                selectedNode = this.node;
            }
        } else {
            selectedNode = this.node;
        }
        if (asRoot || !NodeVisibility.isHidden((NodeModel)selectedNode)) {
            Filter filter;
            if (selection.getSelectionRoot() != selectedNode && !selectedNode.isDescendantOf(selection.getSelectionRoot())) {
                mapViewManager.setViewRoot(this.node.getMap().getRootNode());
            }
            if (!selectedNode.isVisible(filter = selection.getFilter())) {
                FilterController.getController((Controller)controller).applyNoFiltering(this.node.getMap());
            }
            controller.getModeController().getMapController().displayNode(selectedNode);
            if (selectedNode.isRoot()) {
                selection.selectRoot();
            } else {
                selection.selectAsTheOnlyOneSelected(selectedNode);
                selection.scrollNodeTreeToVisible(selectedNode, false);
            }
        }
    }

    public void open() {
        this.open(this.opensAsRoot());
    }

    public String getName() {
        return this.descriptor.getName();
    }

    boolean opensAsRoot() {
        return this.descriptor.opensAsRoot();
    }

    public void openAsNewView() {
        Controller controller = Controller.getCurrentController();
        IMapViewManager mapViewManager = controller.getMapViewManager();
        mapViewManager.newMapView(this.node.getMap(), controller.getModeController());
        this.open(true);
    }

    public void alternativeOpen() {
        this.open(!this.opensAsRoot());
    }
}

