/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.ui;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.FocusManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.JTextComponent;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.view.swing.map.NodeView;

public class MouseTimerDelegate {
    protected static final String MOUSE_OVER_DELAY = "mouse_over_delay";
    private Rectangle controlRegionForDelayedAction;
    private Timer timerForDelayedAction;
    private ActionListener delayedAction;

    public void createTimer(MouseEvent e, ActionProvider actionProvider) {
        if (this.controlRegionForDelayedAction != null && this.controlRegionForDelayedAction.contains(e.getPoint())) {
            return;
        }
        this.stopTimer();
        Window focusedWindow = FocusManager.getCurrentManager().getFocusedWindow();
        if (focusedWindow == null) {
            return;
        }
        if (KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() instanceof JTextComponent) {
            return;
        }
        this.controlRegionForDelayedAction = this.getControlRegion(e.getPoint());
        if (!actionProvider.isActionEnabled()) {
            return;
        }
        this.delayedAction = actionProvider.createDelayedAction(e);
        int mouseOverDelay = this.getMouseOverDelay();
        this.timerForDelayedAction = new Timer(mouseOverDelay, this.delayedAction);
        this.timerForDelayedAction.setRepeats(false);
        this.timerForDelayedAction.start();
    }

    public void stopTimer() {
        if (this.timerForDelayedAction != null) {
            this.timerForDelayedAction.stop();
        }
        this.timerForDelayedAction = null;
        this.controlRegionForDelayedAction = null;
        this.delayedAction = null;
    }

    protected Rectangle getControlRegion(Point2D p) {
        int side = 8;
        return new Rectangle((int)(p.getX() - 4.0), (int)(p.getY() - 4.0), 8, 8);
    }

    public NodeView getRelatedNodeView(MouseEvent e) {
        return (NodeView)SwingUtilities.getAncestorOfClass(NodeView.class, e.getComponent());
    }

    private int getMouseOverDelay() {
        ResourceController rc = ResourceController.getResourceController();
        return rc.getIntProperty(MOUSE_OVER_DELAY, 100);
    }

    public void trackWindowForComponent(Component c) {
    }

    public static interface ActionProvider {
        public ActionListener createDelayedAction(MouseEvent var1);

        public boolean isActionEnabled();
    }
}

