/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.im.InputMethodRequests;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.AttributedString;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.freeplane.api.ChildNodesAlignment;
import org.freeplane.api.ChildrenSides;
import org.freeplane.api.Dash;
import org.freeplane.api.HorizontalTextAlignment;
import org.freeplane.api.LayoutOrientation;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.api.TextWritingDirection;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.FreeplaneMenuBar;
import org.freeplane.core.ui.components.MultipleImageIcon;
import org.freeplane.core.ui.components.TagIcon;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.edge.EdgeController;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.NamedIcon;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.icon.mindmapmode.TagSelection;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.map.ITooltipProvider;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodelocation.LocationModel;
import org.freeplane.features.nodestyle.NodeCss;
import org.freeplane.features.nodestyle.NodeGeometryModel;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapViewLayout;
import org.freeplane.features.text.HighlightedTransformedObject;
import org.freeplane.features.text.TextController;
import org.freeplane.view.swing.map.FoldingMark;
import org.freeplane.view.swing.map.FreeplaneTooltip;
import org.freeplane.view.swing.map.IconLocation;
import org.freeplane.view.swing.map.InputMethodBuffer;
import org.freeplane.view.swing.map.MainViewPainter;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.MouseArea;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.PaintingMode;
import org.freeplane.view.swing.map.TagLocation;
import org.freeplane.view.swing.map.ZoomableLabel;
import org.freeplane.view.swing.map.ZoomableLabelUI;

public class MainView
extends ZoomableLabel {
    static final AttributedString EMPTY_ATTRIBUTED_STRING = new AttributedString("");
    private static final String MOUSE_DRIVEN_NODE_SHIFTS_OPTION_NAME = "mouseDrivenNodeShiftsAreDisabled";
    private static final long serialVersionUID = 1L;
    private static MainView lastMouseEventTarget = null;
    static final String USE_COMMON_OUT_POINT_FOR_ROOT_NODE_STRING = "use_common_out_point_for_root_node";
    public static boolean USE_COMMON_OUT_POINT_FOR_ROOT_NODE = ResourceController.getResourceController().getBooleanProperty("use_common_out_point_for_root_node");
    static Dimension maximumSize = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    static Dimension minimumSize = new Dimension(0, 0);
    static final Stroke DEF_STROKE = new BasicStroke(1.0f);
    private static final BasicStroke THIN_STROKE = new BasicStroke(1.5f);
    private static final int THICK_STROKE_WIDTH = 4;
    private static final Stroke THICK_STROKE = new BasicStroke(3.0f);
    private DragOverDirection dragOverDirection = DragOverDirection.OFF;
    private boolean isShortened;
    private TextModificationState textModified = TextModificationState.NONE;
    private MouseArea mouseArea = MouseArea.OUT;
    private float unzoomedBorderWidth = 1.0f;
    private Dash dash = Dash.DEFAULT;
    private Color borderColor = EdgeController.STANDARD_EDGE_COLOR;
    private Boolean borderColorMatchesEdgeColor = true;
    private MainViewPainter painter;
    private Color unselectedForeground = null;

    boolean isShortened() {
        return this.isShortened;
    }

    MainView() {
        this.setAlignmentX(0.5f);
        this.setHorizontalAlignment(2);
        this.setVerticalAlignment(0);
        this.setHorizontalTextPosition(11);
        this.setVerticalTextPosition(1);
        this.enableInputMethods(true);
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        return new InputMethodBuffer(this);
    }

    protected void convertPointFromMap(Point p) {
        UITools.convertPointFromAncestor(this.getMap(), p, this);
    }

    protected void convertPointToMap(Point p) {
        UITools.convertPointToAncestor((Component)this, p, this.getMap());
    }

    private DragOverDirection dragOverDirection(Point p) {
        DragOverDirection dragOverDirection = p.x < this.getWidth() * 1 / 6 ? DragOverDirection.DROP_LEFT : (p.x >= this.getWidth() * 5 / 6 ? DragOverDirection.DROP_RIGHT : (p.y < this.getHeight() * 1 / 6 ? DragOverDirection.DROP_UP : (p.y >= this.getHeight() * 5 / 6 ? DragOverDirection.DROP_DOWN : (p.x < this.getWidth() * 1 / 4 ? DragOverDirection.DROP_LEFT : (p.x >= this.getWidth() * 3 / 4 ? DragOverDirection.DROP_RIGHT : (p.y < this.getHeight() * 1 / 2 ? DragOverDirection.DROP_UP : DragOverDirection.DROP_DOWN))))));
        NodeView nodeView = this.getNodeView();
        DragOverRelation relation = dragOverDirection.relation(nodeView.layoutOrientation(), nodeView.side());
        boolean isRoot = nodeView.isRoot();
        if (isRoot && relation.isSibling()) {
            return DragOverDirection.OFF;
        }
        ChildrenSides childrenSides = nodeView.childrenSides();
        if (relation.isChild() && !childrenSides.matches(relation == DragOverRelation.CHILD_BEFORE)) {
            return DragOverDirection.OFF;
        }
        return dragOverDirection;
    }

    public DragOverRelation dragOverRelation(DropTargetDropEvent dtde) {
        return dtde.isDataFlavorSupported(TagSelection.tagFlavor) ? DragOverRelation.TAG : this.dragOverRelation(dtde.getLocation());
    }

    private DragOverRelation dragOverRelation(Point location) {
        NodeView nodeView = this.getNodeView();
        DragOverDirection dragOverDirection = this.dragOverDirection(location);
        return dragOverDirection.relation(nodeView.layoutOrientation(), nodeView.side());
    }

    @Override
    public Dimension getMaximumSize() {
        return maximumSize;
    }

    @Override
    public Dimension getMinimumSize() {
        return minimumSize;
    }

    int getZoomedFoldingMarkHalfSize() {
        return this.getNodeView().getZoomedFoldingMarkHalfSize();
    }

    public int getZoomedFoldingSwitchMinWidth() {
        return this.getNodeView().getZoomedFoldingSwitchMinWidth();
    }

    public boolean isClickableLink(Point point) {
        NodeView nodeView = this.getNodeView();
        NodeModel model = nodeView.getNode();
        if (NodeLinks.getValidLink(model) == null) {
            return false;
        }
        return this.isInIconRegion(point.getX()) && this.getTagIconAt(point) == null;
    }

    public boolean isInIconRegion(double xCoord) {
        Rectangle iconR = this.getIconRectangle();
        return xCoord >= (double)iconR.x && xCoord < (double)(iconR.x + iconR.width);
    }

    private Rectangle getIconRectangle() {
        ZoomableLabelUI zoomableLabelUI = this.getUI();
        Rectangle iconR = zoomableLabelUI.getIconR(this);
        return iconR;
    }

    public boolean isInVerticalRegion(double xCoord, double p) {
        return xCoord < (double)this.getSize().width * p;
    }

    @Override
    public final void paint(Graphics g) {
        PaintingMode paintingMode = this.getMap().getPaintingMode();
        if (!PaintingMode.SELECTED_NODES.equals((Object)paintingMode) && !PaintingMode.NODES.equals((Object)paintingMode)) {
            return;
        }
        NodeView nodeView = this.getNodeView();
        boolean selected = nodeView.isSelected();
        if (paintingMode.equals((Object)PaintingMode.SELECTED_NODES) == selected) {
            super.paint(g);
        }
    }

    public void paintDragOver(Graphics2D graphics) {
        this.dragOverDirection.paint(this, graphics);
    }

    public FoldingMark foldingMarkType(MapController mapController, NodeView nodeView) {
        if (nodeView.isFolded() || nodeView.hasHiddenChildren()) {
            return nodeView.isFoldable() ? FoldingMark.FOLDING_CIRCLE_FOLDED : FoldingMark.INVISIBLE;
        }
        Filter filter = nodeView.getMap().getFilter();
        for (NodeView childView : nodeView.getChildrenViews()) {
            if (childView.getNode().hasVisibleContent(filter) || FoldingMark.FOLDING_CIRCLE_UNFOLDED.equals(this.foldingMarkType(mapController, childView))) continue;
            return FoldingMark.FOLDING_CIRCLE_FOLDED;
        }
        if (nodeView.getNode().isRoot()) {
            return FoldingMark.INVISIBLE;
        }
        return FoldingMark.FOLDING_CIRCLE_UNFOLDED;
    }

    boolean shouldPaintCloneMarker(NodeView nodeView) {
        ResourceController resourceController = ResourceController.getResourceController();
        return resourceController.getBooleanProperty("markClones") || nodeView.isSelected() && resourceController.getBooleanProperty("markSelectedClones");
    }

    Rectangle decorationMarkBounds(NodeView nodeView, double shiftYFactor, double widthFactor, double heightFactor) {
        int size = nodeView.getZoomedStateSymbolHalfWidth();
        int width = (int)((double)size * widthFactor);
        int x = nodeView.paintsChildrenOnTheLeft() ? this.getWidth() : 0 - width;
        int height = (int)((double)size * heightFactor);
        int y = (this.getHeight() - height) / 2 + (int)((double)height * shiftYFactor);
        Rectangle decorationMarkBounds = new Rectangle(x, y, width, height);
        return decorationMarkBounds;
    }

    void paintDragRectangle(Graphics g) {
        if (!MouseArea.MOTION.equals((Object)this.mouseArea)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Color color = g2.getColor();
        Stroke stroke = g2.getStroke();
        g2.setColor(Color.WHITE);
        Rectangle r = this.getDragRectangle();
        r.x += 2;
        r.y += 2;
        r.width -= 4;
        r.height -= 4;
        g2.setStroke(THICK_STROKE);
        g.drawOval(r.x, r.y, r.width - 1, r.height - 1);
        g2.setStroke(THIN_STROKE);
        NodeView movedView = this.getNodeView();
        if (movedView.isFree()) {
            g2.setColor(Color.BLUE);
            g.fillOval(r.x, r.y, r.width - 1, r.height - 1);
        } else if (LocationModel.getModel((NodeModel)movedView.getNode()).getHGap().value <= 0.0) {
            g2.setColor(Color.RED);
            g.fillOval(r.x, r.y, r.width - 1, r.height - 1);
        }
        g2.setColor(Color.BLACK);
        g.drawOval(r.x, r.y, r.width - 1, r.height - 1);
        g2.setStroke(stroke);
        g2.setColor(color);
    }

    public Rectangle getDragRectangle() {
        int size = this.getDraggingAreaWidth();
        Rectangle r = this.getNodeView().paintsChildrenOnTheLeft() ? new Rectangle(this.getWidth(), -size / 2, size, this.getHeight() + size) : new Rectangle(-size, -size / 2, size, this.getHeight() + size);
        return r;
    }

    void drawModificationRect(Graphics g) {
        Color color = g.getColor();
        if (TextModificationState.FAILURE.equals((Object)this.textModified)) {
            g.setColor(HighlightedTransformedObject.FAILURE_COLOR);
        } else if (MapView.isElementHighlighted(this, this.getNodeView().getNode())) {
            g.setColor(FilterController.HIGHLIGHT_COLOR);
        } else if (TextModificationState.HIGHLIGHT.equals((Object)this.textModified)) {
            boolean markTransformedText = TextController.isMarkTransformedTextSet();
            if (!markTransformedText) {
                return;
            }
            g.setColor(HighlightedTransformedObject.OK_COLOR);
        } else {
            return;
        }
        g.drawRect(-1, -1, this.getWidth() + 2, this.getHeight() + 2);
        g.setColor(color);
    }

    protected void paintBackgound(Graphics2D g) {
        Color color = this.getPaintedBackground();
        this.painter.paintBackground(g, color);
    }

    @Override
    public Color getUnselectedForeground() {
        return this.unselectedForeground;
    }

    public Color getPaintedBackground() {
        return this.getNodeView().getTextBackground();
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (super.processKeyBinding(ks, e, condition, pressed)) {
            return true;
        }
        MapView mapView = (MapView)SwingUtilities.getAncestorOfClass(MapView.class, this);
        FreeplaneMenuBar freeplaneMenuBar = mapView.getModeController().getController().getViewController().getFreeplaneMenuBar();
        return !freeplaneMenuBar.isVisible() && freeplaneMenuBar.processKeyBinding(ks, e, 2, pressed);
    }

    public void stopDragOver() {
        this.dragOverDirection = DragOverDirection.OFF;
    }

    private void setDraggedOver(DragOverDirection draggedOver) {
        boolean isDifferent;
        boolean bl = isDifferent = draggedOver != this.dragOverDirection;
        if (isDifferent) {
            this.dragOverDirection = draggedOver;
            this.repaint();
        }
    }

    public void setDragOverDirection(DropTargetDragEvent dtde) {
        DragOverDirection dragOverDirection = dtde.isDataFlavorSupported(TagSelection.tagFlavor) ? DragOverDirection.DROP_TAG : this.dragOverDirection(dtde.getLocation());
        this.setDraggedOver(dragOverDirection);
    }

    public void updateFont(NodeView node) {
        Font font = NodeStyleController.getController(node.getMap().getModeController()).getFont(node.getNode(), node.getStyleOption());
        this.setFont(UITools.scale(font));
    }

    void updateIcons(NodeView nodeView) {
        MultipleImageIcon iconImages = new MultipleImageIcon();
        NodeModel node = nodeView.getNode();
        LogicalStyleController.StyleOption styleOption = nodeView.getStyleOption();
        Quantity<LengthUnit> iconHeight = IconController.getController().getIconSize(node, styleOption);
        if (!node.isRoot()) {
            if (nodeView.isRoot()) {
                iconImages.addIcon(IconStoreFactory.ICON_STORE.getUIIcon("currentRoot.svg"), iconHeight);
            } else if (nodeView.isSearchRoot()) {
                iconImages.addIcon(IconStoreFactory.ICON_STORE.getUIIcon("searchRoot.svg"), iconHeight);
            }
        }
        ModeController modeController = this.getNodeView().getMap().getModeController();
        IconController iconController = IconController.getController(modeController);
        MapView map = nodeView.getMap();
        IconLocation iconLocation = map.getIconLocation();
        if (map.showsIcons()) {
            if (iconLocation == IconLocation.BESIDE_NODES) {
                this.setVerticalTextPosition(1);
            } else if (iconLocation == IconLocation.ABOVE_NODES) {
                this.setVerticalTextPosition(3);
            }
            for (UIIcon uIIcon : iconController.getStateIcons(node)) {
                iconImages.addIcon(uIIcon, iconHeight);
            }
            Collection<NamedIcon> icons = iconController.getIcons(node, styleOption);
            for (NamedIcon myIcon : icons) {
                iconImages.addIcon(myIcon, iconHeight);
            }
        }
        if (TagLocation.BESIDE_NODES == map.getTagLocation() && (MapView.showsTagsOnMinimizedNodes() || !nodeView.isShortened())) {
            for (TagIcon tagIcon : iconController.getTagIcons(node)) {
                iconImages.addTag(tagIcon);
            }
        }
        if (iconImages.containsIcons()) {
            if (iconLocation == IconLocation.BESIDE_NODES) {
                iconImages.setHorizontalAlignment(this.getComponentOrientation().isLeftToRight() ? 4 : 2);
            } else if (iconLocation == IconLocation.ABOVE_NODES) {
                iconImages.setHorizontalAlignment(this.getHorizontalAlignment());
            }
        }
        modeController.getExtension(LinkController.class).addLinkDecorationIcons(iconImages, node, this.getNodeView().getStyleOption());
        this.setIcon(iconImages.containsIcons() ? iconImages : null);
    }

    void updateTextColor(NodeView node) {
        NodeStyleController styleController = NodeStyleController.getController(node.getMap().getModeController());
        Color newForeground = styleController.getColor(node.getNode(), node.getStyleOption());
        Color color = this.unselectedForeground = node.isSelected() ? styleController.getColor(node.getNode(), LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE) : newForeground;
        if (!Objects.equals(this.getForeground(), newForeground)) {
            this.setForeground(newForeground);
            this.revalidate();
        }
    }

    void updateCss(NodeView node) {
        NodeStyleController styleController = NodeStyleController.getController(node.getMap().getModeController());
        NodeCss newCss = styleController.getStyleSheet(node.getNode(), node.getStyleOption());
        this.setStyleSheet(newCss.css, newCss.getStyleSheet());
    }

    void updateHorizontalTextAlignment(NodeView node) {
        HorizontalTextAlignment textAlignment = NodeStyleController.getController(node.getMap().getModeController()).getHorizontalTextAlignment(node.getNode(), node.getStyleOption());
        boolean isCenteredByDefault = textAlignment == HorizontalTextAlignment.DEFAULT && node.getNode().isRoot();
        this.setHorizontalAlignment(isCenteredByDefault ? HorizontalTextAlignment.CENTER.swingConstant : textAlignment.swingConstant);
    }

    void updateTextWritingDirection(NodeView node) {
        TextWritingDirection textDirection = NodeStyleController.getController(node.getMap().getModeController()).getTextWritingDirection(node.getNode());
        boolean wasValid = this.isValid();
        this.setComponentOrientation(textDirection.componentOrientation);
        if (wasValid && !this.isValid()) {
            this.revalidate();
        }
    }

    public void updateText(NodeModel nodeModel) {
        String text;
        NodeView nodeView = this.getNodeView();
        if (nodeView == null) {
            return;
        }
        ModeController modeController = nodeView.getMap().getModeController();
        TextController textController = TextController.getController(modeController);
        this.isShortened = textController.isMinimized(nodeModel);
        Object userObject = nodeModel.getUserObject();
        try {
            Object transformedContent = textController.getTransformedObject(nodeModel, this);
            if (nodeView.isSelected()) {
                nodeView.getMap().getModeController().getController().getViewController().addObjectTypeInfo(transformedContent);
            }
            Icon icon = textController.getIcon(transformedContent);
            this.setTextRenderingIcon(icon);
            text = icon == null ? transformedContent.toString() : "";
            this.textModified = transformedContent instanceof HighlightedTransformedObject ? TextModificationState.HIGHLIGHT : TextModificationState.NONE;
        }
        catch (Throwable e) {
            LogUtils.warn(e.getMessage());
            text = TextUtils.format("MainView.errorUpdateText", String.valueOf(userObject), e.getLocalizedMessage());
            this.textModified = TextModificationState.FAILURE;
        }
        if (this.isShortened) {
            text = textController.getShortText(text);
        }
        text = this.convertTextToHtmlLink(text, nodeModel);
        this.updateText(text);
    }

    private String convertTextToHtmlLink(String text, NodeModel node) {
        Hyperlink link = NodeLinks.getLink(node);
        if (link == null || "menuitem".equals(link.getScheme()) || !this.getMap().getModeController().getExtension(LinkController.class).formatNodeAsHyperlink(node)) {
            return text;
        }
        if (HtmlUtils.isHtml(text)) {
            text = HtmlUtils.htmlToPlain(text);
        }
        StringBuilder sb = new StringBuilder("<html><body><a href=\"");
        sb.append(link.toString());
        sb.append("\">");
        String xmlEscapedText = HtmlUtils.toHTMLEscapedText(text);
        sb.append(xmlEscapedText);
        sb.append("</a></body></html>");
        return sb.toString();
    }

    @Override
    public JToolTip createToolTip() {
        FreeplaneTooltip tip = new FreeplaneTooltip(this.getGraphicsConfiguration(), "text/html", false);
        tip.setComponent(this);
        tip.setComponentOrientation(this.getComponentOrientation());
        tip.setBorder(BorderFactory.createEmptyBorder());
        URL url = this.getMap().getMap().getURL();
        if (url != null) {
            tip.setBase(url);
        } else {
            try {
                tip.setBase(new URL("file: "));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return tip;
    }

    @Override
    public void setBorder(Border border) {
    }

    public ConnectorLocation getConnectorLocation(Point relativeLocation, LayoutOrientation layoutOrientation, ChildNodesAlignment alignment) {
        if (layoutOrientation == LayoutOrientation.LEFT_TO_RIGHT || alignment.isStacked()) {
            if (relativeLocation.y > this.getHeight()) {
                return ConnectorLocation.BOTTOM;
            }
            if (relativeLocation.y < 0) {
                return ConnectorLocation.TOP;
            }
        }
        if (relativeLocation.x > this.getWidth()) {
            return ConnectorLocation.RIGHT;
        }
        if (relativeLocation.x < 0) {
            return ConnectorLocation.LEFT;
        }
        if (relativeLocation.y > this.getHeight()) {
            return ConnectorLocation.BOTTOM;
        }
        if (relativeLocation.y < 0) {
            return ConnectorLocation.TOP;
        }
        return ConnectorLocation.CENTER;
    }

    public Point getTopPoint() {
        return new Point(this.getWidth() / 2, 0);
    }

    public Point getBottomPoint() {
        return new Point(this.getWidth() / 2, this.getHeight());
    }

    @Override
    public String getToolTipText() {
        String toolTipText = super.getToolTipText();
        if (toolTipText != null) {
            return toolTipText;
        }
        return this.createToolTipText();
    }

    private String createToolTipText() {
        NodeView nodeView = this.getNodeView();
        if (nodeView == null) {
            return "";
        }
        ModeController modeController = nodeView.getMap().getModeController();
        NodeModel node = nodeView.getNode();
        return modeController.createToolTip(node, this, ITooltipProvider.TooltipTrigger.NODE);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        String toolTipText = super.getToolTipText();
        if (toolTipText != null) {
            return toolTipText;
        }
        boolean isClickableLink = this.isClickableLink(event.getPoint());
        if (isClickableLink) {
            NodeView nodeView = this.getNodeView();
            if (nodeView == null) {
                return "";
            }
            ModeController modeController = nodeView.getMap().getModeController();
            NodeModel linkedNode = modeController.getExtension(LinkController.class).getLinkedNode(nodeView.getNode());
            if (linkedNode != null) {
                return modeController.createToolTip(linkedNode, this, ITooltipProvider.TooltipTrigger.LINK);
            }
        }
        return this.createToolTipText();
    }

    @Override
    public boolean contains(int x, int y) {
        if (super.contains(x, y)) {
            return true;
        }
        if (lastMouseEventTarget == null || lastMouseEventTarget == this || this.getNodeView().isSelected() && !lastMouseEventTarget.getNodeView().isSelected()) {
            Point p = new Point(x, y);
            return this.isInFoldingRegion(p) || this.isInDragRegion(p);
        }
        return false;
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() == 504 || e.getID() == 503) {
            if (e.getClickCount() == 0) {
                lastMouseEventTarget = this;
            }
        } else if (lastMouseEventTarget == this && e.getID() == 505) {
            lastMouseEventTarget = null;
        }
        super.processMouseEvent(e);
    }

    public boolean isInDragRegion(Point p) {
        if (ResourceController.getResourceController().getBooleanProperty(MOUSE_DRIVEN_NODE_SHIFTS_OPTION_NAME)) {
            return false;
        }
        if (p.y >= 0 && p.y < this.getHeight()) {
            NodeView nodeView = this.getNodeView();
            if (nodeView.isRoot()) {
                return false;
            }
            NodeModel node = nodeView.getNode();
            if (node.getParentNode() == null) {
                return false;
            }
            if (MapViewLayout.OUTLINE.equals((Object)nodeView.getMap().getLayoutType())) {
                return false;
            }
            int draggingWidth = this.getDraggingAreaWidth();
            if (nodeView.paintsChildrenOnTheLeft()) {
                int width = this.getWidth();
                return p.x >= width && p.x < width + draggingWidth;
            }
            return p.x >= -draggingWidth && p.x < 0;
        }
        return false;
    }

    boolean hasChildren() {
        NodeView nodeView = this.getNodeView();
        NodeModel node = nodeView.getNode();
        return node.hasChildren();
    }

    public boolean isInFoldingRegion(Point p) {
        NodeView nodeView = this.getNodeView();
        if (!nodeView.getNode().hasChildren()) {
            return false;
        }
        Rectangle foldingRectangleBounds = this.painter.getFoldingRectangleBounds(nodeView, true);
        if (nodeView.usesHorizontalLayout()) {
            if (nodeView.isTopOrLeft()) {
                return p.y >= foldingRectangleBounds.y && p.y < 0 && p.x >= 0 && p.x < this.getWidth();
            }
            return p.y >= foldingRectangleBounds.y && p.y < foldingRectangleBounds.y + foldingRectangleBounds.height && p.x >= 0 && p.x < this.getWidth();
        }
        if (nodeView.paintsChildrenOnTheLeft()) {
            return p.x >= foldingRectangleBounds.x && p.x < 0 && p.y >= 0 && p.y < Math.max(foldingRectangleBounds.y + foldingRectangleBounds.height, this.getHeight());
        }
        return p.x >= foldingRectangleBounds.x && p.x < foldingRectangleBounds.x + foldingRectangleBounds.width && p.y >= 0 && p.y < Math.max(foldingRectangleBounds.y + foldingRectangleBounds.height, this.getHeight());
    }

    public MouseArea getMouseArea() {
        return this.mouseArea;
    }

    public void setMouseArea(MouseArea mouseArea) {
        if (mouseArea.equals((Object)this.mouseArea)) {
            return;
        }
        boolean repaintDraggingRectangle = this.isVisible() && (mouseArea.equals((Object)MouseArea.MOTION) || this.mouseArea.equals((Object)MouseArea.MOTION));
        boolean repaintFoldingRectangle = this.isVisible() && (mouseArea.equals((Object)MouseArea.OUT) || mouseArea.equals((Object)MouseArea.FOLDING) || this.mouseArea.equals((Object)MouseArea.OUT) || this.mouseArea.equals((Object)MouseArea.FOLDING));
        this.mouseArea = mouseArea;
        if (repaintDraggingRectangle) {
            this.paintDraggingRectangleImmediately();
        }
        if (repaintFoldingRectangle) {
            this.paintFoldingRectangleImmediately();
        }
    }

    public Rectangle getFoldingControlBounds() {
        return this.getFoldingRectangleBounds(this.getNodeView(), true);
    }

    Rectangle getFoldingRectangleBounds(NodeView nodeView, boolean drawsControls) {
        return this.painter.getFoldingRectangleBounds(nodeView, drawsControls);
    }

    private void paintFoldingRectangleImmediately() {
        NodeView nodeView = this.getNodeView();
        Rectangle foldingRectangle = this.painter.getFoldingRectangleBounds(nodeView, true);
        MapView map = nodeView.getMap();
        UITools.convertRectangleToAncestor(this, foldingRectangle, map);
        map.paintImmediately(foldingRectangle);
    }

    private void paintDraggingRectangleImmediately() {
        Rectangle dragRectangle = this.getDragRectangle();
        this.paintDecorationImmediately(dragRectangle);
    }

    private void paintDecorationImmediately(Rectangle rectangle) {
        MapView map = this.getMap();
        UITools.convertRectangleToAncestor(this, rectangle, map);
        map.paintImmediately(rectangle);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.setMouseArea(MouseArea.OUT);
        }
    }

    int getDraggingAreaWidth() {
        return this.getNodeView().getMap().getDraggingAreaWidth() + 4;
    }

    public NamedIcon getUIIconAt(Point coordinate) {
        Icon icon = this.getIcon();
        if (icon instanceof MultipleImageIcon) {
            Rectangle iconRectangle = this.getIconRectangle();
            Point transformedToIconCoordinate = new Point(coordinate);
            transformedToIconCoordinate.translate(-iconRectangle.x, -iconRectangle.y);
            float zoom = this.getNodeView().getMap().getZoom();
            if (zoom != 1.0f) {
                transformedToIconCoordinate.x = (int)((float)transformedToIconCoordinate.x / zoom);
                transformedToIconCoordinate.y = (int)((float)transformedToIconCoordinate.y / zoom);
            }
            return ((MultipleImageIcon)icon).getUIIconAt(transformedToIconCoordinate);
        }
        return null;
    }

    public TagIcon getTagIconAt(Point coordinate) {
        Icon icon = this.getIcon();
        if (icon instanceof MultipleImageIcon) {
            Rectangle iconRectangle = this.getIconRectangle();
            Point transformedToIconCoordinate = new Point(coordinate);
            transformedToIconCoordinate.translate(-iconRectangle.x, -iconRectangle.y);
            float zoom = this.getNodeView().getMap().getZoom();
            if (zoom != 1.0f) {
                transformedToIconCoordinate.x = (int)((float)transformedToIconCoordinate.x / zoom);
                transformedToIconCoordinate.y = (int)((float)transformedToIconCoordinate.y / zoom);
            }
            return ((MultipleImageIcon)icon).getTagIconAt(transformedToIconCoordinate);
        }
        return null;
    }

    public float getUnzoomedEdgeWidth() {
        NodeView nodeView = this.getNodeView();
        int edgeWidth = nodeView.getEdgeWidth();
        return edgeWidth;
    }

    public int getPaintedBorderWidth() {
        float zoomedLineWidth = this.getNodeView().getMap().getZoom() * this.unzoomedBorderWidth;
        return (int)Math.max(zoomedLineWidth, 1.0f);
    }

    public float getUnzoomedBorderWidth() {
        return Math.max(this.unzoomedBorderWidth, 1.0f);
    }

    public Dash getDash() {
        return this.dash;
    }

    public Color getBorderColor() {
        return this.borderColorMatchesEdgeColor != false ? this.getNodeView().getEdgeColor() : this.borderColor;
    }

    public Color getFoldingMarkBorderColor() {
        Color borderColor = this.getBorderColor();
        if (borderColor.getAlpha() == 255) {
            return borderColor;
        }
        return new Color(borderColor.getRed(), borderColor.getGreen(), borderColor.getGreen(), 255);
    }

    public Color getFoldingMarkFillColor() {
        Color fillColor = this.getNodeView().getTextBackground();
        Color foldingCircleBorderColor = this.getFoldingMarkBorderColor();
        if (foldingCircleBorderColor.equals(fillColor)) {
            Color color = fillColor;
            fillColor = UITools.isLighter(color, 96) ? fillColor.darker() : fillColor.brighter().brighter();
        }
        return fillColor;
    }

    public void updateBorder(NodeView nodeView) {
        LogicalStyleController.StyleOption styleOption;
        NodeModel node;
        NodeStyleController controller = NodeStyleController.getController(nodeView.getMap().getModeController());
        Boolean borderWidthMatchesEdgeWidth = controller.getBorderWidthMatchesEdgeWidth(node = nodeView.getNode(), styleOption = nodeView.getStyleOption());
        this.unzoomedBorderWidth = borderWidthMatchesEdgeWidth != false ? this.getUnzoomedEdgeWidth() : (float)controller.getBorderWidth(node, styleOption).toBaseUnits();
        Boolean borderDashMatchesEdgeDash = controller.getBorderDashMatchesEdgeDash(node, styleOption);
        this.dash = borderDashMatchesEdgeDash != false ? nodeView.getEdgeDash() : controller.getBorderDash(node, styleOption);
        this.borderColorMatchesEdgeColor = controller.getBorderColorMatchesEdgeColor(node, styleOption);
        this.borderColor = this.borderColorMatchesEdgeColor != false ? null : controller.getBorderColor(node, styleOption);
    }

    void paintComponentDefault(Graphics graphics) {
        super.paintComponent(graphics);
    }

    public Insets getDefaultZoomedInsets() {
        return super.getZoomedInsets();
    }

    public Insets getDefaultInsets() {
        return super.getInsets();
    }

    public Insets getDefaultInsets(Insets insets) {
        return super.getInsets(insets);
    }

    public Dimension getDefaultPreferredSize() {
        return super.getPreferredSize();
    }

    public void setBoundsDefault(int x, int y, int width, int height) {
        if (x != this.getX() || y != this.getY() || width != this.getWidth() || height != this.getHeight()) {
            this.getNodeView().repaintEdge();
        }
        super.setBounds(x, y, width, height);
    }

    public Point getConnectorPoint(Point relativeLocation, LayoutOrientation layoutOrientation, ChildNodesAlignment alignment) {
        ConnectorLocation location = this.getConnectorLocation(relativeLocation, layoutOrientation, alignment);
        return this.painter.getConnectorPoint(relativeLocation, location);
    }

    public Point getConnectorPoint(Point relativeLocation, ConnectorLocation connectorLocation) {
        return this.painter.getConnectorPoint(relativeLocation, connectorLocation);
    }

    public Point getLeftPoint() {
        return this.painter.getLeftPoint();
    }

    public Point getRightPoint() {
        return this.painter.getRightPoint();
    }

    public NodeGeometryModel getShapeConfiguration() {
        return this.painter.getShapeConfiguration();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D g2 = (Graphics2D)graphics;
        int width = this.getWidth();
        int height = this.getHeight();
        AffineTransform t = g2.getTransform();
        double approxScaleX = Math.abs(t.getScaleX()) + Math.abs(t.getShearY());
        double approxScaleY = Math.abs(t.getShearX()) + Math.abs(t.getScaleY());
        if ((double)height * approxScaleY <= 2.0 || (double)width * approxScaleX <= 2.0) {
            g2.setColor(this.getBorderColor());
            g2.fillRect(0, 0, width, height);
        } else {
            this.painter.paintComponent(graphics);
        }
    }

    @Override
    public Insets getZoomedInsets() {
        return this.painter.getZoomedInsets();
    }

    @Override
    public Insets getInsets() {
        return this.painter.getInsets();
    }

    @Override
    public Insets getInsets(Insets insets) {
        return this.painter.getInsets(insets);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.painter.getPreferredSize();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        this.painter.setBounds(x, y, width, height);
    }

    public int getSingleChildShift() {
        return this.painter.getSingleChildShift();
    }

    public void paintDecoration(NodeView nodeView, Graphics2D g) {
        this.painter.paintDecoration(nodeView, g);
    }

    public void setPainter(MainViewPainter shape) {
        if (this.painter != shape) {
            this.painter = shape;
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public Point getToolTipLocation(MouseEvent event) {
        Container parent = this.getParent();
        if (parent instanceof NodeView) {
            return new Point(0, this.getHeight() - 1);
        }
        return new Point(-this.getX(), parent.getHeight() - 1 - this.getY());
    }

    public static enum DragOverDirection {
        OFF{

            @Override
            void paint(MainView view, Graphics2D graphics) {
            }

            @Override
            public DragOverRelation relation(LayoutOrientation layoutOrientation, NodeModel.Side side) {
                return DragOverRelation.NOT_AVAILABLE;
            }
        }
        ,
        DROP_UP{

            @Override
            void paint(MainView view, Graphics2D graphics) {
                graphics.setPaint(new GradientPaint(0.0f, view.getHeight() * 3 / 5, view.getMap().getBackground(), 0.0f, view.getHeight() / 5, NodeView.dragColor));
                graphics.fillRect(0, 0, view.getWidth() - 1, view.getHeight() - 1);
            }

            @Override
            public DragOverRelation relation(LayoutOrientation layoutOrientation, NodeModel.Side side) {
                return layoutOrientation == LayoutOrientation.LEFT_TO_RIGHT ? DragOverRelation.CHILD_BEFORE : DragOverRelation.SIBLING_BEFORE;
            }
        }
        ,
        DROP_DOWN{

            @Override
            void paint(MainView view, Graphics2D graphics) {
                graphics.setPaint(new GradientPaint(0.0f, view.getHeight() * 2 / 5, view.getMap().getBackground(), 0.0f, view.getHeight() * 4 / 5, NodeView.dragColor));
                graphics.fillRect(0, 0, view.getWidth() - 1, view.getHeight() - 1);
            }

            @Override
            public DragOverRelation relation(LayoutOrientation layoutOrientation, NodeModel.Side side) {
                return layoutOrientation == LayoutOrientation.LEFT_TO_RIGHT ? DragOverRelation.CHILD_AFTER : DragOverRelation.SIBLING_AFTER;
            }
        }
        ,
        DROP_LEFT{

            @Override
            void paint(MainView view, Graphics2D graphics) {
                graphics.setPaint(new GradientPaint(view.getWidth() * 3 / 4, 0.0f, view.getMap().getBackground(), view.getWidth() / 4, 0.0f, NodeView.dragColor));
                graphics.fillRect(0, 0, view.getWidth() * 3 / 4, view.getHeight() - 1);
            }

            @Override
            public DragOverRelation relation(LayoutOrientation layoutOrientation, NodeModel.Side side) {
                return layoutOrientation == LayoutOrientation.LEFT_TO_RIGHT ? (side == NodeModel.Side.BOTTOM_OR_RIGHT ? DragOverRelation.SIBLING_BEFORE : DragOverRelation.SIBLING_AFTER) : DragOverRelation.CHILD_BEFORE;
            }
        }
        ,
        DROP_RIGHT{

            @Override
            void paint(MainView view, Graphics2D graphics) {
                graphics.setPaint(new GradientPaint(view.getWidth() / 4, 0.0f, view.getMap().getBackground(), view.getWidth() * 3 / 4, 0.0f, NodeView.dragColor));
                graphics.fillRect(view.getWidth() / 4, 0, view.getWidth() - 1, view.getHeight() - 1);
            }

            @Override
            public DragOverRelation relation(LayoutOrientation layoutOrientation, NodeModel.Side side) {
                return layoutOrientation == LayoutOrientation.LEFT_TO_RIGHT ? (side == NodeModel.Side.BOTTOM_OR_RIGHT ? DragOverRelation.SIBLING_AFTER : DragOverRelation.SIBLING_BEFORE) : DragOverRelation.CHILD_AFTER;
            }
        }
        ,
        DROP_TAG{

            @Override
            void paint(MainView view, Graphics2D graphics) {
                Stroke stroke = graphics.getStroke();
                graphics.setStroke(THICK_STROKE);
                graphics.setColor(NodeView.dragColor);
                graphics.draw(TagIcon.createTagIconShape(view.getWidth() * 1 / 3, view.getHeight() / 6, view.getWidth() / 3, view.getHeight() * 4 / 6));
                graphics.setStroke(stroke);
            }

            @Override
            public DragOverRelation relation(LayoutOrientation layoutOrientation, NodeModel.Side side) {
                return DragOverRelation.TAG;
            }
        };


        abstract void paint(MainView var1, Graphics2D var2);

        public abstract DragOverRelation relation(LayoutOrientation var1, NodeModel.Side var2);
    }

    static enum TextModificationState {
        NONE,
        HIGHLIGHT,
        FAILURE;

    }

    public static enum DragOverRelation {
        NOT_AVAILABLE,
        CHILD_BEFORE,
        CHILD_AFTER,
        SIBLING_BEFORE,
        SIBLING_AFTER,
        TAG;


        public boolean isChild() {
            return this == CHILD_BEFORE || this == CHILD_AFTER;
        }

        public boolean isSibling() {
            return this == SIBLING_BEFORE || this == SIBLING_AFTER;
        }
    }

    public static enum ConnectorLocation {
        LEFT(MainViewPainter::getLeftPoint),
        RIGHT(MainViewPainter::getRightPoint),
        TOP(MainViewPainter::getTopPoint),
        BOTTOM(MainViewPainter::getBottomPoint),
        CENTER(MainViewPainter::getCenterPoint);

        public final Function<MainViewPainter, Point> pointSupplier;

        private ConnectorLocation(Function<MainViewPainter, Point> pointSupplier) {
            this.pointSupplier = pointSupplier;
        }
    }
}

