/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstances;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.DynamicDescendantFilter;
import org.junit.jupiter.engine.descriptor.ExtensionUtils;
import org.junit.jupiter.engine.descriptor.Filterable;
import org.junit.jupiter.engine.descriptor.MethodBasedTestDescriptor;
import org.junit.jupiter.engine.descriptor.TestTemplateExtensionContext;
import org.junit.jupiter.engine.descriptor.TestTemplateInvocationTestDescriptor;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.jupiter.engine.extension.MutableExtensionRegistry;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.hierarchical.Node;

@API(status=API.Status.INTERNAL, since="5.0")
public class TestTemplateTestDescriptor
extends MethodBasedTestDescriptor
implements Filterable {
    public static final String SEGMENT_TYPE = "test-template";
    private final DynamicDescendantFilter dynamicDescendantFilter = new DynamicDescendantFilter();

    public TestTemplateTestDescriptor(UniqueId uniqueId, Class<?> testClass, Method templateMethod, Supplier<List<Class<?>>> enclosingInstanceTypes, JupiterConfiguration configuration) {
        super(uniqueId, testClass, templateMethod, enclosingInstanceTypes, configuration);
    }

    @Override
    public DynamicDescendantFilter getDynamicDescendantFilter() {
        return this.dynamicDescendantFilter;
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    public boolean mayRegisterTests() {
        return true;
    }

    @Override
    public JupiterEngineExecutionContext prepare(JupiterEngineExecutionContext context) {
        MutableExtensionRegistry registry = ExtensionUtils.populateNewExtensionRegistryFromExtendWithAnnotation(context.getExtensionRegistry(), this.getTestMethod());
        TestInstances testInstances = context.getExtensionContext().getTestInstances().orElse(null);
        TestTemplateExtensionContext extensionContext = new TestTemplateExtensionContext(context.getExtensionContext(), context.getExecutionListener(), this, context.getConfiguration(), registry, testInstances);
        return context.extend().withExtensionRegistry(registry).withExtensionContext(extensionContext).build();
    }

    public JupiterEngineExecutionContext execute(JupiterEngineExecutionContext context, Node.DynamicTestExecutor dynamicTestExecutor) throws Exception {
        ExtensionContext extensionContext = context.getExtensionContext();
        List<TestTemplateInvocationContextProvider> providers = this.validateProviders(extensionContext, context.getExtensionRegistry());
        AtomicInteger invocationIndex = new AtomicInteger();
        for (TestTemplateInvocationContextProvider provider : providers) {
            this.executeForProvider(provider, invocationIndex, dynamicTestExecutor, extensionContext);
        }
        return context;
    }

    private void executeForProvider(TestTemplateInvocationContextProvider provider, AtomicInteger invocationIndex, Node.DynamicTestExecutor dynamicTestExecutor, ExtensionContext extensionContext) {
        int initialValue = invocationIndex.get();
        try (Stream<TestTemplateInvocationContext> stream = TestTemplateTestDescriptor.invocationContexts(provider, extensionContext);){
            stream.forEach(invocationContext -> this.toTestDescriptor((TestTemplateInvocationContext)invocationContext, invocationIndex.incrementAndGet()).ifPresent(testDescriptor -> this.execute(dynamicTestExecutor, (TestDescriptor)testDescriptor)));
        }
        Preconditions.condition((invocationIndex.get() != initialValue || provider.mayReturnZeroTestTemplateInvocationContexts(extensionContext) ? 1 : 0) != 0, (String)String.format("Provider [%s] did not provide any invocation contexts, but was expected to do so. You may override mayReturnZeroTestTemplateInvocationContexts() to allow this.", provider.getClass().getSimpleName()));
    }

    private static Stream<TestTemplateInvocationContext> invocationContexts(TestTemplateInvocationContextProvider provider, ExtensionContext extensionContext) {
        return provider.provideTestTemplateInvocationContexts(extensionContext);
    }

    private List<TestTemplateInvocationContextProvider> validateProviders(ExtensionContext extensionContext, ExtensionRegistry extensionRegistry) {
        List providers = extensionRegistry.stream(TestTemplateInvocationContextProvider.class).filter(provider -> provider.supportsTestTemplate(extensionContext)).collect(Collectors.toList());
        return (List)Preconditions.notEmpty(providers, () -> String.format("You must register at least one %s that supports @TestTemplate method [%s]", TestTemplateInvocationContextProvider.class.getSimpleName(), this.getTestMethod()));
    }

    private Optional<TestDescriptor> toTestDescriptor(TestTemplateInvocationContext invocationContext, int index) {
        UniqueId uniqueId = this.getUniqueId().append("test-template-invocation", "#" + index);
        if (this.getDynamicDescendantFilter().test(uniqueId, index - 1)) {
            return Optional.of(new TestTemplateInvocationTestDescriptor(uniqueId, this.getTestClass(), this.getTestMethod(), invocationContext, index, this.configuration));
        }
        return Optional.empty();
    }

    private void execute(Node.DynamicTestExecutor dynamicTestExecutor, TestDescriptor testDescriptor) {
        testDescriptor.setParent((TestDescriptor)this);
        dynamicTestExecutor.execute(testDescriptor);
    }
}

