/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.attribute.mindmapmode.clipboard;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.swing.JTable;
import org.freeplane.core.io.xml.XMLLocalParserFactory;
import org.freeplane.core.util.TypeReference;
import org.freeplane.features.attribute.Attribute;
import org.freeplane.features.attribute.AttributeController;
import org.freeplane.features.attribute.AttributeSelection;
import org.freeplane.features.attribute.IAttributeTableModel;
import org.freeplane.features.attribute.NodeAttribute;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.attribute.clipboard.AttributeClipboardController;
import org.freeplane.features.attribute.clipboard.AttributeTransferable;
import org.freeplane.features.attribute.mindmapmode.MAttributeController;
import org.freeplane.features.clipboard.mindmapmode.MClipboardController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.n3.nanoxml.IXMLParser;
import org.freeplane.n3.nanoxml.IXMLReader;
import org.freeplane.n3.nanoxml.StdXMLReader;
import org.freeplane.n3.nanoxml.XMLElement;
import org.freeplane.n3.nanoxml.XMLException;

public class MAttributeClipboardController
extends AttributeClipboardController
implements MClipboardController {
    private final MAttributeController attributeController;

    public MAttributeClipboardController(MAttributeController attributeController) {
        this.attributeController = attributeController;
    }

    @Override
    public boolean canPaste(Transferable t) {
        return t.isDataFlavorSupported(AttributeTransferable.attributesFlavor);
    }

    @Override
    public void paste(ActionEvent event, Transferable t) {
        try {
            NodeModel target = Controller.getCurrentController().getSelection().getSelected();
            String transferData = (String)t.getTransferData(AttributeTransferable.attributesFlavor);
            IXMLParser parser = XMLLocalParserFactory.createLocalXMLParser();
            StdXMLReader xmlReader = new StdXMLReader((Reader)new StringReader(transferData));
            parser.setReader((IXMLReader)xmlReader);
            int targetRow = this.targetRow(event);
            while (!xmlReader.atEOF()) {
                XMLElement storage = (XMLElement)parser.parse();
                String name = storage.getAttribute("name", null);
                String object = storage.getAttribute("object", null);
                Object value = TypeReference.create((String)object);
                Attribute attribute = new Attribute(name, value);
                if (targetRow >= 0) {
                    this.attributeController.insertAttribute(target, targetRow++, attribute);
                    continue;
                }
                this.attributeController.addAttribute(target, attribute);
            }
        }
        catch (UnsupportedFlavorException | IOException | XMLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private int targetRow(ActionEvent event) {
        JTable table;
        if (event.getSource() instanceof JTable && (table = (JTable)event.getSource()).getModel() instanceof IAttributeTableModel) {
            int targetRow;
            IAttributeTableModel model = (IAttributeTableModel)table.getModel();
            int selectedRowCount = table.getSelectedRowCount();
            if (selectedRowCount != 0) {
                int[] selectedRows = table.getSelectedRows();
                targetRow = model.targetRow(selectedRows[selectedRows.length - 1]) + 1;
            } else {
                targetRow = 0;
            }
            return targetRow;
        }
        return -1;
    }

    @Override
    public boolean canCut() {
        return this.canCopy();
    }

    @Override
    public void cut() {
        this.copy();
        AttributeSelection attributeSelection = AttributeController.getAttributeSelection();
        attributeSelection.nodeAttributeStream().forEach(this::delete);
    }

    private void delete(NodeAttribute nodeAttribute) {
        NodeModel node = nodeAttribute.node;
        NodeAttributeTableModel model = (NodeAttributeTableModel)node.getExtension(NodeAttributeTableModel.class);
        int attributeIndex = model.getAttributeIndex(nodeAttribute.attribute);
        this.attributeController.performRemoveRow(node, model, attributeIndex);
    }
}

