/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.core.domain.JavaClassDescriptor;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import com.tngtech.archunit.thirdparty.org.objectweb.asm.Handle;
import com.tngtech.archunit.thirdparty.org.objectweb.asm.Type;
import java.util.List;
import java.util.regex.Pattern;

class JavaClassDescriptorImporter {
    private static final String LAMBDA_METAFACTORY_ASM_OBJECT_TYPE_NAME = "java/lang/invoke/LambdaMetafactory";
    private static final Pattern LAMBDA_METHOD_PATTERN = Pattern.compile("lambda\\$.*\\$\\d+");
    private static final Pattern ACCESS_METHOD_PATTERN = Pattern.compile("access\\$\\d+");

    JavaClassDescriptorImporter() {
    }

    static JavaClassDescriptor createFromAsmObjectTypeName(String objectTypeName) {
        return JavaClassDescriptor.From.name(Type.getObjectType(objectTypeName).getClassName());
    }

    static JavaClassDescriptor importAsmType(Object type) {
        return JavaClassDescriptorImporter.importAsmType((Type)type);
    }

    private static JavaClassDescriptor importAsmType(Type type) {
        return JavaClassDescriptor.From.name(type.getClassName());
    }

    static boolean isAsmType(Object value) {
        return value instanceof Type;
    }

    static boolean isAsmMethodHandle(Object value) {
        return value instanceof Handle && JavaClassDescriptorImporter.isAsmMethodHandle((Handle)value);
    }

    private static boolean isAsmMethodHandle(Handle handle) {
        return handle.getDesc().startsWith("(");
    }

    static boolean isLambdaMetafactory(String asmObjectTypeName) {
        return asmObjectTypeName.equals(LAMBDA_METAFACTORY_ASM_OBJECT_TYPE_NAME);
    }

    static boolean isLambdaMethod(Handle methodHandle) {
        return JavaClassDescriptorImporter.isLambdaMethodName(methodHandle.getName());
    }

    static boolean isLambdaMethodName(String methodName) {
        return LAMBDA_METHOD_PATTERN.matcher(methodName).matches();
    }

    static boolean isSyntheticAccessMethodName(String methodName) {
        return ACCESS_METHOD_PATTERN.matcher(methodName).matches();
    }

    static boolean isSyntheticEnumSwitchMapFieldName(String methodName) {
        return methodName.startsWith("$SwitchMap$");
    }

    static Object importAsmTypeIfPossible(Object value) {
        return JavaClassDescriptorImporter.isAsmType(value) ? JavaClassDescriptorImporter.importAsmType(value) : value;
    }

    static JavaClassDescriptor importAsmTypeFromDescriptor(String typeDescriptor) {
        return JavaClassDescriptorImporter.importAsmType(Type.getType(typeDescriptor));
    }

    static List<JavaClassDescriptor> importAsmMethodArgumentTypes(String methodDescriptor) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Type type : Type.getArgumentTypes(methodDescriptor)) {
            result.add(JavaClassDescriptorImporter.importAsmType(type));
        }
        return result.build();
    }

    static JavaClassDescriptor importAsmMethodReturnType(String methodDescriptor) {
        return JavaClassDescriptorImporter.importAsmType(Type.getReturnType(methodDescriptor));
    }
}

