/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.BaseGridShorthandSetter;
import io.sf.carte.doc.style.css.parser.SyntaxParser;
import io.sf.carte.doc.style.css.property.IdentifierValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueList;

class GridShorthandSetter
extends BaseGridShorthandSetter {
    private final String[] subproperties = new String[]{"grid-template-columns", "grid-template-rows", "grid-template-areas", "grid-auto-rows", "grid-auto-columns", "grid-auto-flow"};

    GridShorthandSetter(BaseCSSStyleDeclaration baseCSSStyleDeclaration) {
        super(baseCSSStyleDeclaration, "grid");
    }

    @Override
    protected String[] getShorthandSubproperties() {
        return this.subproperties;
    }

    @Override
    public boolean assignSubproperties() {
        byte by = this.scanForCssWideKeywords(this.currentValue);
        if (by == 1) {
            return true;
        }
        if (by == 2) {
            return false;
        }
        this.setSubpropertiesToDefault();
        if (this.isNoneDeclaration()) {
            this.appendValueItemString("none");
            this.flush();
        } else if (this.fullSyntax()) {
            this.flush();
        } else {
            return false;
        }
        return true;
    }

    @Override
    protected void setSubpropertiesToDefault() {
        String[] stringArray;
        for (String string : stringArray = this.getShorthandSubproperties()) {
            this.setPropertyToDefault(string);
        }
    }

    boolean fullSyntax() {
        Object object;
        Object object2;
        boolean bl = false;
        boolean bl2 = false;
        LexicalUnit lexicalUnit = this.currentValue;
        ValueList valueList = ValueList.createWSValueList();
        ValueList valueList2 = ValueList.createWSValueList();
        Object object3 = null;
        byte by = this.isAutoflowOrDenseKeyword();
        if (by == -1) {
            return false;
        }
        if (by != 0) {
            bl2 = true;
            if (by == 2) {
                this.setGridAutoFlow("row", true);
            } else {
                this.setGridAutoFlow("row", false);
            }
        }
        boolean bl3 = true;
        LexicalUnit.LexicalType lexicalType = LexicalUnit.LexicalType.UNKNOWN;
        block6: do {
            object2 = this.currentValue.getLexicalUnitType();
            switch (object2) {
                case LEFT_BRACKET: {
                    Object object4;
                    LexicalUnit lexicalUnit2;
                    ValueFactory.ListValueItem listValueItem;
                    if (lexicalType == LexicalUnit.LexicalType.STRING) {
                        valueList.add(GridShorthandSetter.createAutoValue());
                    }
                    if ((listValueItem = this.valueFactory.parseBracketList(lexicalUnit2 = this.currentValue.getNextLexicalUnit(), this.styleDeclaration, true)) != null) {
                        object4 = listValueItem.getCSSValue();
                        if (object3 == null) {
                            object3 = object4;
                            valueList.add((StyleValue)object3);
                        } else {
                            ((ValueList)object3).addAll((ValueList)object4);
                        }
                        this.appendValueItemString((StyleValue)object4);
                        this.currentValue = listValueItem.getNextLexicalUnit();
                        lexicalType = object2;
                        break;
                    }
                    this.currentValue = lexicalUnit2.getNextLexicalUnit();
                    break;
                }
                case STRING: {
                    if (lexicalType == LexicalUnit.LexicalType.STRING) {
                        valueList.add(GridShorthandSetter.createAutoValue());
                    }
                    bl = true;
                    object3 = null;
                    if (this.currentValue.getStringValue().length() == 0) {
                        this.syntaxError("Found an empty areas string.");
                        return false;
                    }
                    object = this.createCSSValue();
                    valueList2.add((StyleValue)object);
                    this.appendValueItemString((StyleValue)object);
                    lexicalType = object2;
                    break;
                }
                case OPERATOR_SLASH: {
                    Object object4;
                    if (lexicalType != LexicalUnit.LexicalType.UNKNOWN) {
                        this.currentValue = this.currentValue.getNextLexicalUnit();
                        if (this.currentValue != null) {
                            this.getValueItemBuffer().append(" /");
                            this.getValueItemBufferMini().append('/');
                            by = this.isAutoflowOrDenseKeyword();
                            if (by == -1) {
                                return false;
                            }
                            if (by != 0) {
                                object4 = "grid-auto-columns";
                                if (by == 2) {
                                    this.setGridAutoFlow("column", true);
                                } else {
                                    this.setGridAutoFlow("column", false);
                                }
                                if (bl2) {
                                    this.syntaxError("Found two auto-flow declarations: " + BaseCSSStyleDeclaration.lexicalUnitToString(lexicalUnit));
                                    return false;
                                }
                            } else {
                                object4 = "grid-template-columns";
                            }
                            object = this.valueFactory.createCSSValue(this.currentValue, this.styleDeclaration);
                            object = this.subpropertyValue((StyleValue)object);
                            this.setSubpropertyValue((String)object4, (StyleValue)object);
                            this.appendValueItemString((StyleValue)object);
                            bl3 = false;
                            break block6;
                        }
                        this.syntaxError("Unexpected end of declaration after slash '/' in " + BaseCSSStyleDeclaration.lexicalUnitToString(lexicalUnit));
                    }
                    return false;
                }
                case ATTR: {
                    Object object4 = this.currentValue.shallowClone();
                    CSSValueSyntax cSSValueSyntax = SyntaxParser.createSimpleSyntax("string");
                    if (object4.matches(cSSValueSyntax) == CSSValueSyntax.Match.TRUE) {
                        if (lexicalType == LexicalUnit.LexicalType.STRING) {
                            valueList.add(GridShorthandSetter.createAutoValue());
                        }
                        bl = true;
                        object3 = null;
                        object = this.createCSSValue();
                        valueList2.add((StyleValue)object);
                        this.appendValueItemString((StyleValue)object);
                        lexicalType = object2;
                        break;
                    }
                }
                default: {
                    if (bl && object2 == LexicalUnit.LexicalType.FUNCTION && "repeat".equalsIgnoreCase(this.currentValue.getFunctionName())) {
                        this.syntaxError("This syntax does not allow repeat(): " + BaseCSSStyleDeclaration.lexicalUnitToString(lexicalUnit));
                        return false;
                    }
                    object3 = null;
                    object = this.createCSSValue();
                    valueList.add((StyleValue)object);
                    this.appendValueItemString((StyleValue)object);
                    lexicalType = object2;
                }
            }
        } while (this.currentValue != null);
        if (!bl && bl3) {
            object = "Not a correct rows / columns syntax: " + BaseCSSStyleDeclaration.lexicalUnitToString(lexicalUnit);
            this.syntaxError((String)object);
            return false;
        }
        if (valueList.getLength() != 0) {
            if (!GridShorthandSetter.isAutoOnly(valueList)) {
                object2 = bl2 ? "grid-auto-rows" : "grid-template-rows";
                object = valueList.getLength() != 1 ? valueList : valueList.item(0);
                this.setSubpropertyValue((String)object2, (StyleValue)object);
            } else {
                this.setSubpropertyValue("grid-template-rows", valueList.item(0));
            }
        } else if (bl) {
            object = new IdentifierValue("auto");
            ((PrimitiveValue)object).setSubproperty(true);
            this.setSubpropertyValue("grid-template-rows", (StyleValue)object);
        }
        if (valueList2.getLength() != 0) {
            object = valueList2.getLength() != 1 ? valueList2 : valueList2.item(0);
            this.setSubpropertyValue("grid-template-areas", (StyleValue)object);
        }
        return true;
    }

    private void setGridAutoFlow(String string, boolean bl) {
        StyleValue styleValue;
        IdentifierValue identifierValue = new IdentifierValue(string);
        identifierValue.setSubproperty(true);
        if (!bl) {
            styleValue = identifierValue;
        } else {
            IdentifierValue identifierValue2 = new IdentifierValue("dense");
            identifierValue2.setSubproperty(true);
            ValueList valueList = ValueList.createWSValueList();
            valueList.add(identifierValue);
            valueList.add(identifierValue2);
            styleValue = valueList;
        }
        this.setSubpropertyValue("grid-auto-flow", styleValue);
    }

    private byte isAutoflowOrDenseKeyword() {
        int n = 0;
        if (this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT) {
            StringBuilder stringBuilder;
            String string = this.currentValue.getStringValue();
            if ("auto-flow".equalsIgnoreCase(string)) {
                stringBuilder = this.getValueItemBuffer();
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(' ');
                }
                this.currentValue = this.currentValue.getNextLexicalUnit();
                if (this.currentValue != null && this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && "dense".equalsIgnoreCase(this.currentValue.getStringValue())) {
                    this.appendValueItemString("auto-flow dense");
                    n = 2;
                    this.currentValue = this.currentValue.getNextLexicalUnit();
                } else {
                    this.appendValueItemString("auto-flow");
                    n = 1;
                }
            }
            if ("dense".equalsIgnoreCase(string)) {
                stringBuilder = this.getValueItemBuffer();
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(' ');
                    this.getValueItemBufferMini().append(' ');
                }
                this.currentValue = this.currentValue.getNextLexicalUnit();
                if (this.currentValue != null && this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && "auto-flow".equalsIgnoreCase(this.currentValue.getStringValue())) {
                    this.currentValue = this.currentValue.getNextLexicalUnit();
                    this.appendValueItemString("auto-flow dense");
                    n = 2;
                } else {
                    n = -1;
                }
            }
        }
        return (byte)n;
    }
}

