/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.DefaultDeclarationFormattingContext;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.List;
import org.w3c.dom.css.CSSRule;

public class DefaultStyleFormattingContext
extends DefaultDeclarationFormattingContext
implements StyleFormattingContext {
    private static final long serialVersionUID = 1L;
    private static final String indentingUnit = "    ";
    private final StringBuilder indentString = new StringBuilder(48);
    private CSSRule parentContextRule = null;

    @Override
    public void deepenCurrentContext() {
        this.indentString.append(indentingUnit);
    }

    @Override
    public void endCurrentContext(CSSRule cSSRule) {
        this.updateIndentString(cSSRule.getParentRule());
    }

    @Override
    public void endPropertyDeclaration(SimpleWriter simpleWriter) throws IOException {
        simpleWriter.newLine();
    }

    @Override
    public void endInlinePropertyDeclaration(SimpleWriter simpleWriter) throws IOException {
        simpleWriter.write(' ');
    }

    @Override
    public void endRule(SimpleWriter simpleWriter, List<String> list) throws IOException {
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                simpleWriter.write((CharSequence)" /*");
                simpleWriter.write((CharSequence)list.get(i));
                simpleWriter.write((CharSequence)"*/");
            }
        }
        simpleWriter.newLine();
    }

    @Override
    public void endRuleList(SimpleWriter simpleWriter) throws IOException {
        this.writeFullIndent(simpleWriter);
    }

    @Override
    public void endStyleDeclaration(SimpleWriter simpleWriter) throws IOException {
        this.writeFullIndent(simpleWriter);
    }

    @Override
    public void setParentContext(CSSRule cSSRule) {
        this.parentContextRule = cSSRule;
    }

    @Override
    public void startRule(SimpleWriter simpleWriter, List<String> list) throws IOException {
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                this.writeComment(simpleWriter, list.get(i));
            }
        }
        this.writeFullIndent(simpleWriter);
    }

    @Override
    public void startStyleDeclaration(SimpleWriter simpleWriter) throws IOException {
    }

    @Override
    public void updateContext(CSSRule cSSRule) {
        this.updateIndentString(cSSRule);
    }

    private void updateIndentString(CSSRule cSSRule) {
        this.indentString.setLength(0);
        while (cSSRule != this.parentContextRule) {
            this.deepenCurrentContext();
            cSSRule = cSSRule.getParentRule();
        }
    }

    @Override
    public void writeComment(SimpleWriter simpleWriter, String string) throws IOException {
        this.writeFullIndent(simpleWriter);
        simpleWriter.write((CharSequence)"/*");
        simpleWriter.write((CharSequence)string);
        simpleWriter.write((CharSequence)"*/");
        simpleWriter.newLine();
    }

    @Override
    public void writeFullIndent(SimpleWriter simpleWriter) throws IOException {
        simpleWriter.write((CharSequence)this.indentString);
    }

    @Override
    public void writeImportantPriority(SimpleWriter simpleWriter) throws IOException {
        simpleWriter.write((CharSequence)" ! important");
    }

    @Override
    public void writeLeftCurlyBracket(SimpleWriter simpleWriter) throws IOException {
        simpleWriter.write(' ');
        simpleWriter.write('{');
        simpleWriter.newLine();
    }

    @Override
    public void writeLevelIndent(SimpleWriter simpleWriter) throws IOException {
        simpleWriter.write((CharSequence)indentingUnit);
    }

    @Override
    public void writeRightCurlyBracket(SimpleWriter simpleWriter) throws IOException {
        simpleWriter.write('}');
    }

    @Override
    public void writeSemiColon(SimpleWriter simpleWriter) throws IOException {
        simpleWriter.write(';');
    }

    @Override
    public void writeURL(SimpleWriter simpleWriter, String string) throws IOException {
        Object object;
        AbstractCSSStyleSheetFactory abstractCSSStyleSheetFactory;
        int n = 39;
        if (this.parentContextRule != null && (abstractCSSStyleSheetFactory = ((AbstractCSSRule)(object = (AbstractCSSRule)this.parentContextRule)).getParentStyleSheet().getStyleSheetFactory()).hasFactoryFlag((short)2)) {
            n = 34;
        }
        simpleWriter.write((CharSequence)"url(");
        object = ParseHelper.quote(string, (char)n);
        simpleWriter.write((CharSequence)object);
        simpleWriter.write(')');
    }
}

