/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandSetter;
import io.sf.carte.doc.style.css.property.IdentifierValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.ValueFactory;

class FlexShorthandSetter
extends ShorthandSetter {
    FlexShorthandSetter(BaseCSSStyleDeclaration baseCSSStyleDeclaration) {
        super(baseCSSStyleDeclaration, "flex");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean assignSubproperties() {
        byte by = this.scanForCssWideKeywords(this.currentValue);
        if (by == 1) {
            return true;
        }
        if (by == 2) {
            return false;
        }
        this.setPropertyToDefault("flex-grow");
        this.setPropertyToDefault("flex-shrink");
        this.setPropertyToDefault("flex-basis");
        boolean bl = true;
        boolean bl2 = true;
        int n = 0;
        while (this.currentValue != null) {
            Object object;
            if (n == 2) {
                return false;
            }
            LexicalUnit.LexicalType lexicalType = this.currentValue.getLexicalUnitType();
            if (bl) {
                if (lexicalType == LexicalUnit.LexicalType.INTEGER) {
                    int n2 = this.currentValue.getIntegerValue();
                    if (n2 < 0) {
                        return false;
                    }
                    this.setFlexGrow(n2);
                    bl = false;
                    ++n;
                    byte by2 = this.checkFlexShrink();
                    if (by2 != -1) continue;
                    return false;
                }
                if (lexicalType == LexicalUnit.LexicalType.REAL) {
                    float f = this.currentValue.getFloatValue();
                    if (f < 0.0f) {
                        return false;
                    }
                    this.setFlexGrow(f);
                    bl = false;
                    ++n;
                    byte by3 = this.checkFlexShrink();
                    if (by3 != -1) continue;
                    return false;
                }
            }
            if (bl2 && ValueFactory.isSizeSACUnit(this.currentValue)) {
                object = (TypedValue)this.createCSSValue("flex-basis", this.currentValue);
                if (((TypedValue)object).isNumberZero()) {
                    NumberValue numberValue = new NumberValue();
                    numberValue.setSubproperty(true);
                    numberValue.setIntegerValue(0);
                    object = numberValue;
                }
                this.setSubpropertyValue("flex-basis", (StyleValue)object);
                ++n;
                bl2 = false;
            } else {
                if (lexicalType != LexicalUnit.LexicalType.IDENT) return false;
                object = this.currentValue.getStringValue();
                if ("none".equalsIgnoreCase((String)object)) {
                    if (bl) {
                        this.setFlexGrow(0);
                        this.setFlexShrink(0);
                    }
                    this.setFlexBasisToAuto();
                    n += 2;
                    bl2 = false;
                } else if ("auto".equalsIgnoreCase((String)object)) {
                    if (bl) {
                        this.setFlexGrow(1);
                        this.setFlexShrink(1);
                    }
                    this.setFlexBasisToAuto();
                    n += 2;
                    bl2 = false;
                } else {
                    if (!"content".equalsIgnoreCase((String)object)) return false;
                    this.setSubpropertyValue("flex-basis", this.createCSSValue("flex-basis", this.currentValue));
                    ++n;
                    bl2 = false;
                }
            }
            this.nextCurrentValue();
        }
        this.flush();
        return true;
    }

    private void setFlexGrow(int n) {
        NumberValue numberValue = new NumberValue();
        numberValue.setIntegerValue(n);
        numberValue.setSubproperty(true);
        this.setSubpropertyValue("flex-grow", numberValue);
    }

    private void setFlexGrow(float f) {
        NumberValue numberValue = new NumberValue();
        numberValue.setFloatValue((short)0, f);
        numberValue.setSubproperty(true);
        this.setSubpropertyValue("flex-grow", numberValue);
    }

    private byte checkFlexShrink() {
        this.nextCurrentValue();
        if (this.currentValue != null) {
            LexicalUnit.LexicalType lexicalType = this.currentValue.getLexicalUnitType();
            if (lexicalType == LexicalUnit.LexicalType.INTEGER) {
                int n = this.currentValue.getIntegerValue();
                if (n >= 0) {
                    this.setFlexShrink(n);
                    this.nextCurrentValue();
                    return 1;
                }
                return -1;
            }
            if (lexicalType == LexicalUnit.LexicalType.REAL) {
                float f = this.currentValue.getFloatValue();
                if (f >= 0.0f) {
                    this.setFlexShrink(f);
                    this.nextCurrentValue();
                    return 1;
                }
                return -1;
            }
        }
        return 0;
    }

    private void setFlexShrink(int n) {
        NumberValue numberValue = new NumberValue();
        numberValue.setIntegerValue(n);
        numberValue.setSubproperty(true);
        this.setSubpropertyValue("flex-shrink", numberValue);
    }

    private void setFlexShrink(float f) {
        NumberValue numberValue = new NumberValue();
        numberValue.setFloatValue((short)0, f);
        numberValue.setSubproperty(true);
        this.setSubpropertyValue("flex-shrink", numberValue);
    }

    private void setFlexBasisToAuto() {
        IdentifierValue identifierValue = new IdentifierValue("auto");
        identifierValue.setSubproperty(true);
        this.setSubpropertyValue("flex-basis", identifierValue);
    }

    @Override
    protected void appendValueItemString() {
        StyleValue styleValue;
        if (this.currentValue != null && (styleValue = this.valueFactory.createCSSValueItem(this.currentValue, true).getCSSValue()) != null) {
            String string;
            String string2;
            NumberValue numberValue;
            if (this.currentValue.getNextLexicalUnit() == null && styleValue instanceof NumberValue && (numberValue = (NumberValue)styleValue).isNumberZero()) {
                string = string2 = "0" + numberValue.getDimensionUnitText();
            } else {
                string2 = styleValue.getCssText();
                string = styleValue.getMinifiedCssText(this.getShorthandName());
            }
            StringBuilder stringBuilder = this.getValueItemBuffer();
            StringBuilder stringBuilder2 = this.getValueItemBufferMini();
            int n = stringBuilder.length();
            if (n != 0) {
                stringBuilder2.append(' ');
                stringBuilder.append(' ');
            }
            stringBuilder.append(string2);
            stringBuilder2.append(string);
        }
    }
}

