/*
 * Decompiled with CFR 0.152.
 */
package io.sf.jclf.math.linear3;

public class Matrices {
    public static void inverse3(double[][] a, double[][] inverse) {
        double det = Matrices.determinant3(a);
        if (det == 0.0) {
            throw new IllegalArgumentException("Null determinant.");
        }
        inverse[0][0] = a[2][2] * a[1][1] - a[2][1] * a[1][2];
        inverse[0][1] = a[2][1] * a[0][2] - a[2][2] * a[0][1];
        inverse[0][2] = a[1][2] * a[0][1] - a[1][1] * a[0][2];
        inverse[1][0] = a[2][0] * a[1][2] - a[2][2] * a[1][0];
        inverse[1][1] = a[2][2] * a[0][0] - a[2][0] * a[0][2];
        inverse[1][2] = a[1][0] * a[0][2] - a[1][2] * a[0][0];
        inverse[2][0] = a[2][1] * a[1][0] - a[2][0] * a[1][1];
        inverse[2][1] = a[2][0] * a[0][1] - a[2][1] * a[0][0];
        inverse[2][2] = a[1][1] * a[0][0] - a[1][0] * a[0][1];
        double[] dArray = inverse[0];
        dArray[0] = dArray[0] / det;
        double[] dArray2 = inverse[0];
        dArray2[1] = dArray2[1] / det;
        double[] dArray3 = inverse[0];
        dArray3[2] = dArray3[2] / det;
        double[] dArray4 = inverse[1];
        dArray4[0] = dArray4[0] / det;
        double[] dArray5 = inverse[1];
        dArray5[1] = dArray5[1] / det;
        double[] dArray6 = inverse[1];
        dArray6[2] = dArray6[2] / det;
        double[] dArray7 = inverse[2];
        dArray7[0] = dArray7[0] / det;
        double[] dArray8 = inverse[2];
        dArray8[1] = dArray8[1] / det;
        double[] dArray9 = inverse[2];
        dArray9[2] = dArray9[2] / det;
    }

    public static double determinant3(double[][] a) {
        return a[0][0] * (a[1][1] * a[2][2] - a[2][1] * a[1][2]) - a[1][0] * (a[0][1] * a[2][2] - a[2][1] * a[0][2]) + a[2][0] * (a[0][1] * a[1][2] - a[1][1] * a[0][2]);
    }

    public static void multiplyByVector3(double[][] a, double[] v, double[] result) {
        Matrices.multiplyByVector3(a, v[0], v[1], v[2], result);
    }

    public static void multiplyByVector3(double[][] a, double x, double y, double z, double[] result) {
        result[0] = a[0][0] * x + a[0][1] * y + a[0][2] * z;
        result[1] = a[1][0] * x + a[1][1] * y + a[1][2] * z;
        result[2] = a[2][0] * x + a[2][1] * y + a[2][2] * z;
    }

    public static void multiplyByMatrix3(double[][] a, double[][] b, double[][] result) {
        result[0][0] = a[0][0] * b[0][0] + a[0][1] * b[1][0] + a[0][2] * b[2][0];
        result[0][1] = a[0][0] * b[0][1] + a[0][1] * b[1][1] + a[0][2] * b[2][1];
        result[0][2] = a[0][0] * b[0][2] + a[0][1] * b[1][2] + a[0][2] * b[2][2];
        result[1][0] = a[1][0] * b[0][0] + a[1][1] * b[1][0] + a[1][2] * b[2][0];
        result[1][1] = a[1][0] * b[0][1] + a[1][1] * b[1][1] + a[1][2] * b[2][1];
        result[1][2] = a[1][0] * b[0][2] + a[1][1] * b[1][2] + a[1][2] * b[2][2];
        result[2][0] = a[2][0] * b[0][0] + a[2][1] * b[1][0] + a[2][2] * b[2][0];
        result[2][1] = a[2][0] * b[0][1] + a[2][1] * b[1][1] + a[2][2] * b[2][1];
        result[2][2] = a[2][0] * b[0][2] + a[2][1] * b[1][2] + a[2][2] * b[2][2];
    }

    public static void transpose3(double[][] a) {
        double d = a[0][1];
        a[0][1] = a[1][0];
        a[1][0] = d;
        d = a[0][2];
        a[0][2] = a[2][0];
        a[2][0] = d;
        d = a[1][2];
        a[1][2] = a[2][1];
        a[2][1] = d;
    }

    public static double[][] rotX(double angleRad) {
        double cos = Math.cos(angleRad);
        double sin = Math.sin(angleRad);
        double[][] a = new double[3][3];
        a[0][0] = 1.0;
        a[1][1] = cos;
        a[1][2] = -sin;
        a[2][1] = sin;
        a[2][2] = cos;
        return a;
    }

    public static double[][] rotY(double angleRad) {
        double cos = Math.cos(angleRad);
        double sin = Math.sin(angleRad);
        double[][] a = new double[3][3];
        a[0][0] = cos;
        a[0][2] = sin;
        a[1][1] = 1.0;
        a[2][0] = -sin;
        a[2][2] = cos;
        return a;
    }

    public static double[][] rotZ(double angleRad) {
        double cos = Math.cos(angleRad);
        double sin = Math.sin(angleRad);
        double[][] a = new double[3][3];
        a[0][0] = cos;
        a[0][1] = -sin;
        a[1][0] = sin;
        a[1][1] = cos;
        a[2][2] = 1.0;
        return a;
    }

    public static double[][] rotation(double[] u, double angleRad) {
        double sin = Math.sin(angleRad);
        double cos = Math.cos(angleRad);
        double c1 = 1.0 - cos;
        double[][] a = new double[3][3];
        a[0][0] = cos + u[0] * u[0] * c1;
        a[0][1] = u[0] * u[1] * c1 - u[2] * sin;
        a[0][2] = u[0] * u[2] * c1 + u[1] * sin;
        a[1][0] = u[0] * u[1] * c1 + u[2] * sin;
        a[1][1] = cos + u[1] * u[1] * c1;
        a[1][2] = u[1] * u[2] * c1 - u[0] * sin;
        a[2][0] = u[0] * u[2] * c1 - u[1] * sin;
        a[2][1] = u[1] * u[2] * c1 + u[0] * sin;
        a[2][2] = cos + u[2] * u[2] * c1;
        return a;
    }
}

