/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve;

import com.google.common.base.Objects;
import java.util.Comparator;
import java.util.List;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.attributes.ImmutableAttributesEntry;
import org.gradle.api.internal.attributes.matching.AttributeMatcher;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.resolve.RejectedVersion;
import org.jspecify.annotations.Nullable;

public class RejectedByAttributesVersion
extends RejectedVersion {
    private static final Comparator<AttributeMatcher.MatchingDescription<?>> DESCRIPTION_COMPARATOR = Comparator.comparing(o -> o.getRequested().getKey().getName());
    private final List<AttributeMatcher.MatchingDescription<?>> matchingDescription;

    public RejectedByAttributesVersion(ModuleComponentIdentifier id, List<AttributeMatcher.MatchingDescription<?>> matchingDescription) {
        super(id);
        this.matchingDescription = matchingDescription;
    }

    @Override
    public void describeTo(TreeFormatter builder) {
        this.matchingDescription.sort(DESCRIPTION_COMPARATOR);
        builder.node(this.getId().getVersion());
        builder.startChildren();
        for (AttributeMatcher.MatchingDescription<?> description : this.matchingDescription) {
            builder.node("Attribute '" + description.getRequested().getKey().getName() + "'");
            if (description.isMatch()) {
                builder.append((CharSequence)" matched. ");
            } else {
                builder.append((CharSequence)" didn't match. ");
            }
            builder.append((CharSequence)("Requested " + RejectedByAttributesVersion.prettify(description.getRequested()) + ", was: " + RejectedByAttributesVersion.prettify(description.getFound())));
        }
        builder.endChildren();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RejectedByAttributesVersion that = (RejectedByAttributesVersion)o;
        return Objects.equal((Object)this.getId(), (Object)that.getId());
    }

    @Override
    public int hashCode() {
        return this.getId().hashCode();
    }

    private static String prettify(@Nullable ImmutableAttributesEntry<?> entry) {
        if (entry != null) {
            return "'" + entry.getIsolatedValue() + "'";
        }
        return "not found";
    }

    public List<AttributeMatcher.MatchingDescription<?>> getMatchingDescription() {
        return this.matchingDescription;
    }
}

