/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Map;
import java.util.Properties;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.controller.ConfigurationValidator;
import org.apache.kafka.coordinator.group.GroupConfigManager;
import org.apache.kafka.coordinator.group.GroupCoordinatorConfig;
import org.apache.kafka.coordinator.group.modern.share.ShareGroupConfig;
import org.apache.kafka.server.metrics.ClientMetricsConfigs;
import org.apache.kafka.storage.internals.log.LogConfig;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\t4A!\u0003\u0006\u0001\u001f!A1\u0005\u0001B\u0001B\u0003%A\u0005C\u0003)\u0001\u0011\u0005\u0011\u0006C\u0003-\u0001\u0011%Q\u0006C\u0003B\u0001\u0011%!\tC\u0003E\u0001\u0011%Q\tC\u0003H\u0001\u0011%\u0001\nC\u0003T\u0001\u0011\u0005C\u000bC\u0003T\u0001\u0011\u0005cK\u0001\u0011D_:$(o\u001c7mKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]Z\u000bG.\u001b3bi>\u0014(BA\u0006\r\u0003\u0019\u0019XM\u001d<fe*\tQ\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001\u0001\u0002\u0004\u0005\u0002\u0012-5\t!C\u0003\u0002\u0014)\u0005!A.\u00198h\u0015\u0005)\u0012\u0001\u00026bm\u0006L!a\u0006\n\u0003\r=\u0013'.Z2u!\tI\u0012%D\u0001\u001b\u0015\tYB$\u0001\u0006d_:$(o\u001c7mKJT!!D\u000f\u000b\u0005yy\u0012AB1qC\u000eDWMC\u0001!\u0003\ry'oZ\u0005\u0003Ei\u0011acQ8oM&<WO]1uS>tg+\u00197jI\u0006$xN]\u0001\fW\u000647.Y\"p]\u001aLw\r\u0005\u0002&M5\t!\"\u0003\u0002(\u0015\tY1*\u00194lC\u000e{gNZ5h\u0003\u0019a\u0014N\\5u}Q\u0011!f\u000b\t\u0003K\u0001AQa\t\u0002A\u0002\u0011\n\u0011C^1mS\u0012\fG/\u001a+pa&\u001cg*Y7f)\tqC\u0007\u0005\u00020e5\t\u0001GC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0004G\u0001\u0003V]&$\b\"B\u001b\u0004\u0001\u00041\u0014\u0001\u00028b[\u0016\u0004\"a\u000e \u000f\u0005ab\u0004CA\u001d1\u001b\u0005Q$BA\u001e\u000f\u0003\u0019a$o\\8u}%\u0011Q\bM\u0001\u0007!J,G-\u001a4\n\u0005}\u0002%AB*ue&twM\u0003\u0002>a\u0005\u0011b/\u00197jI\u0006$XM\u0011:pW\u0016\u0014h*Y7f)\tq3\tC\u00036\t\u0001\u0007a'A\twC2LG-\u0019;f\u000fJ|W\u000f\u001d(b[\u0016$\"A\f$\t\u000bU*\u0001\u0019\u0001\u001c\u0002IQD'o\\<Fq\u000e,\u0007\u000f^5p]\u001a{'/\u00168l]><hNU3t_V\u00148-\u001a+za\u0016$\"AL%\t\u000b)3\u0001\u0019A&\u0002\u0011I,7o\\;sG\u0016\u0004\"\u0001T)\u000e\u00035S!AT(\u0002\r\r|gNZ5h\u0015\t\u0001F$\u0001\u0004d_6lwN\\\u0005\u0003%6\u0013abQ8oM&<'+Z:pkJ\u001cW-\u0001\u0005wC2LG-\u0019;f)\tqS\u000bC\u0003K\u000f\u0001\u00071\n\u0006\u0003//b\u0003\u0007\"\u0002&\t\u0001\u0004Y\u0005\"B-\t\u0001\u0004Q\u0016A\u00038fo\u000e{gNZ5hgB!1L\u0018\u001c7\u001b\u0005a&BA/\u0015\u0003\u0011)H/\u001b7\n\u0005}c&aA'ba\")\u0011\r\u0003a\u00015\u0006Qq\u000e\u001c3D_:4\u0017nZ:")
public class ControllerConfigurationValidator
implements ConfigurationValidator {
    private final KafkaConfig kafkaConfig;

    private void validateTopicName(String name) {
        if (name.isEmpty()) {
            throw new InvalidRequestException("Default topic resources are not allowed.");
        }
        Topic.validate((String)name);
    }

    private void validateBrokerName(String name) {
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(name))) {
            Integer n;
            try {
                n = Integer.valueOf(name);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidRequestException("Unable to parse broker name as a base 10 number.");
            }
            Integer brokerId = n;
            if (Predef$.MODULE$.Integer2int(brokerId) < 0) {
                throw new InvalidRequestException("Invalid negative broker ID.");
            }
            return;
        }
    }

    private void validateGroupName(String name) {
        if (name.isEmpty()) {
            throw new InvalidRequestException("Default group resources are not allowed.");
        }
    }

    private void throwExceptionForUnknownResourceType(ConfigResource resource) {
        throw new InvalidRequestException("Unknown resource type " + resource.type());
    }

    public void validate(ConfigResource resource) {
        ConfigResource.Type type = resource.type();
        if (ConfigResource.Type.TOPIC.equals(type)) {
            this.validateTopicName(resource.name());
            return;
        }
        if (ConfigResource.Type.BROKER.equals(type)) {
            this.validateBrokerName(resource.name());
            return;
        }
        this.throwExceptionForUnknownResourceType(resource);
    }

    public void validate(ConfigResource resource, Map<String, String> newConfigs, Map<String, String> oldConfigs) {
        ConfigResource.Type type = resource.type();
        if (ConfigResource.Type.TOPIC.equals(type)) {
            this.validateTopicName(resource.name());
            Properties properties = new Properties();
            ArrayBuffer nullTopicConfigs = new ArrayBuffer();
            newConfigs.forEach((key, value) -> {
                if (value == null) {
                    nullTopicConfigs.$plus$eq(key);
                    return;
                }
                properties.setProperty((String)key, (String)value);
            });
            if (nullTopicConfigs.nonEmpty()) {
                throw new InvalidConfigurationException("Null value not supported for topic configs: " + nullTopicConfigs.mkString(","));
            }
            LogConfig.validate(oldConfigs, (Properties)properties, this.kafkaConfig.extractLogConfigMap(), (boolean)this.kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled());
            return;
        }
        if (ConfigResource.Type.BROKER.equals(type)) {
            this.validateBrokerName(resource.name());
            return;
        }
        if (ConfigResource.Type.CLIENT_METRICS.equals(type)) {
            Properties properties = new Properties();
            newConfigs.forEach((key, value) -> properties.setProperty((String)key, (String)value));
            ClientMetricsConfigs.validate((String)resource.name(), (Properties)properties);
            return;
        }
        if (ConfigResource.Type.GROUP.equals(type)) {
            this.validateGroupName(resource.name());
            Properties properties = new Properties();
            ArrayBuffer nullGroupConfigs = new ArrayBuffer();
            newConfigs.forEach((key, value) -> {
                if (value == null) {
                    nullGroupConfigs.$plus$eq(key);
                    return;
                }
                properties.setProperty((String)key, (String)value);
            });
            if (nullGroupConfigs.nonEmpty()) {
                throw new InvalidConfigurationException("Null value not supported for group configs: " + nullGroupConfigs.mkString(","));
            }
            GroupConfigManager.validate((Properties)properties, (GroupCoordinatorConfig)this.kafkaConfig.groupCoordinatorConfig(), (ShareGroupConfig)this.kafkaConfig.shareGroupConfig());
            return;
        }
        this.throwExceptionForUnknownResourceType(resource);
    }

    public ControllerConfigurationValidator(KafkaConfig kafkaConfig) {
        this.kafkaConfig = kafkaConfig;
    }
}

